/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.admin.cluster.desirednodes.UpdateDesiredNodesAction;
import org.elasticsearch.action.admin.cluster.desirednodes.UpdateDesiredNodesRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;

public class RestUpdateDesiredNodesAction
extends BaseRestHandler {
    @Override
    public String getName() {
        return "update_desired_nodes";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "_internal/desired_nodes/{history_id}/{version}"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        UpdateDesiredNodesRequest updateDesiredNodesRequest;
        String historyId = request.param("history_id");
        long version = request.paramAsLong("version", Long.MIN_VALUE);
        try (XContentParser parser = request.contentParser();){
            updateDesiredNodesRequest = UpdateDesiredNodesRequest.fromXContent(historyId, version, parser);
        }
        updateDesiredNodesRequest.masterNodeTimeout(request.paramAsTime("master_timeout", updateDesiredNodesRequest.masterNodeTimeout()));
        return restChannel -> client.execute(UpdateDesiredNodesAction.INSTANCE, updateDesiredNodesRequest, new RestToXContentListener((RestChannel)restChannel));
    }
}

