/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.FinalizeSnapshotContext;
import org.elasticsearch.repositories.GetSnapshotInfoContext;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardSnapshotResult;
import org.elasticsearch.repositories.SnapshotShardContext;
import org.elasticsearch.snapshots.SnapshotId;

public class UnknownTypeRepository
extends AbstractLifecycleComponent
implements Repository {
    private final RepositoryMetadata repositoryMetadata;

    public UnknownTypeRepository(RepositoryMetadata repositoryMetadata) {
        this.repositoryMetadata = repositoryMetadata;
    }

    private RepositoryException createUnknownTypeException() {
        return new RepositoryException(this.repositoryMetadata.name(), "repository type [" + this.repositoryMetadata.type() + "] is unknown; ensure that all required plugins are installed on this node");
    }

    @Override
    public RepositoryMetadata getMetadata() {
        return this.repositoryMetadata;
    }

    @Override
    public void getSnapshotInfo(GetSnapshotInfoContext context) {
        throw this.createUnknownTypeException();
    }

    @Override
    public Metadata getSnapshotGlobalMetadata(SnapshotId snapshotId) {
        throw this.createUnknownTypeException();
    }

    @Override
    public IndexMetadata getSnapshotIndexMetaData(RepositoryData repositoryData, SnapshotId snapshotId, IndexId index) throws IOException {
        throw this.createUnknownTypeException();
    }

    @Override
    public void getRepositoryData(ActionListener<RepositoryData> listener) {
        listener.onFailure(this.createUnknownTypeException());
    }

    @Override
    public void finalizeSnapshot(FinalizeSnapshotContext finalizeSnapshotContext) {
        finalizeSnapshotContext.onFailure(this.createUnknownTypeException());
    }

    @Override
    public void deleteSnapshots(Collection<SnapshotId> snapshotIds, long repositoryStateId, Version repositoryMetaVersion, ActionListener<RepositoryData> listener) {
        listener.onFailure(this.createUnknownTypeException());
    }

    @Override
    public long getSnapshotThrottleTimeInNanos() {
        throw this.createUnknownTypeException();
    }

    @Override
    public long getRestoreThrottleTimeInNanos() {
        throw this.createUnknownTypeException();
    }

    @Override
    public String startVerification() {
        throw this.createUnknownTypeException();
    }

    @Override
    public void endVerification(String verificationToken) {
        throw this.createUnknownTypeException();
    }

    @Override
    public void verify(String verificationToken, DiscoveryNode localNode) {
        throw this.createUnknownTypeException();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void snapshotShard(SnapshotShardContext snapshotShardContext) {
        snapshotShardContext.onFailure(this.createUnknownTypeException());
    }

    @Override
    public void restoreShard(Store store, SnapshotId snapshotId, IndexId indexId, ShardId snapshotShardId, RecoveryState recoveryState, ActionListener<Void> listener) {
        listener.onFailure(this.createUnknownTypeException());
    }

    @Override
    public IndexShardSnapshotStatus getShardSnapshotStatus(SnapshotId snapshotId, IndexId indexId, ShardId shardId) {
        throw this.createUnknownTypeException();
    }

    @Override
    public void updateState(ClusterState state) {
    }

    @Override
    public void executeConsistentStateUpdate(Function<RepositoryData, ClusterStateUpdateTask> createUpdateTask, String source, Consumer<Exception> onFailure) {
        onFailure.accept(this.createUnknownTypeException());
    }

    @Override
    public void cloneShardSnapshot(SnapshotId source, SnapshotId target, RepositoryShardId shardId, ShardGeneration shardGeneration, ActionListener<ShardSnapshotResult> listener) {
        listener.onFailure(this.createUnknownTypeException());
    }

    @Override
    public void awaitIdle() {
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() throws IOException {
    }
}

