/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.action.admin.indices.stats.IndexShardStats;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.env.ShardLockObtainFailedException;
import org.elasticsearch.gateway.MetaStateService;
import org.elasticsearch.gateway.MetadataStateFormat;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.bulk.stats.BulkStats;
import org.elasticsearch.index.cache.request.ShardRequestCache;
import org.elasticsearch.index.engine.CommitStats;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.engine.InternalEngineFactory;
import org.elasticsearch.index.engine.NoOpEngine;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.MapperRegistry;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.CoordinatorRewriteContextProvider;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.recovery.RecoveryStats;
import org.elasticsearch.index.refresh.RefreshStats;
import org.elasticsearch.index.search.stats.SearchStats;
import org.elasticsearch.index.seqno.RetentionLeaseStats;
import org.elasticsearch.index.seqno.RetentionLeaseSyncer;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.IndexingStats;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.AbstractIndexShardCacheEntity;
import org.elasticsearch.indices.IndexingMemoryController;
import org.elasticsearch.indices.IndicesQueryCache;
import org.elasticsearch.indices.IndicesRequestCache;
import org.elasticsearch.indices.NodeIndicesStats;
import org.elasticsearch.indices.TimestampFieldMapperService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.elasticsearch.indices.recovery.PeerRecoveryTargetService;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.indices.store.CompositeIndexFoldersDeletionListener;
import org.elasticsearch.node.Node;
import org.elasticsearch.plugins.IndexStorePlugin;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.query.QueryPhase;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class IndicesService
extends AbstractLifecycleComponent
implements IndicesClusterStateService.AllocatedIndices<IndexShard, IndexService>,
IndexService.ShardStoreDeleter {
    private static final Logger logger = LogManager.getLogger(IndicesService.class);
    public static final String INDICES_SHARDS_CLOSED_TIMEOUT = "indices.shards_closed_timeout";
    public static final Setting<TimeValue> INDICES_CACHE_CLEAN_INTERVAL_SETTING = Setting.positiveTimeSetting("indices.cache.cleanup_interval", TimeValue.timeValueMinutes((long)1L), Setting.Property.NodeScope);
    public static final Setting<Boolean> INDICES_ID_FIELD_DATA_ENABLED_SETTING = Setting.boolSetting("indices.id_field_data.enabled", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> WRITE_DANGLING_INDICES_INFO_SETTING = Setting.boolSetting("gateway.write_dangling_indices_info", true, Setting.Property.NodeScope);
    private final Settings settings;
    private final PluginsService pluginsService;
    private final NodeEnvironment nodeEnv;
    private final XContentParserConfiguration parserConfig;
    private final TimeValue shardsClosedTimeout;
    private final AnalysisRegistry analysisRegistry;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final IndexScopedSettings indexScopedSettings;
    private final IndicesFieldDataCache indicesFieldDataCache;
    private final CacheCleaner cacheCleaner;
    private final ThreadPool threadPool;
    private final CircuitBreakerService circuitBreakerService;
    private final BigArrays bigArrays;
    private final ScriptService scriptService;
    private final ClusterService clusterService;
    private final Client client;
    private volatile Map<String, IndexService> indices = Collections.emptyMap();
    private final Map<Index, List<PendingDelete>> pendingDeletes = new HashMap<Index, List<PendingDelete>>();
    private final AtomicInteger numUncompletedDeletes = new AtomicInteger();
    private final OldShardsStats oldShardsStats = new OldShardsStats();
    private final MapperRegistry mapperRegistry;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final Map<String, IndexStorePlugin.SnapshotCommitSupplier> snapshotCommitSuppliers;
    private final IndexingMemoryController indexingMemoryController;
    private final TimeValue cleanInterval;
    final IndicesRequestCache indicesRequestCache;
    private final IndicesQueryCache indicesQueryCache;
    private final MetaStateService metaStateService;
    private final Collection<Function<IndexSettings, Optional<EngineFactory>>> engineFactoryProviders;
    private final Map<String, IndexStorePlugin.DirectoryFactory> directoryFactories;
    private final Map<String, IndexStorePlugin.RecoveryStateFactory> recoveryStateFactories;
    private final IndexStorePlugin.IndexFoldersDeletionListener indexFoldersDeletionListeners;
    final AbstractRefCounted indicesRefCount;
    private final CountDownLatch closeLatch = new CountDownLatch(1);
    private volatile boolean idFieldDataEnabled;
    private volatile boolean allowExpensiveQueries;
    private final IdFieldMapper idFieldMapper = new IdFieldMapper(() -> this.idFieldDataEnabled);
    @Nullable
    private final EsThreadPoolExecutor danglingIndicesThreadPoolExecutor;
    private final Set<Index> danglingIndicesToWrite = Sets.newConcurrentHashSet();
    private final boolean nodeWriteDanglingIndicesInfo;
    private final ValuesSourceRegistry valuesSourceRegistry;
    private final TimestampFieldMapperService timestampFieldMapperService;
    private final CheckedBiConsumer<ShardSearchRequest, StreamOutput, IOException> requestCacheKeyDifferentiator;
    private static final String DANGLING_INDICES_UPDATE_THREAD_NAME = "DanglingIndices#updateTask";
    private final IndexDeletionAllowedPredicate DEFAULT_INDEX_DELETION_PREDICATE = (index, indexSettings) -> this.canDeleteIndexContents(index);
    private final IndexDeletionAllowedPredicate ALWAYS_TRUE = (index, indexSettings) -> true;

    @Override
    protected void doStart() {
        this.threadPool.schedule(this.cacheCleaner, this.cleanInterval, "same");
        this.clusterService.addStateApplier(this.timestampFieldMapperService);
    }

    public IndicesService(Settings settings, PluginsService pluginsService, NodeEnvironment nodeEnv, NamedXContentRegistry xContentRegistry, AnalysisRegistry analysisRegistry, IndexNameExpressionResolver indexNameExpressionResolver, MapperRegistry mapperRegistry, NamedWriteableRegistry namedWriteableRegistry, ThreadPool threadPool, IndexScopedSettings indexScopedSettings, final CircuitBreakerService circuitBreakerService, BigArrays bigArrays, ScriptService scriptService, ClusterService clusterService, Client client, MetaStateService metaStateService, Collection<Function<IndexSettings, Optional<EngineFactory>>> engineFactoryProviders, Map<String, IndexStorePlugin.DirectoryFactory> directoryFactories, ValuesSourceRegistry valuesSourceRegistry, Map<String, IndexStorePlugin.RecoveryStateFactory> recoveryStateFactories, List<IndexStorePlugin.IndexFoldersDeletionListener> indexFoldersDeletionListeners, Map<String, IndexStorePlugin.SnapshotCommitSupplier> snapshotCommitSuppliers, CheckedBiConsumer<ShardSearchRequest, StreamOutput, IOException> requestCacheKeyDifferentiator) {
        this.settings = settings;
        this.threadPool = threadPool;
        this.pluginsService = pluginsService;
        this.nodeEnv = nodeEnv;
        this.parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE).withRegistry(xContentRegistry);
        this.valuesSourceRegistry = valuesSourceRegistry;
        this.shardsClosedTimeout = settings.getAsTime(INDICES_SHARDS_CLOSED_TIMEOUT, new TimeValue(1L, TimeUnit.DAYS));
        this.analysisRegistry = analysisRegistry;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.indicesRequestCache = new IndicesRequestCache(settings);
        this.indicesQueryCache = new IndicesQueryCache(settings);
        this.mapperRegistry = mapperRegistry;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.indexingMemoryController = new IndexingMemoryController(settings, threadPool, () -> Iterables.flatten(this).iterator());
        this.indexScopedSettings = indexScopedSettings;
        this.circuitBreakerService = circuitBreakerService;
        this.bigArrays = bigArrays;
        this.scriptService = scriptService;
        this.clusterService = clusterService;
        this.client = client;
        this.idFieldDataEnabled = INDICES_ID_FIELD_DATA_ENABLED_SETTING.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(INDICES_ID_FIELD_DATA_ENABLED_SETTING, this::setIdFieldDataEnabled);
        this.indicesFieldDataCache = new IndicesFieldDataCache(settings, new IndexFieldDataCache.Listener(){

            @Override
            public void onRemoval(ShardId shardId, String fieldName, boolean wasEvicted, long sizeInBytes) {
                assert (sizeInBytes >= 0L) : "When reducing circuit breaker, it should be adjusted with a number higher or equal to 0 and not [" + sizeInBytes + "]";
                circuitBreakerService.getBreaker("fielddata").addWithoutBreaking(-sizeInBytes);
            }
        });
        this.cleanInterval = INDICES_CACHE_CLEAN_INTERVAL_SETTING.get(settings);
        this.cacheCleaner = new CacheCleaner(this.indicesFieldDataCache, this.indicesRequestCache, logger, threadPool, this.cleanInterval);
        this.metaStateService = metaStateService;
        this.engineFactoryProviders = engineFactoryProviders;
        for (String indexStoreType : directoryFactories.keySet()) {
            if (!IndexModule.isBuiltinType(indexStoreType)) continue;
            throw new IllegalStateException("registered index store type [" + indexStoreType + "] conflicts with a built-in type");
        }
        this.directoryFactories = directoryFactories;
        this.recoveryStateFactories = recoveryStateFactories;
        this.indexFoldersDeletionListeners = new CompositeIndexFoldersDeletionListener(indexFoldersDeletionListeners);
        this.snapshotCommitSuppliers = snapshotCommitSuppliers;
        this.requestCacheKeyDifferentiator = requestCacheKeyDifferentiator;
        this.indicesRefCount = AbstractRefCounted.of(() -> {
            try {
                IOUtils.close((Closeable[])new Closeable[]{analysisRegistry, this.indexingMemoryController, this.indicesFieldDataCache, this.cacheCleaner, this.indicesRequestCache, this.indicesQueryCache});
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.closeLatch.countDown();
            }
        });
        String nodeName = Objects.requireNonNull(Node.NODE_NAME_SETTING.get(settings));
        this.nodeWriteDanglingIndicesInfo = WRITE_DANGLING_INDICES_INFO_SETTING.get(settings);
        this.danglingIndicesThreadPoolExecutor = this.nodeWriteDanglingIndicesInfo ? EsExecutors.newScaling(nodeName + "/DanglingIndices#updateTask", 1, 1, 0L, TimeUnit.MILLISECONDS, true, EsExecutors.daemonThreadFactory(nodeName, DANGLING_INDICES_UPDATE_THREAD_NAME), threadPool.getThreadContext()) : null;
        this.allowExpensiveQueries = SearchService.ALLOW_EXPENSIVE_QUERIES.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SearchService.ALLOW_EXPENSIVE_QUERIES, this::setAllowExpensiveQueries);
        this.timestampFieldMapperService = new TimestampFieldMapperService(settings, threadPool, this);
    }

    public ClusterService clusterService() {
        return this.clusterService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        this.clusterService.removeApplier(this.timestampFieldMapperService);
        this.timestampFieldMapperService.doStop();
        ThreadPool.terminate(this.danglingIndicesThreadPoolExecutor, 10L, TimeUnit.SECONDS);
        ExecutorService indicesStopExecutor = Executors.newFixedThreadPool(5, EsExecutors.daemonThreadFactory(this.settings, "indices_shutdown"));
        Set indices = this.indices.values().stream().map(s -> s.index()).collect(Collectors.toSet());
        CountDownLatch latch = new CountDownLatch(indices.size());
        for (Index index : indices) {
            indicesStopExecutor.execute(() -> {
                try {
                    this.removeIndex(index, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.SHUTDOWN, "shutdown");
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            if (!latch.await(this.shardsClosedTimeout.seconds(), TimeUnit.SECONDS)) {
                logger.warn("Not all shards are closed yet, waited {}sec - stopping service", (Object)this.shardsClosedTimeout.seconds());
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            indicesStopExecutor.shutdown();
        }
    }

    @Override
    protected void doClose() throws IOException {
        this.indicesRefCount.decRef();
    }

    public boolean awaitClose(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.closeLatch.await(timeout, timeUnit);
    }

    public NodeIndicesStats stats(CommonStatsFlags flags) {
        CommonStats commonStats = new CommonStats(flags);
        block10: for (CommonStatsFlags.Flag flag : flags.getFlags()) {
            switch (flag) {
                case Get: {
                    commonStats.get.add(this.oldShardsStats.getStats);
                    continue block10;
                }
                case Indexing: {
                    commonStats.indexing.add(this.oldShardsStats.indexingStats);
                    continue block10;
                }
                case Search: {
                    commonStats.search.add(this.oldShardsStats.searchStats);
                    continue block10;
                }
                case Merge: {
                    commonStats.merge.add(this.oldShardsStats.mergeStats);
                    continue block10;
                }
                case Refresh: {
                    commonStats.refresh.add(this.oldShardsStats.refreshStats);
                    continue block10;
                }
                case Recovery: {
                    commonStats.recoveryStats.add(this.oldShardsStats.recoveryStats);
                    continue block10;
                }
                case Flush: {
                    commonStats.flush.add(this.oldShardsStats.flushStats);
                    continue block10;
                }
                case Bulk: {
                    commonStats.bulk.add(this.oldShardsStats.bulkStats);
                }
            }
        }
        return new NodeIndicesStats(commonStats, this.statsByShard(this, flags));
    }

    Map<Index, List<IndexShardStats>> statsByShard(IndicesService indicesService, CommonStatsFlags flags) {
        HashMap<Index, List<IndexShardStats>> statsByShard = new HashMap<Index, List<IndexShardStats>>();
        for (IndexService indexService : indicesService) {
            for (IndexShard indexShard : indexService) {
                try {
                    IndexShardStats indexShardStats = indicesService.indexShardStats(indicesService, indexShard, flags);
                    if (indexShardStats == null) continue;
                    if (!statsByShard.containsKey(indexService.index())) {
                        statsByShard.put(indexService.index(), CollectionUtils.arrayAsArrayList(indexShardStats));
                        continue;
                    }
                    ((List)statsByShard.get(indexService.index())).add(indexShardStats);
                }
                catch (AlreadyClosedException | IllegalIndexShardStateException e) {
                    logger.trace(() -> new ParameterizedMessage("{} ignoring shard stats", (Object)indexShard.shardId()), e);
                }
            }
        }
        return statsByShard;
    }

    IndexShardStats indexShardStats(IndicesService indicesService, IndexShard indexShard, CommonStatsFlags flags) {
        RetentionLeaseStats retentionLeaseStats;
        SeqNoStats seqNoStats;
        CommitStats commitStats;
        if (indexShard.routingEntry() == null) {
            return null;
        }
        try {
            commitStats = indexShard.commitStats();
            seqNoStats = indexShard.seqNoStats();
            retentionLeaseStats = indexShard.getRetentionLeaseStats();
        }
        catch (AlreadyClosedException e) {
            commitStats = null;
            seqNoStats = null;
            retentionLeaseStats = null;
        }
        return new IndexShardStats(indexShard.shardId(), new ShardStats[]{new ShardStats(indexShard.routingEntry(), indexShard.shardPath(), new CommonStats(indicesService.getIndicesQueryCache(), indexShard, flags), commitStats, seqNoStats, retentionLeaseStats)});
    }

    private void ensureChangesAllowed() {
        if (!this.lifecycle.started()) {
            throw new IllegalStateException("Can't make changes to indices service, node is closed");
        }
    }

    @Override
    public Iterator<IndexService> iterator() {
        return this.indices.values().iterator();
    }

    public boolean hasIndex(Index index) {
        return this.indices.containsKey(index.getUUID());
    }

    @Override
    @Nullable
    public IndexService indexService(Index index) {
        return this.indices.get(index.getUUID());
    }

    public IndexService indexServiceSafe(Index index) {
        IndexService indexService = this.indices.get(index.getUUID());
        if (indexService == null) {
            throw new IndexNotFoundException(index);
        }
        assert (indexService.indexUUID().equals(index.getUUID())) : "uuid mismatch local: " + indexService.indexUUID() + " incoming: " + index.getUUID();
        return indexService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized IndexService createIndex(IndexMetadata indexMetadata, List<IndexEventListener> builtInListeners, boolean writeDanglingIndices) throws IOException {
        this.ensureChangesAllowed();
        if (indexMetadata.getIndexUUID().equals("_na_")) {
            throw new IllegalArgumentException("index must have a real UUID found value: [" + indexMetadata.getIndexUUID() + "]");
        }
        Index index = indexMetadata.getIndex();
        if (this.hasIndex(index)) {
            throw new ResourceAlreadyExistsException(index);
        }
        ArrayList<IndexEventListener> finalListeners = new ArrayList<IndexEventListener>(builtInListeners);
        IndexEventListener onStoreClose = new IndexEventListener(){

            @Override
            public void onStoreCreated(ShardId shardId) {
                IndicesService.this.indicesRefCount.incRef();
            }

            @Override
            public void onStoreClosed(ShardId shardId) {
                try {
                    IndicesService.this.indicesQueryCache.onClose(shardId);
                }
                finally {
                    IndicesService.this.indicesRefCount.decRef();
                }
            }
        };
        finalListeners.add(onStoreClose);
        finalListeners.add(this.oldShardsStats);
        IndexService indexService = this.createIndexService(IndexService.IndexCreationContext.CREATE_INDEX, indexMetadata, this.indicesQueryCache, this.indicesFieldDataCache, finalListeners, this.indexingMemoryController);
        boolean success = false;
        try {
            if (writeDanglingIndices && this.nodeWriteDanglingIndicesInfo) {
                indexService.addMetadataListener(imd -> this.updateDanglingIndicesInfo(index));
            }
            indexService.getIndexEventListener().afterIndexCreated(indexService);
            this.indices = Maps.copyMapWithAddedEntry(this.indices, index.getUUID(), indexService);
            if (writeDanglingIndices) {
                if (this.nodeWriteDanglingIndicesInfo) {
                    this.updateDanglingIndicesInfo(index);
                } else {
                    indexService.deleteDanglingIndicesInfo();
                }
            }
            success = true;
            IndexService indexService2 = indexService;
            return indexService2;
        }
        finally {
            if (!success) {
                indexService.close("plugins_failed", true);
            }
        }
    }

    public <T, E extends Exception> T withTempIndexService(IndexMetadata indexMetadata, CheckedFunction<IndexService, T, E> indexServiceConsumer) throws IOException, E {
        final Index index = indexMetadata.getIndex();
        if (this.hasIndex(index)) {
            throw new ResourceAlreadyExistsException(index);
        }
        List<IndexEventListener> finalListeners = List.of(new IndexEventListener(){

            @Override
            public void beforeIndexShardCreated(ShardRouting shardRouting, Settings indexSettings) {
                assert (false) : "temp index should not trigger shard creation";
                throw new ElasticsearchException("temp index should not trigger shard creation [{}]", index);
            }

            @Override
            public void onStoreCreated(ShardId shardId) {
                assert (false) : "temp index should not trigger store creation";
                throw new ElasticsearchException("temp index should not trigger store creation [{}]", index);
            }
        });
        IndexService indexService = this.createIndexService(IndexService.IndexCreationContext.CREATE_INDEX, indexMetadata, this.indicesQueryCache, this.indicesFieldDataCache, finalListeners, this.indexingMemoryController);
        try (Closeable dummy = () -> indexService.close("temp", false);){
            Object object = indexServiceConsumer.apply((Object)indexService);
            return (T)object;
        }
    }

    private synchronized IndexService createIndexService(IndexService.IndexCreationContext indexCreationContext, IndexMetadata indexMetadata, IndicesQueryCache indicesQueryCache, IndicesFieldDataCache indicesFieldDataCache, List<IndexEventListener> builtInListeners, IndexingOperationListener ... indexingOperationListeners) throws IOException {
        IndexSettings idxSettings = new IndexSettings(indexMetadata, this.settings, this.indexScopedSettings);
        this.indexScopedSettings.validate(indexMetadata.getSettings(), true, true, true);
        logger.debug("creating Index [{}], shards [{}]/[{}] - reason [{}]", (Object)indexMetadata.getIndex(), (Object)idxSettings.getNumberOfShards(), (Object)idxSettings.getNumberOfReplicas(), (Object)indexCreationContext);
        IndexModule indexModule = new IndexModule(idxSettings, this.analysisRegistry, this.getEngineFactory(idxSettings), this.directoryFactories, () -> this.allowExpensiveQueries, this.indexNameExpressionResolver, this.recoveryStateFactories);
        for (IndexingOperationListener operationListener : indexingOperationListeners) {
            indexModule.addIndexOperationListener(operationListener);
        }
        this.pluginsService.onIndexModule(indexModule);
        for (IndexEventListener listener : builtInListeners) {
            indexModule.addIndexEventListener(listener);
        }
        return indexModule.newIndexService(indexCreationContext, this.nodeEnv, this.parserConfig, this, this.circuitBreakerService, this.bigArrays, this.threadPool, this.scriptService, this.clusterService, this.client, indicesQueryCache, this.mapperRegistry, indicesFieldDataCache, this.namedWriteableRegistry, this.idFieldMapper, this.valuesSourceRegistry, this.indexFoldersDeletionListeners, this.snapshotCommitSuppliers);
    }

    private EngineFactory getEngineFactory(IndexSettings idxSettings) {
        IndexMetadata indexMetadata = idxSettings.getIndexMetadata();
        if (indexMetadata != null && indexMetadata.getState() == IndexMetadata.State.CLOSE) {
            return NoOpEngine::new;
        }
        List engineFactories = this.engineFactoryProviders.stream().map(engineFactoryProvider -> (Optional)engineFactoryProvider.apply(idxSettings)).filter(maybe -> Objects.requireNonNull(maybe).isPresent()).collect(Collectors.toList());
        if (engineFactories.isEmpty()) {
            return new InternalEngineFactory();
        }
        if (engineFactories.size() == 1) {
            assert (((Optional)engineFactories.get(0)).isPresent());
            return (EngineFactory)((Optional)engineFactories.get(0)).get();
        }
        String message = String.format(Locale.ROOT, "multiple engine factories provided for %s: %s", idxSettings.getIndex(), engineFactories.stream().map(t -> {
            assert (t.isPresent());
            return "[" + ((EngineFactory)t.get()).getClass().getName() + "]";
        }).collect(Collectors.joining(",")));
        throw new IllegalStateException(message);
    }

    public synchronized MapperService createIndexMapperService(IndexMetadata indexMetadata) throws IOException {
        IndexSettings idxSettings = new IndexSettings(indexMetadata, this.settings, this.indexScopedSettings);
        IndexModule indexModule = new IndexModule(idxSettings, this.analysisRegistry, this.getEngineFactory(idxSettings), this.directoryFactories, () -> this.allowExpensiveQueries, this.indexNameExpressionResolver, this.recoveryStateFactories);
        this.pluginsService.onIndexModule(indexModule);
        return indexModule.newIndexMapperService(this.parserConfig, this.mapperRegistry, this.scriptService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void verifyIndexMetadata(IndexMetadata metadata, IndexMetadata metadataUpdate) throws IOException {
        ArrayList<Object> closeables = new ArrayList<Object>();
        try {
            IndicesFieldDataCache indicesFieldDataCache = new IndicesFieldDataCache(this.settings, new IndexFieldDataCache.Listener(){});
            closeables.add(indicesFieldDataCache);
            IndicesQueryCache indicesQueryCache = new IndicesQueryCache(this.settings);
            closeables.add(indicesQueryCache);
            IndexService service = this.createIndexService(IndexService.IndexCreationContext.METADATA_VERIFICATION, metadata, indicesQueryCache, indicesFieldDataCache, Collections.emptyList(), new IndexingOperationListener[0]);
            closeables.add(() -> service.close("metadata verification", false));
            service.mapperService().merge(metadata, MapperService.MergeReason.MAPPING_RECOVERY);
            if (!metadata.equals(metadataUpdate)) {
                service.updateMetadata(metadata, metadataUpdate);
            }
        }
        finally {
            IOUtils.close(closeables);
        }
    }

    @Override
    public IndexShard createShard(ShardRouting shardRouting, PeerRecoveryTargetService recoveryTargetService, PeerRecoveryTargetService.RecoveryListener recoveryListener, RepositoriesService repositoriesService, Consumer<IndexShard.ShardFailure> onShardFailure, Consumer<ShardId> globalCheckpointSyncer, RetentionLeaseSyncer retentionLeaseSyncer, DiscoveryNode targetNode, DiscoveryNode sourceNode) throws IOException {
        Objects.requireNonNull(retentionLeaseSyncer);
        this.ensureChangesAllowed();
        IndexService indexService = this.indexService(shardRouting.index());
        assert (indexService != null);
        RecoveryState recoveryState = indexService.createRecoveryState(shardRouting, targetNode, sourceNode);
        IndexShard indexShard = indexService.createShard(shardRouting, globalCheckpointSyncer, retentionLeaseSyncer);
        indexShard.addShardFailureCallback(onShardFailure);
        indexShard.startRecovery(recoveryState, recoveryTargetService, recoveryListener, repositoriesService, mapping -> {
            assert (recoveryState.getRecoverySource().getType() == RecoverySource.Type.LOCAL_SHARDS) : "mapping update consumer only required by local shards recovery";
            this.client.admin().indices().preparePutMapping(new String[0]).setConcreteIndex(shardRouting.index()).setSource(mapping.source().string(), XContentType.JSON).get();
        }, this);
        return indexShard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIndex(Index index, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason, String extraInfo) {
        String indexName = index.getName();
        try {
            IndexEventListener listener;
            IndexService indexService;
            IndicesService indicesService = this;
            synchronized (indicesService) {
                if (!this.hasIndex(index)) {
                    return;
                }
                logger.debug("[{}] closing ... (reason [{}])", (Object)indexName, (Object)reason);
                HashMap<String, IndexService> newIndices = new HashMap<String, IndexService>(this.indices);
                indexService = (IndexService)newIndices.remove(index.getUUID());
                assert (indexService != null) : "IndexService is null for index: " + index;
                this.indices = Collections.unmodifiableMap(newIndices);
                listener = indexService.getIndexEventListener();
            }
            listener.beforeIndexRemoved(indexService, reason);
            logger.debug("{} closing index service (reason [{}][{}])", (Object)index, (Object)reason, (Object)extraInfo);
            indexService.close(extraInfo, reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.DELETED);
            logger.debug("{} closed... (reason [{}][{}])", (Object)index, (Object)reason, (Object)extraInfo);
            IndexSettings indexSettings = indexService.getIndexSettings();
            listener.afterIndexRemoved(indexService.index(), indexSettings, reason);
            if (reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.DELETED) {
                this.deleteIndexStore(extraInfo, indexService.index(), indexSettings);
            }
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("failed to remove index {} ([{}][{}])", new Object[]{index, reason, extraInfo}), (Throwable)e);
        }
    }

    public IndicesFieldDataCache getIndicesFieldDataCache() {
        return this.indicesFieldDataCache;
    }

    public CircuitBreakerService getCircuitBreakerService() {
        return this.circuitBreakerService;
    }

    public IndicesQueryCache getIndicesQueryCache() {
        return this.indicesQueryCache;
    }

    @Override
    public void deleteUnassignedIndex(String reason, IndexMetadata oldIndexMetadata, ClusterState clusterState) {
        if (this.nodeEnv.hasNodeFile()) {
            Index index = oldIndexMetadata.getIndex();
            try {
                if (clusterState.metadata().hasIndex(index)) {
                    IndexMetadata currentMetadata = clusterState.metadata().index(index);
                    throw new IllegalStateException("Can't delete unassigned index store for [" + index.getName() + "] - it's still part of the cluster state [" + currentMetadata.getIndexUUID() + "] [" + oldIndexMetadata.getIndexUUID() + "]");
                }
                this.deleteIndexStore(reason, oldIndexMetadata);
            }
            catch (Exception e) {
                logger.warn(() -> new ParameterizedMessage("[{}] failed to delete unassigned index (reason [{}])", (Object)oldIndexMetadata.getIndex(), (Object)reason), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteIndexStore(String reason, IndexMetadata metadata) throws IOException {
        if (this.nodeEnv.hasNodeFile()) {
            IndicesService indicesService = this;
            synchronized (indicesService) {
                Index index = metadata.getIndex();
                if (this.hasIndex(index)) {
                    String localUUid = this.indexService(index).indexUUID();
                    throw new IllegalStateException("Can't delete index store for [" + index.getName() + "] - it's still part of the indices service [" + localUUid + "] [" + metadata.getIndexUUID() + "]");
                }
            }
            IndexSettings indexSettings = this.buildIndexSettings(metadata);
            this.deleteIndexStore(reason, indexSettings.getIndex(), indexSettings);
        }
    }

    private void deleteIndexStore(String reason, Index index, IndexSettings indexSettings) throws IOException {
        this.deleteIndexStoreIfDeletionAllowed(reason, index, indexSettings, this.DEFAULT_INDEX_DELETION_PREDICATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteIndexStoreIfDeletionAllowed(String reason, Index index, IndexSettings indexSettings, IndexDeletionAllowedPredicate predicate) throws IOException {
        boolean success = false;
        try {
            logger.debug("{} deleting index store reason [{}]", (Object)index, (Object)reason);
            if (predicate.apply(index, indexSettings)) {
                this.nodeEnv.deleteIndexDirectorySafe(index, 0L, indexSettings, paths -> this.indexFoldersDeletionListeners.beforeIndexFoldersDeleted(index, indexSettings, (Path[])paths));
            }
            success = true;
        }
        catch (ShardLockObtainFailedException ex) {
            logger.debug(() -> new ParameterizedMessage("{} failed to delete index store - at least one shards is still locked", (Object)index), (Throwable)ex);
        }
        catch (Exception ex) {
            logger.warn(() -> new ParameterizedMessage("{} failed to delete index", (Object)index), (Throwable)ex);
        }
        finally {
            if (!success) {
                this.addPendingDelete(index, indexSettings);
            }
            MetadataStateFormat.deleteMetaState(this.nodeEnv.indexPaths(index));
        }
    }

    @Override
    public void deleteShardStore(String reason, ShardLock lock, IndexSettings indexSettings) throws IOException {
        ShardId shardId = lock.getShardId();
        logger.trace("{} deleting shard reason [{}]", (Object)shardId, (Object)reason);
        this.nodeEnv.deleteShardDirectoryUnderLock(lock, indexSettings, paths -> this.indexFoldersDeletionListeners.beforeShardFoldersDeleted(shardId, indexSettings, (Path[])paths));
    }

    public void deleteShardStore(String reason, ShardId shardId, ClusterState clusterState) throws IOException, ShardLockObtainFailedException {
        IndexMetadata metadata = clusterState.getMetadata().indices().get(shardId.getIndexName());
        IndexSettings indexSettings = this.buildIndexSettings(metadata);
        ShardDeletionCheckResult shardDeletionCheckResult = this.canDeleteShardContent(shardId, indexSettings);
        if (shardDeletionCheckResult != ShardDeletionCheckResult.FOLDER_FOUND_CAN_DELETE) {
            throw new IllegalStateException("Can't delete shard " + shardId + " (cause: " + shardDeletionCheckResult + ")");
        }
        this.nodeEnv.deleteShardDirectorySafe(shardId, indexSettings, paths -> this.indexFoldersDeletionListeners.beforeShardFoldersDeleted(shardId, indexSettings, (Path[])paths));
        logger.debug("{} deleted shard reason [{}]", (Object)shardId, (Object)reason);
        if (this.canDeleteIndexContents(shardId.getIndex())) {
            if (this.nodeEnv.findAllShardIds(shardId.getIndex()).isEmpty()) {
                try {
                    this.deleteIndexStore("no longer used", metadata);
                }
                catch (Exception e) {
                    throw new ElasticsearchException("failed to delete unused index after deleting its last shard (" + shardId + ")", (Throwable)e, new Object[0]);
                }
            } else {
                logger.trace("[{}] still has shard stores, leaving as is", (Object)shardId.getIndex());
            }
        }
    }

    public boolean canDeleteIndexContents(Index index) {
        IndexService indexService = this.indexService(index);
        return indexService == null && this.nodeEnv.hasNodeFile();
    }

    @Override
    @Nullable
    public IndexMetadata verifyIndexIsDeleted(Index index, ClusterState clusterState) {
        if (clusterState.metadata().index(index) != null) {
            throw new IllegalStateException("Cannot delete index [" + index + "], it is still part of the cluster state.");
        }
        if (this.nodeEnv.hasNodeFile() && FileSystemUtils.exists(this.nodeEnv.indexPaths(index))) {
            IndexMetadata metadata;
            try {
                metadata = this.metaStateService.loadIndexState(index);
                if (metadata == null) {
                    return null;
                }
            }
            catch (Exception e) {
                logger.warn(() -> new ParameterizedMessage("[{}] failed to load state file from a stale deleted index, folders will be left on disk", (Object)index), (Throwable)e);
                return null;
            }
            IndexSettings indexSettings = this.buildIndexSettings(metadata);
            try {
                this.deleteIndexStoreIfDeletionAllowed("stale deleted index", index, indexSettings, this.ALWAYS_TRUE);
            }
            catch (Exception e) {
                logger.warn(() -> new ParameterizedMessage("[{}] failed to delete index on disk", (Object)metadata.getIndex()), (Throwable)e);
            }
            return metadata;
        }
        return null;
    }

    public ShardDeletionCheckResult canDeleteShardContent(ShardId shardId, IndexSettings indexSettings) {
        boolean isAllocated;
        assert (shardId.getIndex().equals(indexSettings.getIndex()));
        IndexService indexService = this.indexService(shardId.getIndex());
        boolean bl = isAllocated = indexService != null && indexService.hasShard(shardId.id());
        if (isAllocated) {
            return ShardDeletionCheckResult.STILL_ALLOCATED;
        }
        if (indexSettings.hasCustomDataPath()) {
            return Files.exists(this.nodeEnv.resolveCustomLocation(indexSettings.customDataPath(), shardId), new LinkOption[0]) ? ShardDeletionCheckResult.FOLDER_FOUND_CAN_DELETE : ShardDeletionCheckResult.NO_FOLDER_FOUND;
        }
        return FileSystemUtils.exists(this.nodeEnv.availableShardPaths(shardId)) ? ShardDeletionCheckResult.FOLDER_FOUND_CAN_DELETE : ShardDeletionCheckResult.NO_FOLDER_FOUND;
    }

    private IndexSettings buildIndexSettings(IndexMetadata metadata) {
        return new IndexSettings(metadata, this.settings);
    }

    @Override
    public void addPendingDelete(ShardId shardId, IndexSettings settings) {
        if (shardId == null) {
            throw new IllegalArgumentException("shardId must not be null");
        }
        if (settings == null) {
            throw new IllegalArgumentException("settings must not be null");
        }
        PendingDelete pendingDelete = new PendingDelete(shardId, settings);
        this.addPendingDelete(shardId.getIndex(), pendingDelete);
    }

    public void addPendingDelete(Index index, IndexSettings settings) {
        PendingDelete pendingDelete = new PendingDelete(index, settings);
        this.addPendingDelete(index, pendingDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingDelete(Index index, PendingDelete pendingDelete) {
        Map<Index, List<PendingDelete>> map = this.pendingDeletes;
        synchronized (map) {
            List<PendingDelete> list = this.pendingDeletes.get(index);
            if (list == null) {
                list = new ArrayList<PendingDelete>();
                this.pendingDeletes.put(index, list);
            }
            list.add(pendingDelete);
            this.numUncompletedDeletes.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPendingDeletes(Index index, IndexSettings indexSettings, TimeValue timeout) throws IOException, InterruptedException, ShardLockObtainFailedException {
        block20: {
            logger.debug("{} processing pending deletes", (Object)index);
            long startTimeNS = System.nanoTime();
            List<ShardLock> shardLocks = this.nodeEnv.lockAllForIndex(index, indexSettings, "process pending deletes", timeout.millis());
            int numRemoved = 0;
            try {
                List<PendingDelete> remove;
                HashMap<ShardId, ShardLock> locks = new HashMap<ShardId, ShardLock>();
                for (ShardLock shardLock : shardLocks) {
                    locks.put(shardLock.getShardId(), shardLock);
                }
                Map<Index, List<PendingDelete>> map = this.pendingDeletes;
                synchronized (map) {
                    remove = this.pendingDeletes.remove(index);
                }
                if (remove == null || remove.isEmpty()) break block20;
                numRemoved = remove.size();
                CollectionUtil.timSort(remove);
                long l = 10000L;
                long sleepTime = 10L;
                do {
                    if (remove.isEmpty()) {
                        break;
                    }
                    Iterator<PendingDelete> iterator = remove.iterator();
                    while (iterator.hasNext()) {
                        PendingDelete delete = iterator.next();
                        if (delete.deleteIndex) {
                            assert (delete.shardId == -1);
                            logger.debug("{} deleting index store reason [{}]", (Object)index, (Object)"pending delete");
                            try {
                                this.nodeEnv.deleteIndexDirectoryUnderLock(index, indexSettings, paths -> this.indexFoldersDeletionListeners.beforeIndexFoldersDeleted(index, indexSettings, (Path[])paths));
                                iterator.remove();
                            }
                            catch (IOException ex) {
                                logger.debug(() -> new ParameterizedMessage("{} retry pending delete", (Object)index), (Throwable)ex);
                            }
                            continue;
                        }
                        assert (delete.shardId != -1);
                        ShardId shardId = new ShardId(delete.index, delete.shardId);
                        ShardLock shardLock = (ShardLock)locks.get(shardId);
                        if (shardLock != null) {
                            try {
                                this.deleteShardStore("pending delete", shardLock, delete.settings);
                                iterator.remove();
                            }
                            catch (IOException ex) {
                                logger.debug(() -> new ParameterizedMessage("{} retry pending delete", (Object)shardLock.getShardId()), (Throwable)ex);
                            }
                            continue;
                        }
                        logger.warn("{} no shard lock for pending delete", (Object)delete.shardId);
                        iterator.remove();
                    }
                    if (remove.isEmpty()) continue;
                    logger.warn("{} still pending deletes present for shards {} - retrying", (Object)index, (Object)remove.toString());
                    Thread.sleep(sleepTime);
                    sleepTime = Math.min(10000L, sleepTime * 2L);
                    logger.debug("{} schedule pending delete retry after {} ms", (Object)index, (Object)sleepTime);
                } while (System.nanoTime() - startTimeNS < timeout.nanos());
            }
            finally {
                IOUtils.close(shardLocks);
                if (numRemoved > 0) {
                    int remainingUncompletedDeletes = this.numUncompletedDeletes.addAndGet(-numRemoved);
                    assert (remainingUncompletedDeletes >= 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int numPendingDeletes(Index index) {
        Map<Index, List<PendingDelete>> map = this.pendingDeletes;
        synchronized (map) {
            List<PendingDelete> deleteList = this.pendingDeletes.get(index);
            if (deleteList == null) {
                return 0;
            }
            return deleteList.size();
        }
    }

    public boolean hasUncompletedPendingDeletes() {
        return this.numUncompletedDeletes.get() > 0;
    }

    public AnalysisRegistry getAnalysis() {
        return this.analysisRegistry;
    }

    public boolean canCache(ShardSearchRequest request, SearchContext context) {
        if (request.scroll() != null) {
            return false;
        }
        if (SearchType.QUERY_THEN_FETCH != context.searchType()) {
            return false;
        }
        if (request.source() != null && request.source().profile()) {
            return false;
        }
        IndexSettings settings = context.indexShard().indexSettings();
        if (request.requestCache() == null) {
            if (!settings.getValue(IndicesRequestCache.INDEX_CACHE_REQUEST_ENABLED_SETTING).booleanValue()) {
                return false;
            }
            if (context.size() != 0) {
                return false;
            }
        } else if (!request.requestCache().booleanValue()) {
            return false;
        }
        assert (context.searcher().getIndexReader().getReaderCacheHelper() != null);
        return context.getSearchExecutionContext().isCacheable();
    }

    public void loadIntoContext(ShardSearchRequest request, SearchContext context, QueryPhase queryPhase) throws Exception {
        assert (this.canCache(request, context));
        DirectoryReader directoryReader = context.searcher().getDirectoryReader();
        boolean[] loadedFromCache = new boolean[]{true};
        BytesReference cacheKey = request.cacheKey(this.requestCacheKeyDifferentiator);
        BytesReference bytesReference = this.cacheShardLevelResult(context.indexShard(), context.getSearchExecutionContext().mappingCacheKey(), directoryReader, cacheKey, (CheckedConsumer<StreamOutput, IOException>)((CheckedConsumer)out -> {
            queryPhase.execute(context);
            context.queryResult().writeToNoId((StreamOutput)out);
            loadedFromCache[0] = false;
        }));
        if (loadedFromCache[0]) {
            QuerySearchResult result = context.queryResult();
            NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(bytesReference.streamInput(), this.namedWriteableRegistry);
            result.readFromWithId(context.id(), in);
            result.setSearchShardTarget(context.shardTarget());
        } else if (context.queryResult().searchTimedOut()) {
            this.indicesRequestCache.invalidate(new IndexShardCacheEntity(context.indexShard()), context.getSearchExecutionContext().mappingCacheKey(), directoryReader, cacheKey);
            if (logger.isTraceEnabled()) {
                logger.trace("Query timed out, invalidating cache entry for request on shard [{}]:\n {}", (Object)request.shardId(), (Object)request.source());
            }
        }
    }

    public ByteSizeValue getTotalIndexingBufferBytes() {
        return this.indexingMemoryController.indexingBufferSize();
    }

    private BytesReference cacheShardLevelResult(IndexShard shard, MappingLookup.CacheKey mappingCacheKey, DirectoryReader reader, BytesReference cacheKey, CheckedConsumer<StreamOutput, IOException> loader) throws Exception {
        IndexShardCacheEntity cacheEntity = new IndexShardCacheEntity(shard);
        CheckedSupplier<BytesReference, IOException> supplier = () -> {
            int expectedSizeInBytes = 512;
            try (BytesStreamOutput out = new BytesStreamOutput(512);){
                loader.accept((Object)out);
                BytesReference bytesReference = out.bytes();
                return bytesReference;
            }
        };
        return this.indicesRequestCache.getOrCompute(cacheEntity, supplier, mappingCacheKey, reader, cacheKey);
    }

    public AliasFilter buildAliasFilter(ClusterState state, String index, Set<String> resolvedExpressions) {
        CheckedFunction filterParser = bytes -> {
            try (StreamInput inputStream = bytes.streamInput();){
                QueryBuilder queryBuilder;
                block12: {
                    XContentParser parser = XContentFactory.xContentType((InputStream)inputStream).xContent().createParser(this.parserConfig, (InputStream)inputStream);
                    try {
                        queryBuilder = AbstractQueryBuilder.parseInnerQueryBuilder(parser);
                        if (parser == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    parser.close();
                }
                return queryBuilder;
            }
        };
        String[] aliases = this.indexNameExpressionResolver.filteringAliases(state, index, resolvedExpressions);
        if (aliases == null) {
            return AliasFilter.EMPTY;
        }
        Metadata metadata = state.metadata();
        IndexAbstraction ia = (IndexAbstraction)state.metadata().getIndicesLookup().get(index);
        if (ia.getParentDataStream() != null) {
            List filters = Arrays.stream(aliases).map(name -> metadata.dataStreamAliases().get(name)).map(dataStreamAlias -> {
                try {
                    return (QueryBuilder)filterParser.apply((Object)dataStreamAlias.getFilter().uncompressed());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }).collect(Collectors.toList());
            if (filters.isEmpty()) {
                return new AliasFilter(null, aliases);
            }
            if (filters.size() == 1) {
                return new AliasFilter((QueryBuilder)filters.get(0), aliases);
            }
            BoolQueryBuilder bool = new BoolQueryBuilder();
            for (QueryBuilder filter : filters) {
                bool.should(filter);
            }
            return new AliasFilter(bool, aliases);
        }
        IndexMetadata indexMetadata = metadata.index(index);
        return new AliasFilter(ShardSearchRequest.parseAliasFilter((CheckedFunction<BytesReference, QueryBuilder, IOException>)filterParser, indexMetadata, aliases), aliases);
    }

    public QueryRewriteContext getRewriteContext(LongSupplier nowInMillis) {
        return new QueryRewriteContext(this.parserConfig, this.namedWriteableRegistry, this.client, nowInMillis);
    }

    public CoordinatorRewriteContextProvider getCoordinatorRewriteContextProvider(LongSupplier nowInMillis) {
        return new CoordinatorRewriteContextProvider(this.parserConfig, this.namedWriteableRegistry, this.client, nowInMillis, this.clusterService::state, this::getTimestampFieldType);
    }

    public void clearIndexShardCache(ShardId shardId, boolean queryCache, boolean fieldDataCache, boolean requestCache, String ... fields) {
        IndexService service = this.indexService(shardId.getIndex());
        if (service != null) {
            IndexShard shard = service.getShardOrNull(shardId.id());
            boolean clearedAtLeastOne = service.clearCaches(queryCache, fieldDataCache, fields);
            if ((requestCache || !clearedAtLeastOne && fields.length == 0) && shard != null) {
                this.indicesRequestCache.clear(new IndexShardCacheEntity(shard));
            }
        }
    }

    public Function<String, Predicate<String>> getFieldFilter() {
        return this.mapperRegistry.getFieldFilter();
    }

    public Set<String> getMetadataFields(Version version) {
        return this.mapperRegistry.getMetadataMapperParsers(version).keySet();
    }

    public Set<String> getAllMetadataFields() {
        return this.mapperRegistry.getAllMetadataMapperParsers().keySet();
    }

    private void setIdFieldDataEnabled(boolean value) {
        this.idFieldDataEnabled = value;
    }

    private void updateDanglingIndicesInfo(final Index index) {
        assert (DiscoveryNode.canContainData(this.settings)) : "dangling indices information should only be persisted on data nodes";
        assert (this.nodeWriteDanglingIndicesInfo) : "writing dangling indices info is not enabled";
        assert (this.danglingIndicesThreadPoolExecutor != null) : "executor for dangling indices info is not available";
        if (this.danglingIndicesToWrite.add(index)) {
            logger.trace("triggered dangling indices update for {}", (Object)index);
            final long triggeredTimeMillis = this.threadPool.relativeTimeInMillis();
            try {
                this.danglingIndicesThreadPoolExecutor.execute(new AbstractRunnable(){

                    @Override
                    public void onFailure(Exception e) {
                        logger.warn(() -> new ParameterizedMessage("failed to write dangling indices state for index {}", (Object)index), (Throwable)e);
                    }

                    @Override
                    protected void doRun() {
                        boolean exists = IndicesService.this.danglingIndicesToWrite.remove(index);
                        assert (exists) : "removed non-existing item for " + index;
                        IndexService indexService = IndicesService.this.indices.get(index.getUUID());
                        if (indexService != null) {
                            long executedTimeMillis = IndicesService.this.threadPool.relativeTimeInMillis();
                            logger.trace("writing out dangling indices state for index {}, triggered {} ago", (Object)index, (Object)TimeValue.timeValueMillis((long)Math.min(0L, executedTimeMillis - triggeredTimeMillis)));
                            indexService.writeDanglingIndicesInfo();
                            long completedTimeMillis = IndicesService.this.threadPool.relativeTimeInMillis();
                            logger.trace("writing out of dangling indices state for index {} completed after {}", (Object)index, (Object)TimeValue.timeValueMillis((long)Math.min(0L, completedTimeMillis - executedTimeMillis)));
                        } else {
                            logger.trace("omit writing dangling indices state for index {} as index is deallocated on this node", (Object)index);
                        }
                    }
                });
            }
            catch (EsRejectedExecutionException e) {
                assert (this.danglingIndicesThreadPoolExecutor.isShutdown());
            }
        } else {
            logger.trace("dangling indices update already pending for {}", (Object)index);
        }
    }

    private void setAllowExpensiveQueries(Boolean allowExpensiveQueries) {
        this.allowExpensiveQueries = allowExpensiveQueries;
    }

    public boolean allPendingDanglingIndicesWritten() {
        return !this.nodeWriteDanglingIndicesInfo || this.danglingIndicesToWrite.isEmpty() && this.danglingIndicesThreadPoolExecutor.getActiveCount() == 0;
    }

    @Nullable
    public DateFieldMapper.DateFieldType getTimestampFieldType(Index index) {
        return this.timestampFieldMapperService.getTimestampFieldType(index);
    }

    private static final class CacheCleaner
    implements Runnable,
    Releasable {
        private final IndicesFieldDataCache cache;
        private final Logger logger;
        private final ThreadPool threadPool;
        private final TimeValue interval;
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private final IndicesRequestCache requestCache;

        CacheCleaner(IndicesFieldDataCache cache, IndicesRequestCache requestCache, Logger logger, ThreadPool threadPool, TimeValue interval) {
            this.cache = cache;
            this.requestCache = requestCache;
            this.logger = logger;
            this.threadPool = threadPool;
            this.interval = interval;
        }

        @Override
        public void run() {
            long startTimeNS = System.nanoTime();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("running periodic field data cache cleanup");
            }
            try {
                this.cache.getCache().refresh();
            }
            catch (Exception e) {
                this.logger.warn("Exception during periodic field data cache cleanup:", (Throwable)e);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("periodic field data cache cleanup finished in {} milliseconds", (Object)TimeValue.nsecToMSec((long)(System.nanoTime() - startTimeNS)));
            }
            try {
                this.requestCache.cleanCache();
            }
            catch (Exception e) {
                this.logger.warn("Exception during periodic request cache cleanup:", (Throwable)e);
            }
            if (!this.closed.get()) {
                this.threadPool.scheduleUnlessShuttingDown(this.interval, "same", this);
            }
        }

        public void close() {
            this.closed.compareAndSet(false, true);
        }
    }

    static class OldShardsStats
    implements IndexEventListener {
        final SearchStats searchStats = new SearchStats();
        final GetStats getStats = new GetStats();
        final IndexingStats indexingStats = new IndexingStats();
        final MergeStats mergeStats = new MergeStats();
        final RefreshStats refreshStats = new RefreshStats();
        final FlushStats flushStats = new FlushStats();
        final RecoveryStats recoveryStats = new RecoveryStats();
        final BulkStats bulkStats = new BulkStats();

        OldShardsStats() {
        }

        @Override
        public synchronized void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
            if (indexShard != null) {
                this.getStats.addTotals(indexShard.getStats());
                this.indexingStats.addTotals(indexShard.indexingStats());
                this.searchStats.addTotalsForClosingShard(indexShard.searchStats(new String[0]));
                this.mergeStats.addTotals(indexShard.mergeStats());
                this.refreshStats.addTotals(indexShard.refreshStats());
                this.flushStats.addTotals(indexShard.flushStats());
                this.recoveryStats.addTotals(indexShard.recoveryStats());
                this.bulkStats.addTotals(indexShard.bulkStats());
            }
        }

        @Override
        public void afterIndexShardClosed(ShardId shardId, IndexShard indexShard, Settings indexSettings) {
        }
    }

    @FunctionalInterface
    static interface IndexDeletionAllowedPredicate {
        public boolean apply(Index var1, IndexSettings var2);
    }

    public static enum ShardDeletionCheckResult {
        FOLDER_FOUND_CAN_DELETE,
        STILL_ALLOCATED,
        NO_FOLDER_FOUND;

    }

    private static final class PendingDelete
    implements Comparable<PendingDelete> {
        final Index index;
        final int shardId;
        final IndexSettings settings;
        final boolean deleteIndex;

        PendingDelete(ShardId shardId, IndexSettings settings) {
            this.index = shardId.getIndex();
            this.shardId = shardId.getId();
            this.settings = settings;
            this.deleteIndex = false;
        }

        PendingDelete(Index index, IndexSettings settings) {
            this.index = index;
            this.shardId = -1;
            this.settings = settings;
            this.deleteIndex = true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(this.index).append("]");
            if (this.shardId != -1) {
                sb.append("[").append(this.shardId).append("]");
            }
            return sb.toString();
        }

        @Override
        public int compareTo(PendingDelete o) {
            return Integer.compare(this.shardId, o.shardId);
        }
    }

    static final class IndexShardCacheEntity
    extends AbstractIndexShardCacheEntity {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(IndexShardCacheEntity.class);
        private final IndexShard indexShard;

        protected IndexShardCacheEntity(IndexShard indexShard) {
            this.indexShard = indexShard;
        }

        @Override
        protected ShardRequestCache stats() {
            return this.indexShard.requestCache();
        }

        @Override
        public boolean isOpen() {
            return this.indexShard.state() != IndexShardState.CLOSED;
        }

        @Override
        public Object getCacheIdentity() {
            return this.indexShard;
        }

        public long ramBytesUsed() {
            return BASE_RAM_BYTES_USED;
        }
    }
}

