/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.geo.GeoJson;
import org.elasticsearch.common.geo.GeometryIO;
import org.elasticsearch.common.geo.GeometryParser;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public abstract class AbstractGeometryQueryBuilder<QB extends AbstractGeometryQueryBuilder<QB>>
extends AbstractQueryBuilder<QB> {
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Types are deprecated in [geo_shape] queries. The type should no longer be specified in the [indexed_shape] section.";
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(AbstractGeometryQueryBuilder.class);
    public static final String DEFAULT_SHAPE_INDEX_NAME = "shapes";
    public static final String DEFAULT_SHAPE_FIELD_NAME = "shape";
    public static final ShapeRelation DEFAULT_SHAPE_RELATION = ShapeRelation.INTERSECTS;
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    protected static final ParseField SHAPE_FIELD = new ParseField("shape", new String[0]);
    protected static final ParseField RELATION_FIELD = new ParseField("relation", new String[0]);
    protected static final ParseField INDEXED_SHAPE_FIELD = new ParseField("indexed_shape", new String[0]);
    protected static final ParseField SHAPE_ID_FIELD = new ParseField("id", new String[0]);
    protected static final ParseField SHAPE_TYPE_FIELD = new ParseField("type", new String[0]);
    protected static final ParseField SHAPE_INDEX_FIELD = new ParseField("index", new String[0]);
    protected static final ParseField SHAPE_PATH_FIELD = new ParseField("path", new String[0]);
    protected static final ParseField SHAPE_ROUTING_FIELD = new ParseField("routing", new String[0]);
    protected static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    protected final String fieldName;
    protected final Supplier<Geometry> supplier;
    protected final String indexedShapeId;
    protected Geometry shape;
    protected String indexedShapeIndex = "shapes";
    protected String indexedShapePath = "shape";
    protected String indexedShapeRouting;
    protected ShapeRelation relation = DEFAULT_SHAPE_RELATION;
    protected boolean ignoreUnmapped = false;

    public AbstractGeometryQueryBuilder(String fieldName, Geometry shape) {
        this(fieldName, shape, null);
    }

    protected AbstractGeometryQueryBuilder(String fieldName, String indexedShapeId) {
        this(fieldName, (Geometry)null, indexedShapeId);
    }

    protected AbstractGeometryQueryBuilder(String fieldName, Geometry shape, String indexedShapeId) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName is required");
        }
        if (shape == null && indexedShapeId == null) {
            throw new IllegalArgumentException("either shape or indexedShapeId is required");
        }
        this.fieldName = fieldName;
        this.shape = shape;
        this.indexedShapeId = indexedShapeId;
        this.supplier = null;
    }

    protected AbstractGeometryQueryBuilder(String fieldName, Supplier<Geometry> supplier, String indexedShapeId) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName is required");
        }
        if (supplier == null && indexedShapeId == null) {
            throw new IllegalArgumentException("either shape or indexedShapeId is required");
        }
        this.fieldName = fieldName;
        this.shape = null;
        this.supplier = supplier;
        this.indexedShapeId = indexedShapeId;
    }

    protected AbstractGeometryQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        if (in.readBoolean()) {
            this.shape = GeometryIO.readGeometry(in);
            this.indexedShapeId = null;
        } else {
            this.shape = null;
            this.indexedShapeId = in.readOptionalString();
            if (in.getVersion().before(Version.V_8_0_0)) {
                String type = in.readOptionalString();
                assert ("_doc".equals(type)) : "Expected type [_doc], got [" + type + "]";
            }
            this.indexedShapeIndex = in.readOptionalString();
            this.indexedShapePath = in.readOptionalString();
            this.indexedShapeRouting = in.readOptionalString();
        }
        this.relation = ShapeRelation.readFromStream(in);
        this.ignoreUnmapped = in.readBoolean();
        this.supplier = null;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        if (this.supplier != null) {
            throw new IllegalStateException("supplier must be null, can't serialize suppliers, missing a rewriteAndFetch?");
        }
        out.writeString(this.fieldName);
        boolean hasShape = this.shape != null;
        out.writeBoolean(hasShape);
        if (hasShape) {
            GeometryIO.writeGeometry(out, this.shape);
        } else {
            out.writeOptionalString(this.indexedShapeId);
            if (out.getVersion().before(Version.V_8_0_0)) {
                out.writeOptionalString("_doc");
            }
            out.writeOptionalString(this.indexedShapeIndex);
            out.writeOptionalString(this.indexedShapePath);
            out.writeOptionalString(this.indexedShapeRouting);
        }
        this.relation.writeTo(out);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public QB shape(Geometry geometry) {
        if (geometry == null) {
            throw new IllegalArgumentException("No geometry defined");
        }
        this.shape = geometry;
        return (QB)this;
    }

    public Geometry shape() {
        return this.shape;
    }

    public String indexedShapeId() {
        return this.indexedShapeId;
    }

    public QB indexedShapeIndex(String indexedShapeIndex) {
        this.indexedShapeIndex = indexedShapeIndex;
        return (QB)this;
    }

    public String indexedShapeIndex() {
        return this.indexedShapeIndex;
    }

    public QB indexedShapePath(String indexedShapePath) {
        this.indexedShapePath = indexedShapePath;
        return (QB)this;
    }

    public String indexedShapePath() {
        return this.indexedShapePath;
    }

    public QB indexedShapeRouting(String indexedShapeRouting) {
        this.indexedShapeRouting = indexedShapeRouting;
        return (QB)this;
    }

    public String indexedShapeRouting() {
        return this.indexedShapeRouting;
    }

    public QB relation(ShapeRelation relation) {
        if (relation == null) {
            throw new IllegalArgumentException("No Shape Relation defined");
        }
        this.relation = relation;
        return (QB)this;
    }

    public ShapeRelation relation() {
        return this.relation;
    }

    public AbstractGeometryQueryBuilder<QB> ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    protected abstract Query buildShapeQuery(SearchExecutionContext var1, MappedFieldType var2);

    protected abstract void doShapeQueryXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    protected abstract AbstractGeometryQueryBuilder<QB> newShapeQueryBuilder(String var1, Geometry var2);

    protected abstract AbstractGeometryQueryBuilder<QB> newShapeQueryBuilder(String var1, Supplier<Geometry> var2, String var3);

    @Override
    protected Query doToQuery(SearchExecutionContext context) {
        if (this.shape == null || this.supplier != null) {
            throw new UnsupportedOperationException("query must be rewritten first");
        }
        MappedFieldType fieldType = context.getFieldType(this.fieldName);
        if (fieldType == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new QueryShardException(context, "failed to find type for field [" + this.fieldName + "]", new Object[0]);
        }
        return this.buildShapeQuery(context, fieldType);
    }

    private void fetch(Client client, GetRequest getRequest, String path, ActionListener<Geometry> listener) {
        getRequest.preference("_local");
        client.get(getRequest, listener.delegateFailure((l, response) -> {
            try {
                if (!response.isExists()) {
                    throw new IllegalArgumentException("Shape with ID [" + getRequest.id() + "] not found");
                }
                if (response.isSourceEmpty()) {
                    throw new IllegalArgumentException("Shape with ID [" + getRequest.id() + "] source disabled");
                }
                String[] pathElements = path.split("\\.");
                int currentPathSlot = 0;
                try (XContentParser parser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, response.getSourceAsBytesRef());){
                    XContentParser.Token currentToken;
                    while ((currentToken = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (currentToken != XContentParser.Token.FIELD_NAME) continue;
                        if (pathElements[currentPathSlot].equals(parser.currentName())) {
                            parser.nextToken();
                            if (++currentPathSlot != pathElements.length) continue;
                            l.onResponse(new GeometryParser(true, true, true).parse(parser));
                            return;
                        }
                        parser.nextToken();
                        parser.skipChildren();
                    }
                    throw new IllegalStateException("Shape with name [" + getRequest.id() + "] found but missing " + path + " field");
                }
            }
            catch (Exception e) {
                l.onFailure(e);
                return;
            }
        }));
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getWriteableName());
        builder.startObject(this.fieldName);
        if (this.shape != null) {
            builder.field(SHAPE_FIELD.getPreferredName());
            GeoJson.toXContent(this.shape, builder, params);
        } else {
            builder.startObject(INDEXED_SHAPE_FIELD.getPreferredName()).field(SHAPE_ID_FIELD.getPreferredName(), this.indexedShapeId);
            if (builder.getRestApiVersion() == RestApiVersion.V_7) {
                builder.field(SHAPE_TYPE_FIELD.getPreferredName(), "_doc");
            }
            if (this.indexedShapeIndex != null) {
                builder.field(SHAPE_INDEX_FIELD.getPreferredName(), this.indexedShapeIndex);
            }
            if (this.indexedShapePath != null) {
                builder.field(SHAPE_PATH_FIELD.getPreferredName(), this.indexedShapePath);
            }
            if (this.indexedShapeRouting != null) {
                builder.field(SHAPE_ROUTING_FIELD.getPreferredName(), this.indexedShapeRouting);
            }
            builder.endObject();
        }
        if (this.relation != null) {
            builder.field(RELATION_FIELD.getPreferredName(), this.relation.getRelationName());
        }
        this.doShapeQueryXContent(builder, params);
        builder.endObject();
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    @Override
    protected boolean doEquals(AbstractGeometryQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.indexedShapeId, other.indexedShapeId) && Objects.equals(this.indexedShapeIndex, other.indexedShapeIndex) && Objects.equals(this.indexedShapePath, other.indexedShapePath) && Objects.equals(this.indexedShapeRouting, other.indexedShapeRouting) && Objects.equals(this.relation, other.relation) && Objects.equals(this.shape, other.shape) && Objects.equals(this.supplier, other.supplier) && Objects.equals(this.ignoreUnmapped, other.ignoreUnmapped);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.indexedShapeId, this.indexedShapeIndex, this.indexedShapePath, this.indexedShapeRouting, this.relation, this.shape, this.ignoreUnmapped, this.supplier);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        if (this.supplier != null) {
            return this.supplier.get() == null ? this : this.newShapeQueryBuilder(this.fieldName, this.supplier.get()).relation(this.relation);
        }
        if (this.shape == null) {
            SetOnce supplier = new SetOnce();
            queryRewriteContext.registerAsyncAction((client, listener) -> {
                GetRequest getRequest = new GetRequest(this.indexedShapeIndex, this.indexedShapeId);
                getRequest.routing(this.indexedShapeRouting);
                this.fetch((Client)client, getRequest, this.indexedShapePath, ActionListener.wrap(builder -> {
                    supplier.set(builder);
                    listener.onResponse(null);
                }, listener::onFailure));
            });
            return this.newShapeQueryBuilder(this.fieldName, () -> ((SetOnce)supplier).get(), this.indexedShapeId).relation(this.relation);
        }
        return this;
    }

    public static ParsedGeometryQueryParams parsedParamsFromXContent(XContentParser parser, ParsedGeometryQueryParams params) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (fieldName != null) {
                    throw new ParsingException(parser.getTokenLocation(), "point specified twice. [" + currentFieldName + "]", new Object[0]);
                }
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token != XContentParser.Token.FIELD_NAME) continue;
                    currentFieldName = parser.currentName();
                    token = parser.nextToken();
                    if (RELATION_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        params.relation = ShapeRelation.getRelationByName(parser.text());
                        if (params.relation != null) continue;
                        throw new ParsingException(parser.getTokenLocation(), "Unknown shape operation [" + parser.text() + " ]", new Object[0]);
                    }
                    if (params.parseXContentField(parser)) continue;
                    if (INDEXED_SHAPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token.isValue()) {
                                if (SHAPE_ID_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                    params.id = parser.text();
                                    continue;
                                }
                                if (parser.getRestApiVersion() == RestApiVersion.V_7 && SHAPE_TYPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                    deprecationLogger.compatibleCritical("geo_share_query_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
                                    continue;
                                }
                                if (SHAPE_INDEX_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                    params.index = parser.text();
                                    continue;
                                }
                                if (SHAPE_PATH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                                    params.shapePath = parser.text();
                                    continue;
                                }
                                if (!SHAPE_ROUTING_FIELD.match(currentFieldName, parser.getDeprecationHandler())) continue;
                                params.shapeRouting = parser.text();
                                continue;
                            }
                            throw new ParsingException(parser.getTokenLocation(), "unknown token [" + token + "] after [" + currentFieldName + "]", new Object[0]);
                        }
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (!token.isValue()) continue;
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                params.boost = parser.floatValue();
                continue;
            }
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                params.queryName = parser.text();
                continue;
            }
            if (IGNORE_UNMAPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                params.ignoreUnmapped = parser.booleanValue();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "query does not support [" + currentFieldName + "]", new Object[0]);
        }
        params.fieldName = fieldName;
        return params;
    }

    protected static abstract class ParsedGeometryQueryParams {
        public String fieldName;
        public ShapeRelation relation;
        public Geometry shape;
        public String id = null;
        public String index = null;
        public String shapePath = null;
        public String shapeRouting = null;
        public float boost;
        public String queryName;
        public boolean ignoreUnmapped;

        protected ParsedGeometryQueryParams() {
        }

        protected abstract boolean parseXContentField(XContentParser var1) throws IOException;
    }
}

