/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.function.Supplier;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.plain.SortedOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.DocValueFetcher;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.field.DelegateDocValuesField;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;

public class TimeSeriesIdFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_tsid";
    public static final String CONTENT_TYPE = "_tsid";
    public static final TimeSeriesIdFieldType FIELD_TYPE = new TimeSeriesIdFieldType();
    public static final TimeSeriesIdFieldMapper INSTANCE = new TimeSeriesIdFieldMapper();
    private static final int LIMIT = 32766;
    private static final int DIMENSION_NAME_LIMIT = 512;
    private static final int DIMENSION_VALUE_LIMIT = 1024;
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> c.getIndexSettings().getMode().buildTimeSeriesIdFieldMapper());

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder().init(this);
    }

    private TimeSeriesIdFieldMapper() {
        super(FIELD_TYPE);
    }

    @Override
    public void postParse(DocumentParserContext context) throws IOException {
        assert (!this.fieldType().isIndexed());
        SortedMap<String, BytesReference> dimensionFields = context.doc().getDimensionBytes();
        BytesReference timeSeriesId = TimeSeriesIdFieldMapper.buildTsidField(dimensionFields);
        context.doc().add((IndexableField)new SortedDocValuesField(this.fieldType().name(), timeSeriesId.toBytesRef()));
    }

    public static BytesReference buildTsidField(SortedMap<String, BytesReference> dimensionFields) throws IOException {
        if (dimensionFields == null || dimensionFields.isEmpty()) {
            throw new IllegalArgumentException("Dimension fields are missing.");
        }
        try (BytesStreamOutput out = new BytesStreamOutput();){
            TimeSeriesIdFieldMapper.encodeTsid(out, dimensionFields);
            BytesReference timeSeriesId = out.bytes();
            if (timeSeriesId.length() > 32766) {
                throw new IllegalArgumentException("_tsid longer than [32766] bytes [" + timeSeriesId.length() + "].");
            }
            BytesReference bytesReference = timeSeriesId;
            return bytesReference;
        }
    }

    @Override
    protected String contentType() {
        return "_tsid";
    }

    public static void encodeTsid(StreamOutput out, SortedMap<String, BytesReference> dimensionFields) throws IOException {
        out.writeVInt(dimensionFields.size());
        for (Map.Entry<String, BytesReference> entry : dimensionFields.entrySet()) {
            String fieldName = entry.getKey();
            BytesRef fieldNameBytes = new BytesRef((CharSequence)fieldName);
            int len = fieldNameBytes.length;
            if (len > 512) {
                throw new IllegalArgumentException("Dimension name must be less than [512] bytes but [" + fieldName + "] was [" + len + "].");
            }
            out.writeBytesRef(fieldNameBytes);
            entry.getValue().writeTo(out);
        }
    }

    public static Map<String, Object> decodeTsid(StreamInput in) {
        try {
            int size = in.readVInt();
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(size);
            block7: for (int i = 0; i < size; ++i) {
                String name = in.readString();
                int type = in.read();
                switch (type) {
                    case 115: {
                        result.put(name, in.readBytesRef().utf8ToString());
                        continue block7;
                    }
                    case 108: {
                        result.put(name, in.readLong());
                        continue block7;
                    }
                    case 117: {
                        Object ul = DocValueFormat.UNSIGNED_LONG_SHIFTED.format(in.readLong());
                        result.put(name, ul);
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException("Cannot parse [" + name + "]: Unknown type [" + type + "]");
                    }
                }
            }
            return result;
        }
        catch (IOException | IllegalArgumentException e) {
            throw new IllegalArgumentException("Error formatting _tsid: " + e.getMessage(), e);
        }
    }

    public static Map<String, Object> decodeTsid(BytesRef bytesRef) {
        Map<String, Object> map;
        block8: {
            StreamInput input = new BytesArray(bytesRef).streamInput();
            try {
                map = TimeSeriesIdFieldMapper.decodeTsid(input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("Dimension field cannot be deserialized.", ex);
                }
            }
            input.close();
        }
        return map;
    }

    public static BytesReference encodeTsidValue(String value) {
        BytesStreamOutput out = new BytesStreamOutput();
        try {
            out.write(115);
            BytesRef bytes = new BytesRef((CharSequence)value);
            if (bytes.length > 1024) {
                throw new IllegalArgumentException("Dimension fields must be less than [1024] bytes but was [" + bytes.length + "].");
            }
            out.writeBytesRef(bytes);
            BytesReference bytesReference = out.bytes();
            out.close();
            return bytesReference;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Dimension field cannot be serialized.", e);
            }
        }
    }

    public static BytesReference encodeTsidValue(long value) {
        BytesStreamOutput out = new BytesStreamOutput();
        try {
            out.write(108);
            out.writeLong(value);
            BytesReference bytesReference = out.bytes();
            out.close();
            return bytesReference;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Dimension field cannot be serialized.", e);
            }
        }
    }

    public static BytesReference encodeTsidUnsignedLongValue(long value) {
        BytesStreamOutput out = new BytesStreamOutput();
        try {
            out.write(117);
            out.writeLong(value);
            BytesReference bytesReference = out.bytes();
            out.close();
            return bytesReference;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Dimension field cannot be serialized.", e);
            }
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder {
        protected Builder() {
            super("_tsid");
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return List.of();
        }

        @Override
        public TimeSeriesIdFieldMapper build() {
            return INSTANCE;
        }
    }

    public static final class TimeSeriesIdFieldType
    extends MappedFieldType {
        private TimeSeriesIdFieldType() {
            super("_tsid", false, false, true, TextSearchInfo.NONE, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return "_tsid";
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return new DocValueFetcher(this.docValueFormat(format, null), (IndexFieldData<?>)context.getForField(this));
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return DocValueFormat.TIME_SERIES_ID;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedOrdinalsIndexFieldData.Builder(this.name(), CoreValuesSourceType.KEYWORD, (dv, n) -> new DelegateDocValuesField(new ScriptDocValues.Strings(new ScriptDocValues.StringsSupplier(FieldData.toString(dv))), n));
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("[_tsid] is not searchable");
        }
    }
}

