/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.exc.InputCoercionException;
import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.sandbox.document.HalfFloatPoint;
import org.apache.lucene.sandbox.search.IndexSortSortedNumericDocValuesRangeQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.SortedDoublesIndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TimeSeriesIdFieldMapper;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.DoubleFieldScript;
import org.elasticsearch.script.LongFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.script.field.ByteDocValuesField;
import org.elasticsearch.script.field.DoubleDocValuesField;
import org.elasticsearch.script.field.FloatDocValuesField;
import org.elasticsearch.script.field.HalfFloatDocValuesField;
import org.elasticsearch.script.field.IntegerDocValuesField;
import org.elasticsearch.script.field.LongDocValuesField;
import org.elasticsearch.script.field.ShortDocValuesField;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.lookup.FieldValues;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class NumberFieldMapper
extends FieldMapper {
    public static final Setting<Boolean> COERCE_SETTING = Setting.boolSetting("index.mapping.coerce", true, Setting.Property.IndexScope);
    private final NumberType type;
    private final boolean indexed;
    private final boolean hasDocValues;
    private final boolean stored;
    private final Explicit<Boolean> ignoreMalformed;
    private final Explicit<Boolean> coerce;
    private final Number nullValue;
    private final FieldValues<Number> scriptValues;
    private final boolean ignoreMalformedByDefault;
    private final boolean coerceByDefault;
    private final boolean dimension;
    private final ScriptCompiler scriptCompiler;
    private final Script script;
    private final TimeSeriesParams.MetricType metricType;

    private static NumberFieldMapper toType(FieldMapper in) {
        return (NumberFieldMapper)in;
    }

    private NumberFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo, builder.script.get() != null, builder.onScriptError.getValue());
        this.type = builder.type;
        this.indexed = builder.indexed.getValue();
        this.hasDocValues = builder.hasDocValues.getValue();
        this.stored = builder.stored.getValue();
        this.ignoreMalformed = builder.ignoreMalformed.getValue();
        this.coerce = builder.coerce.getValue();
        this.nullValue = builder.nullValue.getValue();
        this.ignoreMalformedByDefault = builder.ignoreMalformed.getDefaultValue().value();
        this.coerceByDefault = builder.coerce.getDefaultValue().value();
        this.scriptValues = builder.scriptValues();
        this.dimension = builder.dimension.getValue();
        this.scriptCompiler = builder.scriptCompiler;
        this.script = builder.script.getValue();
        this.metricType = builder.metric.getValue();
    }

    boolean coerce() {
        return this.coerce.value();
    }

    boolean ignoreMalformed() {
        return this.ignoreMalformed.value();
    }

    @Override
    public NumberFieldType fieldType() {
        return (NumberFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType().type.typeName();
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        Number value;
        try {
            value = NumberFieldMapper.value(context.parser(), this.type, this.nullValue, this.coerce());
        }
        catch (JsonParseException | InputCoercionException | IllegalArgumentException e) {
            if (this.ignoreMalformed.value().booleanValue() && context.parser().currentToken().isValue()) {
                context.addIgnoredField(this.mappedFieldType.name());
                return;
            }
            throw e;
        }
        if (value != null) {
            this.indexValue(context, value);
        }
    }

    private static Number value(XContentParser parser, NumberType numberType, Number nullValue, boolean coerce) throws InputCoercionException, JsonParseException, IllegalArgumentException, IOException {
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return nullValue;
        }
        if (coerce && parser.currentToken() == XContentParser.Token.VALUE_STRING && parser.textLength() == 0) {
            return nullValue;
        }
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("Cannot parse object as number");
        }
        return numberType.parse(parser, coerce);
    }

    private void indexValue(DocumentParserContext context, Number numericValue) {
        if (this.dimension && numericValue != null) {
            BytesReference bytes = context.getMetadataMapper("_tsid") != null ? TimeSeriesIdFieldMapper.encodeTsidValue(numericValue.longValue()) : null;
            context.doc().addDimensionBytes(this.fieldType().name(), bytes);
        }
        List<Field> fields = this.fieldType().type.createFields(this.fieldType().name(), numericValue, this.indexed, this.hasDocValues, this.stored);
        context.doc().addAll(fields);
        if (!this.hasDocValues && (this.stored || this.indexed)) {
            context.addToFieldNames(this.fieldType().name());
        }
    }

    @Override
    protected void indexScriptValues(SearchLookup searchLookup, LeafReaderContext readerContext, int doc, DocumentParserContext documentParserContext) {
        this.scriptValues.valuesForDoc(searchLookup, readerContext, doc, value -> this.indexValue(documentParserContext, (Number)value));
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.type, this.scriptCompiler, this.ignoreMalformedByDefault, this.coerceByDefault).dimension(this.dimension).metric(this.metricType).init(this);
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> NumberFieldMapper.toType((FieldMapper)m).indexed, true);
        private final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> NumberFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> NumberFieldMapper.toType((FieldMapper)m).stored, false);
        private final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        private final FieldMapper.Parameter<Explicit<Boolean>> coerce;
        private final FieldMapper.Parameter<Number> nullValue;
        private final FieldMapper.Parameter<Script> script = FieldMapper.Parameter.scriptParam(m -> NumberFieldMapper.toType((FieldMapper)m).script);
        private final FieldMapper.Parameter<String> onScriptError = FieldMapper.Parameter.onScriptErrorParam(m -> NumberFieldMapper.toType((FieldMapper)m).onScriptError, this.script);
        private final FieldMapper.Parameter<Boolean> dimension;
        private final FieldMapper.Parameter<TimeSeriesParams.MetricType> metric;
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final ScriptCompiler scriptCompiler;
        private final NumberType type;

        public Builder(String name, NumberType type, ScriptCompiler compiler, Settings settings) {
            this(name, type, compiler, FieldMapper.IGNORE_MALFORMED_SETTING.get(settings), COERCE_SETTING.get(settings));
        }

        public static Builder docValuesOnly(String name, NumberType type) {
            Builder builder = new Builder(name, type, ScriptCompiler.NONE, false, false);
            builder.indexed.setValue(false);
            builder.dimension.setValue(false);
            return builder;
        }

        public Builder(String name, NumberType type, ScriptCompiler compiler, boolean ignoreMalformedByDefault, boolean coerceByDefault) {
            super(name);
            this.type = type;
            this.scriptCompiler = Objects.requireNonNull(compiler);
            this.ignoreMalformed = FieldMapper.Parameter.explicitBoolParam("ignore_malformed", true, m -> NumberFieldMapper.toType((FieldMapper)m).ignoreMalformed, ignoreMalformedByDefault);
            this.coerce = FieldMapper.Parameter.explicitBoolParam("coerce", true, m -> NumberFieldMapper.toType((FieldMapper)m).coerce, coerceByDefault);
            this.nullValue = new FieldMapper.Parameter<Number>("null_value", false, () -> null, (n, c, o) -> o == null ? (Number)null : (Number)type.parse(o, false), m -> NumberFieldMapper.toType((FieldMapper)m).nullValue, XContentBuilder::field, Objects::toString).acceptsNull();
            this.dimension = TimeSeriesParams.dimensionParam(m -> NumberFieldMapper.toType((FieldMapper)m).dimension).addValidator(v -> {
                if (v.booleanValue() && !EnumSet.of(NumberType.INTEGER, NumberType.LONG, NumberType.BYTE, NumberType.SHORT).contains((Object)type)) {
                    throw new IllegalArgumentException("Parameter [time_series_dimension] cannot be set to numeric type [" + type.name + "]");
                }
                if (!(!v.booleanValue() || this.indexed.getValue().booleanValue() && this.hasDocValues.getValue().booleanValue())) {
                    throw new IllegalArgumentException("Field [time_series_dimension] requires that [" + this.indexed.name + "] and [" + this.hasDocValues.name + "] are true");
                }
            });
            this.metric = TimeSeriesParams.metricParam(m -> NumberFieldMapper.toType((FieldMapper)m).metricType, TimeSeriesParams.MetricType.gauge, TimeSeriesParams.MetricType.counter).addValidator(v -> {
                if (v != null && !this.hasDocValues.getValue().booleanValue()) {
                    throw new IllegalArgumentException("Field [time_series_metric] requires that [" + this.hasDocValues.name + "] is true");
                }
            }).precludesParameters(this.dimension);
            this.script.precludesParameters(this.ignoreMalformed, this.coerce, this.nullValue);
            this.addScriptValidation(this.script, this.indexed, this.hasDocValues);
        }

        Builder nullValue(Number number) {
            this.nullValue.setValue(number);
            return this;
        }

        public Builder docValues(boolean hasDocValues) {
            this.hasDocValues.setValue(hasDocValues);
            return this;
        }

        private FieldValues<Number> scriptValues() {
            if (this.script.get() == null) {
                return null;
            }
            return this.type.compile(this.name, this.script.get(), this.scriptCompiler);
        }

        public Builder dimension(boolean dimension) {
            this.dimension.setValue(dimension);
            return this;
        }

        public Builder metric(TimeSeriesParams.MetricType metric) {
            this.metric.setValue(metric);
            return this;
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return List.of(this.indexed, this.hasDocValues, this.stored, this.ignoreMalformed, this.coerce, this.nullValue, this.script, this.onScriptError, this.meta, this.dimension, this.metric);
        }

        @Override
        public NumberFieldMapper build(MapperBuilderContext context) {
            NumberFieldType ft = new NumberFieldType(context.buildFullName(this.name), this);
            return new NumberFieldMapper(this.name, (MappedFieldType)ft, this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum NumberType {
        HALF_FLOAT("half_float", IndexNumericFieldData.NumericType.HALF_FLOAT){

            @Override
            public Float parse(Object value, boolean coerce) {
                float result = this.parseToFloat(value);
                return Float.valueOf(HalfFloatPoint.sortableShortToHalfFloat((short)HalfFloatPoint.halfFloatToSortableShort((float)result)));
            }

            @Override
            public double reduceToStoredPrecision(double value) {
                return this.parse(value, false).doubleValue();
            }

            private float parseToFloat(Object value) {
                float result;
                if (value instanceof Number) {
                    result = ((Number)value).floatValue();
                } else {
                    if (value instanceof BytesRef) {
                        value = ((BytesRef)value).utf8ToString();
                    }
                    result = Float.parseFloat(value.toString());
                }
                this.validateParsed(result);
                return result;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return Float.valueOf(HalfFloatPoint.decodeDimension((byte[])value, (int)0));
            }

            @Override
            public Float parse(XContentParser parser, boolean coerce) throws IOException {
                float parsed = parser.floatValue(coerce);
                this.validateParsed(parsed);
                return Float.valueOf(parsed);
            }

            @Override
            public Query termQuery(String field, Object value, boolean isIndexed) {
                float v = this.parseToFloat(value);
                if (isIndexed) {
                    return HalfFloatPoint.newExactQuery((String)field, (float)v);
                }
                return SortedNumericDocValuesField.newSlowExactQuery((String)field, (long)HalfFloatPoint.halfFloatToSortableShort((float)v));
            }

            @Override
            public Query termsQuery(String field, Collection<?> values) {
                float[] v = new float[values.size()];
                int pos = 0;
                for (Object value : values) {
                    v[pos++] = this.parseToFloat(value);
                }
                return HalfFloatPoint.newSetQuery((String)field, (float[])v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, SearchExecutionContext context, boolean isIndexed) {
                Query query;
                float l = Float.NEGATIVE_INFINITY;
                float u = Float.POSITIVE_INFINITY;
                if (lowerTerm != null) {
                    l = this.parseToFloat(lowerTerm);
                    if (includeLower) {
                        l = HalfFloatPoint.nextDown((float)l);
                    }
                    l = HalfFloatPoint.nextUp((float)l);
                }
                if (upperTerm != null) {
                    u = this.parseToFloat(upperTerm);
                    if (includeUpper) {
                        u = HalfFloatPoint.nextUp((float)u);
                    }
                    u = HalfFloatPoint.nextDown((float)u);
                }
                if (isIndexed) {
                    query = HalfFloatPoint.newRangeQuery((String)field, (float)l, (float)u);
                    if (hasDocValues) {
                        Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)HalfFloatPoint.halfFloatToSortableShort((float)l), (long)HalfFloatPoint.halfFloatToSortableShort((float)u));
                        query = new IndexOrDocValuesQuery(query, dvQuery);
                    }
                } else {
                    query = SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)HalfFloatPoint.halfFloatToSortableShort((float)l), (long)HalfFloatPoint.halfFloatToSortableShort((float)u));
                }
                return query;
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add((Field)new HalfFloatPoint(name, new float[]{value.floatValue()}));
                }
                if (docValued) {
                    fields.add((Field)new SortedNumericDocValuesField(name, (long)HalfFloatPoint.halfFloatToSortableShort((float)value.floatValue())));
                }
                if (stored) {
                    fields.add((Field)new StoredField(name, value.floatValue()));
                }
                return fields;
            }

            @Override
            public IndexFieldData.Builder getFieldDataBuilder(String name) {
                return new SortedDoublesIndexFieldData.Builder(name, this.numericType(), HalfFloatDocValuesField::new);
            }

            private void validateParsed(float value) {
                if (!Float.isFinite(HalfFloatPoint.sortableShortToHalfFloat((short)HalfFloatPoint.halfFloatToSortableShort((float)value)))) {
                    throw new IllegalArgumentException("[half_float] supports only finite values, but got [" + value + "]");
                }
            }
        }
        ,
        FLOAT("float", IndexNumericFieldData.NumericType.FLOAT){

            @Override
            public Float parse(Object value, boolean coerce) {
                float result;
                if (value instanceof Number) {
                    result = ((Number)value).floatValue();
                } else {
                    if (value instanceof BytesRef) {
                        value = ((BytesRef)value).utf8ToString();
                    }
                    result = Float.parseFloat(value.toString());
                }
                this.validateParsed(result);
                return Float.valueOf(result);
            }

            @Override
            public double reduceToStoredPrecision(double value) {
                return this.parse(value, false).doubleValue();
            }

            @Override
            public Number parsePoint(byte[] value) {
                return Float.valueOf(FloatPoint.decodeDimension((byte[])value, (int)0));
            }

            @Override
            public Float parse(XContentParser parser, boolean coerce) throws IOException {
                float parsed = parser.floatValue(coerce);
                this.validateParsed(parsed);
                return Float.valueOf(parsed);
            }

            @Override
            public Query termQuery(String field, Object value, boolean isIndexed) {
                float v = this.parse(value, false).floatValue();
                if (isIndexed) {
                    return FloatPoint.newExactQuery((String)field, (float)v);
                }
                return SortedNumericDocValuesField.newSlowExactQuery((String)field, (long)NumericUtils.floatToSortableInt((float)v));
            }

            @Override
            public Query termsQuery(String field, Collection<?> values) {
                float[] v = new float[values.size()];
                int pos = 0;
                for (Object value : values) {
                    v[pos++] = this.parse(value, false).floatValue();
                }
                return FloatPoint.newSetQuery((String)field, (float[])v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, SearchExecutionContext context, boolean isIndexed) {
                Query query;
                float l = Float.NEGATIVE_INFINITY;
                float u = Float.POSITIVE_INFINITY;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, false).floatValue();
                    if (!includeLower) {
                        l = FloatPoint.nextUp((float)l);
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, false).floatValue();
                    if (!includeUpper) {
                        u = FloatPoint.nextDown((float)u);
                    }
                }
                if (isIndexed) {
                    query = FloatPoint.newRangeQuery((String)field, (float)l, (float)u);
                    if (hasDocValues) {
                        Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)NumericUtils.floatToSortableInt((float)l), (long)NumericUtils.floatToSortableInt((float)u));
                        query = new IndexOrDocValuesQuery(query, dvQuery);
                    }
                } else {
                    query = SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)NumericUtils.floatToSortableInt((float)l), (long)NumericUtils.floatToSortableInt((float)u));
                }
                return query;
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add((Field)new FloatPoint(name, new float[]{value.floatValue()}));
                }
                if (docValued) {
                    fields.add((Field)new SortedNumericDocValuesField(name, (long)NumericUtils.floatToSortableInt((float)value.floatValue())));
                }
                if (stored) {
                    fields.add((Field)new StoredField(name, value.floatValue()));
                }
                return fields;
            }

            @Override
            public IndexFieldData.Builder getFieldDataBuilder(String name) {
                return new SortedDoublesIndexFieldData.Builder(name, this.numericType(), FloatDocValuesField::new);
            }

            private void validateParsed(float value) {
                if (!Float.isFinite(value)) {
                    throw new IllegalArgumentException("[float] supports only finite values, but got [" + value + "]");
                }
            }
        }
        ,
        DOUBLE("double", IndexNumericFieldData.NumericType.DOUBLE){

            @Override
            public Double parse(Object value, boolean coerce) {
                double parsed = 3.objectToDouble(value);
                this.validateParsed(parsed);
                return parsed;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return DoublePoint.decodeDimension((byte[])value, (int)0);
            }

            @Override
            public Double parse(XContentParser parser, boolean coerce) throws IOException {
                double parsed = parser.doubleValue(coerce);
                this.validateParsed(parsed);
                return parsed;
            }

            @Override
            public FieldValues<Number> compile(String fieldName, Script script, ScriptCompiler compiler) {
                DoubleFieldScript.Factory scriptFactory = compiler.compile(script, DoubleFieldScript.CONTEXT);
                return (lookup, ctx, doc, consumer) -> scriptFactory.newFactory(fieldName, script.getParams(), lookup).newInstance(ctx).runForDoc(doc, consumer::accept);
            }

            @Override
            public Query termQuery(String field, Object value, boolean isIndexed) {
                double v = this.parse(value, false);
                if (isIndexed) {
                    return DoublePoint.newExactQuery((String)field, (double)v);
                }
                return SortedNumericDocValuesField.newSlowExactQuery((String)field, (long)NumericUtils.doubleToSortableLong((double)v));
            }

            @Override
            public Query termsQuery(String field, Collection<?> values) {
                double[] v = values.stream().mapToDouble(value -> this.parse(value, false)).toArray();
                return DoublePoint.newSetQuery((String)field, (double[])v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, SearchExecutionContext context, boolean isIndexed) {
                return 3.doubleRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, (l, u) -> {
                    Query query;
                    if (isIndexed) {
                        query = DoublePoint.newRangeQuery((String)field, (double)l, (double)u);
                        if (hasDocValues) {
                            Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)NumericUtils.doubleToSortableLong((double)l), (long)NumericUtils.doubleToSortableLong((double)u));
                            query = new IndexOrDocValuesQuery(query, dvQuery);
                        }
                    } else {
                        query = SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)NumericUtils.doubleToSortableLong((double)l), (long)NumericUtils.doubleToSortableLong((double)u));
                    }
                    return query;
                });
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add((Field)new DoublePoint(name, new double[]{value.doubleValue()}));
                }
                if (docValued) {
                    fields.add((Field)new SortedNumericDocValuesField(name, NumericUtils.doubleToSortableLong((double)value.doubleValue())));
                }
                if (stored) {
                    fields.add((Field)new StoredField(name, value.doubleValue()));
                }
                return fields;
            }

            @Override
            public IndexFieldData.Builder getFieldDataBuilder(String name) {
                return new SortedDoublesIndexFieldData.Builder(name, this.numericType(), DoubleDocValuesField::new);
            }

            private void validateParsed(double value) {
                if (!Double.isFinite(value)) {
                    throw new IllegalArgumentException("[double] supports only finite values, but got [" + value + "]");
                }
            }
        }
        ,
        BYTE("byte", IndexNumericFieldData.NumericType.BYTE){

            @Override
            public Byte parse(Object value, boolean coerce) {
                double doubleValue = 4.objectToDouble(value);
                if (doubleValue < -128.0 || doubleValue > 127.0) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a byte");
                }
                if (!coerce && doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                }
                if (value instanceof Number) {
                    return ((Number)value).byteValue();
                }
                return (byte)doubleValue;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return INTEGER.parsePoint(value).byteValue();
            }

            @Override
            public Short parse(XContentParser parser, boolean coerce) throws IOException {
                int value = parser.intValue(coerce);
                if (value < -128 || value > 127) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a byte");
                }
                return (short)value;
            }

            @Override
            public Query termQuery(String field, Object value, boolean isIndexed) {
                return INTEGER.termQuery(field, value, isIndexed);
            }

            @Override
            public Query termsQuery(String field, Collection<?> values) {
                return INTEGER.termsQuery(field, values);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, SearchExecutionContext context, boolean isIndexed) {
                return INTEGER.rangeQuery(field, lowerTerm, upperTerm, includeLower, includeUpper, hasDocValues, context, isIndexed);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                return INTEGER.createFields(name, value, indexed, docValued, stored);
            }

            @Override
            Number valueForSearch(Number value) {
                return value.byteValue();
            }

            @Override
            public IndexFieldData.Builder getFieldDataBuilder(String name) {
                return new SortedNumericIndexFieldData.Builder(name, this.numericType(), ByteDocValuesField::new);
            }
        }
        ,
        SHORT("short", IndexNumericFieldData.NumericType.SHORT){

            @Override
            public Short parse(Object value, boolean coerce) {
                double doubleValue = 5.objectToDouble(value);
                if (doubleValue < -32768.0 || doubleValue > 32767.0) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a short");
                }
                if (!coerce && doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                }
                if (value instanceof Number) {
                    return ((Number)value).shortValue();
                }
                return (short)doubleValue;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return INTEGER.parsePoint(value).shortValue();
            }

            @Override
            public Short parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.shortValue(coerce);
            }

            @Override
            public Query termQuery(String field, Object value, boolean isIndexed) {
                return INTEGER.termQuery(field, value, isIndexed);
            }

            @Override
            public Query termsQuery(String field, Collection<?> values) {
                return INTEGER.termsQuery(field, values);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, SearchExecutionContext context, boolean isIndexed) {
                return INTEGER.rangeQuery(field, lowerTerm, upperTerm, includeLower, includeUpper, hasDocValues, context, isIndexed);
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                return INTEGER.createFields(name, value, indexed, docValued, stored);
            }

            @Override
            Number valueForSearch(Number value) {
                return value.shortValue();
            }

            @Override
            public IndexFieldData.Builder getFieldDataBuilder(String name) {
                return new SortedNumericIndexFieldData.Builder(name, this.numericType(), ShortDocValuesField::new);
            }
        }
        ,
        INTEGER("integer", IndexNumericFieldData.NumericType.INT){

            @Override
            public Integer parse(Object value, boolean coerce) {
                double doubleValue = 6.objectToDouble(value);
                if (doubleValue < -2.147483648E9 || doubleValue > 2.147483647E9) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for an integer");
                }
                if (!coerce && doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
                }
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                return (int)doubleValue;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return IntPoint.decodeDimension((byte[])value, (int)0);
            }

            @Override
            public Integer parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.intValue(coerce);
            }

            @Override
            public Query termQuery(String field, Object value, boolean isIndexed) {
                if (6.hasDecimalPart(value)) {
                    return Queries.newMatchNoDocsQuery("Value [" + value + "] has a decimal part");
                }
                int v = this.parse(value, true);
                if (isIndexed) {
                    return IntPoint.newExactQuery((String)field, (int)v);
                }
                return SortedNumericDocValuesField.newSlowExactQuery((String)field, (long)v);
            }

            @Override
            public Query termsQuery(String field, Collection<?> values) {
                int[] v = new int[values.size()];
                int upTo = 0;
                for (Object value : values) {
                    if (6.hasDecimalPart(value)) continue;
                    v[upTo++] = this.parse(value, true);
                }
                if (upTo == 0) {
                    return Queries.newMatchNoDocsQuery("All values have a decimal part");
                }
                if (upTo != v.length) {
                    v = Arrays.copyOf(v, upTo);
                }
                return IntPoint.newSetQuery((String)field, (int[])v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, SearchExecutionContext context, boolean isIndexed) {
                Query query;
                int l = Integer.MIN_VALUE;
                int u = Integer.MAX_VALUE;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, true);
                    boolean lowerTermHasDecimalPart = 6.hasDecimalPart(lowerTerm);
                    if (!lowerTermHasDecimalPart && !includeLower || lowerTermHasDecimalPart && 6.signum(lowerTerm) > 0.0) {
                        if (l == Integer.MAX_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        ++l;
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, true);
                    boolean upperTermHasDecimalPart = 6.hasDecimalPart(upperTerm);
                    if (!upperTermHasDecimalPart && !includeUpper || upperTermHasDecimalPart && 6.signum(upperTerm) < 0.0) {
                        if (u == Integer.MIN_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        --u;
                    }
                }
                if (isIndexed) {
                    query = IntPoint.newRangeQuery((String)field, (int)l, (int)u);
                    if (hasDocValues) {
                        Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)l, (long)u);
                        query = new IndexOrDocValuesQuery(query, dvQuery);
                    }
                } else {
                    query = SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)l, (long)u);
                }
                if (hasDocValues && context.indexSortedOnField(field)) {
                    query = new IndexSortSortedNumericDocValuesRangeQuery(field, (long)l, (long)u, query);
                }
                return query;
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add((Field)new IntPoint(name, new int[]{value.intValue()}));
                }
                if (docValued) {
                    fields.add((Field)new SortedNumericDocValuesField(name, (long)value.intValue()));
                }
                if (stored) {
                    fields.add((Field)new StoredField(name, value.intValue()));
                }
                return fields;
            }

            @Override
            public IndexFieldData.Builder getFieldDataBuilder(String name) {
                return new SortedNumericIndexFieldData.Builder(name, this.numericType(), IntegerDocValuesField::new);
            }
        }
        ,
        LONG("long", IndexNumericFieldData.NumericType.LONG){

            @Override
            public Long parse(Object value, boolean coerce) {
                return 7.objectToLong(value, coerce);
            }

            @Override
            public Number parsePoint(byte[] value) {
                return LongPoint.decodeDimension((byte[])value, (int)0);
            }

            @Override
            public Long parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.longValue(coerce);
            }

            @Override
            public FieldValues<Number> compile(String fieldName, Script script, ScriptCompiler compiler) {
                LongFieldScript.Factory scriptFactory = compiler.compile(script, LongFieldScript.CONTEXT);
                return (lookup, ctx, doc, consumer) -> scriptFactory.newFactory(fieldName, script.getParams(), lookup).newInstance(ctx).runForDoc(doc, consumer::accept);
            }

            @Override
            public Query termQuery(String field, Object value, boolean isIndexed) {
                if (7.hasDecimalPart(value)) {
                    return Queries.newMatchNoDocsQuery("Value [" + value + "] has a decimal part");
                }
                long v = this.parse(value, true);
                if (isIndexed) {
                    return LongPoint.newExactQuery((String)field, (long)v);
                }
                return SortedNumericDocValuesField.newSlowExactQuery((String)field, (long)v);
            }

            @Override
            public Query termsQuery(String field, Collection<?> values) {
                long[] v = new long[values.size()];
                int upTo = 0;
                for (Object value : values) {
                    if (7.hasDecimalPart(value)) continue;
                    v[upTo++] = this.parse(value, true);
                }
                if (upTo == 0) {
                    return Queries.newMatchNoDocsQuery("All values have a decimal part");
                }
                if (upTo != v.length) {
                    v = Arrays.copyOf(v, upTo);
                }
                return LongPoint.newSetQuery((String)field, (long[])v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, SearchExecutionContext context, boolean isIndexed) {
                return 7.longRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, (l, u) -> {
                    Query query;
                    if (isIndexed) {
                        query = LongPoint.newRangeQuery((String)field, (long)l, (long)u);
                        if (hasDocValues) {
                            Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)l, (long)u);
                            query = new IndexOrDocValuesQuery(query, dvQuery);
                        }
                    } else {
                        query = SortedNumericDocValuesField.newSlowRangeQuery((String)field, (long)l, (long)u);
                    }
                    if (hasDocValues && context.indexSortedOnField(field)) {
                        query = new IndexSortSortedNumericDocValuesRangeQuery(field, l.longValue(), u.longValue(), query);
                    }
                    return query;
                });
            }

            @Override
            public List<Field> createFields(String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                ArrayList<Field> fields = new ArrayList<Field>();
                if (indexed) {
                    fields.add((Field)new LongPoint(name, new long[]{value.longValue()}));
                }
                if (docValued) {
                    fields.add((Field)new SortedNumericDocValuesField(name, value.longValue()));
                }
                if (stored) {
                    fields.add((Field)new StoredField(name, value.longValue()));
                }
                return fields;
            }

            @Override
            public IndexFieldData.Builder getFieldDataBuilder(String name) {
                return new SortedNumericIndexFieldData.Builder(name, this.numericType(), LongDocValuesField::new);
            }
        };

        private final String name;
        private final IndexNumericFieldData.NumericType numericType;
        private final FieldMapper.TypeParser parser;

        private NumberType(String name, IndexNumericFieldData.NumericType numericType) {
            this.name = name;
            this.numericType = numericType;
            this.parser = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, this, c.scriptCompiler(), c.getSettings()));
        }

        public final String typeName() {
            return this.name;
        }

        public final IndexNumericFieldData.NumericType numericType() {
            return this.numericType;
        }

        public final FieldMapper.TypeParser parser() {
            return this.parser;
        }

        public abstract Query termQuery(String var1, Object var2, boolean var3);

        public abstract Query termsQuery(String var1, Collection<?> var2);

        public abstract Query rangeQuery(String var1, Object var2, Object var3, boolean var4, boolean var5, boolean var6, SearchExecutionContext var7, boolean var8);

        public abstract Number parse(XContentParser var1, boolean var2) throws IOException;

        public abstract Number parse(Object var1, boolean var2);

        public abstract Number parsePoint(byte[] var1);

        public abstract List<Field> createFields(String var1, Number var2, boolean var3, boolean var4, boolean var5);

        public FieldValues<Number> compile(String fieldName, Script script, ScriptCompiler compiler) {
            throw new IllegalArgumentException("Unknown parameter [script] for mapper [" + fieldName + "]");
        }

        Number valueForSearch(Number value) {
            return value;
        }

        public static boolean hasDecimalPart(Object number) {
            if (number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long) {
                return false;
            }
            if (number instanceof Number) {
                double doubleValue = ((Number)number).doubleValue();
                return doubleValue % 1.0 != 0.0;
            }
            if (number instanceof BytesRef) {
                number = ((BytesRef)number).utf8ToString();
            }
            if (number instanceof String) {
                return Double.parseDouble((String)number) % 1.0 != 0.0;
            }
            return false;
        }

        static double signum(Object value) {
            if (value instanceof Number) {
                double doubleValue = ((Number)value).doubleValue();
                return Math.signum(doubleValue);
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return Math.signum(Double.parseDouble(value.toString()));
        }

        public static double objectToDouble(Object value) {
            double doubleValue = value instanceof Number ? ((Number)value).doubleValue() : (value instanceof BytesRef ? Double.parseDouble(((BytesRef)value).utf8ToString()) : Double.parseDouble(value.toString()));
            return doubleValue;
        }

        public static long objectToLong(Object value, boolean coerce) {
            if (value instanceof Long) {
                return (Long)value;
            }
            double doubleValue = NumberType.objectToDouble(value);
            if (doubleValue < -9.223372036854776E18 || doubleValue > 9.223372036854776E18) {
                throw new IllegalArgumentException("Value [" + value + "] is out of range for a long");
            }
            if (!coerce && doubleValue % 1.0 != 0.0) {
                throw new IllegalArgumentException("Value [" + value + "] has a decimal part");
            }
            String stringValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            return Numbers.toLong(stringValue, coerce);
        }

        public static Query doubleRangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, BiFunction<Double, Double, Query> builder) {
            double l = Double.NEGATIVE_INFINITY;
            double u = Double.POSITIVE_INFINITY;
            if (lowerTerm != null) {
                l = NumberType.objectToDouble(lowerTerm);
                if (!includeLower) {
                    l = DoublePoint.nextUp((double)l);
                }
            }
            if (upperTerm != null) {
                u = NumberType.objectToDouble(upperTerm);
                if (!includeUpper) {
                    u = DoublePoint.nextDown((double)u);
                }
            }
            return builder.apply(l, u);
        }

        public static Query longRangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, BiFunction<Long, Long, Query> builder) {
            long l = Long.MIN_VALUE;
            long u = Long.MAX_VALUE;
            if (lowerTerm != null) {
                l = NumberType.objectToLong(lowerTerm, true);
                boolean lowerTermHasDecimalPart = NumberType.hasDecimalPart(lowerTerm);
                if (!lowerTermHasDecimalPart && !includeLower || lowerTermHasDecimalPart && NumberType.signum(lowerTerm) > 0.0) {
                    if (l == Long.MAX_VALUE) {
                        return new MatchNoDocsQuery();
                    }
                    ++l;
                }
            }
            if (upperTerm != null) {
                u = NumberType.objectToLong(upperTerm, true);
                boolean upperTermHasDecimalPart = NumberType.hasDecimalPart(upperTerm);
                if (!upperTermHasDecimalPart && !includeUpper || upperTermHasDecimalPart && NumberType.signum(upperTerm) < 0.0) {
                    if (u == Long.MIN_VALUE) {
                        return new MatchNoDocsQuery();
                    }
                    --u;
                }
            }
            return builder.apply(l, u);
        }

        public abstract IndexFieldData.Builder getFieldDataBuilder(String var1);

        public double reduceToStoredPrecision(double value) {
            return value;
        }
    }

    public static class NumberFieldType
    extends SimpleMappedFieldType {
        private final NumberType type;
        private final boolean coerce;
        private final Number nullValue;
        private final FieldValues<Number> scriptValues;
        private final boolean isDimension;
        private final TimeSeriesParams.MetricType metricType;

        public NumberFieldType(String name, NumberType type, boolean isIndexed, boolean isStored, boolean hasDocValues, boolean coerce, Number nullValue, Map<String, String> meta, FieldValues<Number> script, boolean isDimension, TimeSeriesParams.MetricType metricType) {
            super(name, isIndexed, isStored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, meta);
            this.type = Objects.requireNonNull(type);
            this.coerce = coerce;
            this.nullValue = nullValue;
            this.scriptValues = script;
            this.isDimension = isDimension;
            this.metricType = metricType;
        }

        NumberFieldType(String name, Builder builder) {
            this(name, builder.type, builder.indexed.getValue(), builder.stored.getValue(), builder.hasDocValues.getValue(), builder.coerce.getValue().value(), builder.nullValue.getValue(), builder.meta.getValue(), builder.scriptValues(), builder.dimension.getValue(), builder.metric.getValue());
        }

        public NumberFieldType(String name, NumberType type) {
            this(name, type, true);
        }

        public NumberFieldType(String name, NumberType type, boolean isIndexed) {
            this(name, type, isIndexed, false, true, true, null, Collections.emptyMap(), null, false, null);
        }

        @Override
        public String typeName() {
            return this.type.name;
        }

        public double reduceToStoredPrecision(double value) {
            if (Double.isInfinite(value)) {
                return value;
            }
            return this.type.reduceToStoredPrecision(value);
        }

        public IndexNumericFieldData.NumericType numericType() {
            return this.type.numericType();
        }

        @Override
        public boolean mayExistInIndex(SearchExecutionContext context) {
            return context.fieldExistsInIndex(this.name());
        }

        @Override
        public boolean isSearchable() {
            return this.isIndexed() || this.hasDocValues();
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            return this.type.termQuery(this.name(), value, this.isIndexed());
        }

        @Override
        public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.isIndexed()) {
                return this.type.termsQuery(this.name(), values);
            }
            return super.termsQuery(values, context);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            return this.type.rangeQuery(this.name(), lowerTerm, upperTerm, includeLower, includeUpper, this.hasDocValues(), context, this.isIndexed());
        }

        @Override
        public Function<byte[], Number> pointReaderIfPossible() {
            if (this.isIndexed()) {
                return this::parsePoint;
            }
            return null;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return this.type.getFieldDataBuilder(this.name());
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return this.type.valueForSearch((Number)value);
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            if (this.scriptValues != null) {
                return FieldValues.valueFetcher(this.scriptValues, context);
            }
            return new SourceValueFetcher(this.name(), context, this.nullValue){

                @Override
                protected Object parseSourceValue(Object value) {
                    if (value.equals("")) {
                        return nullValue;
                    }
                    return type.parse(value, coerce);
                }
            };
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            this.checkNoTimeZone(timeZone);
            if (format == null) {
                return DocValueFormat.RAW;
            }
            return new DocValueFormat.Decimal(format);
        }

        public Number parsePoint(byte[] value) {
            return this.type.parsePoint(value);
        }

        @Override
        public MappedFieldType.CollapseType collapseType() {
            return MappedFieldType.CollapseType.NUMERIC;
        }

        @Override
        public boolean isDimension() {
            return this.isDimension;
        }

        @Override
        public TimeSeriesParams.MetricType getMetricType() {
            return this.metricType;
        }
    }
}

