/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.script.ScriptCompiler;

public class MappingParserContext {
    private final Function<String, SimilarityProvider> similarityLookupService;
    private final Function<String, Mapper.TypeParser> typeParsers;
    private final Function<String, RuntimeField.Parser> runtimeFieldParsers;
    private final Version indexVersionCreated;
    private final Supplier<SearchExecutionContext> searchExecutionContextSupplier;
    private final DateFormatter dateFormatter;
    private final ScriptCompiler scriptCompiler;
    private final IndexAnalyzers indexAnalyzers;
    private final IndexSettings indexSettings;
    private final IdFieldMapper idFieldMapper;

    public MappingParserContext(Function<String, SimilarityProvider> similarityLookupService, Function<String, Mapper.TypeParser> typeParsers, Function<String, RuntimeField.Parser> runtimeFieldParsers, Version indexVersionCreated, Supplier<SearchExecutionContext> searchExecutionContextSupplier, DateFormatter dateFormatter, ScriptCompiler scriptCompiler, IndexAnalyzers indexAnalyzers, IndexSettings indexSettings, IdFieldMapper idFieldMapper) {
        this.similarityLookupService = similarityLookupService;
        this.typeParsers = typeParsers;
        this.runtimeFieldParsers = runtimeFieldParsers;
        this.indexVersionCreated = indexVersionCreated;
        this.searchExecutionContextSupplier = searchExecutionContextSupplier;
        this.dateFormatter = dateFormatter;
        this.scriptCompiler = scriptCompiler;
        this.indexAnalyzers = indexAnalyzers;
        this.indexSettings = indexSettings;
        this.idFieldMapper = idFieldMapper;
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.indexAnalyzers;
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public IdFieldMapper idFieldMapper() {
        return this.idFieldMapper;
    }

    public Settings getSettings() {
        return this.indexSettings.getSettings();
    }

    public SimilarityProvider getSimilarity(String name) {
        return this.similarityLookupService.apply(name);
    }

    public Mapper.TypeParser typeParser(String type) {
        return this.typeParsers.apply(type);
    }

    public RuntimeField.Parser runtimeFieldParser(String type) {
        return this.runtimeFieldParsers.apply(type);
    }

    public Version indexVersionCreated() {
        return this.indexVersionCreated;
    }

    public Supplier<SearchExecutionContext> searchExecutionContext() {
        return this.searchExecutionContextSupplier;
    }

    public DateFormatter getDateFormatter() {
        return this.dateFormatter;
    }

    public boolean isWithinMultiField() {
        return false;
    }

    public boolean isFromDynamicTemplate() {
        return false;
    }

    public ScriptCompiler scriptCompiler() {
        return this.scriptCompiler;
    }

    MappingParserContext createMultiFieldContext(MappingParserContext in) {
        return new MultiFieldParserContext(in);
    }

    private static class MultiFieldParserContext
    extends MappingParserContext {
        MultiFieldParserContext(MappingParserContext in) {
            super(in.similarityLookupService, in.typeParsers, in.runtimeFieldParsers, in.indexVersionCreated, in.searchExecutionContextSupplier, in.dateFormatter, in.scriptCompiler, in.indexAnalyzers, in.indexSettings, in.idFieldMapper);
        }

        @Override
        public boolean isWithinMultiField() {
            return true;
        }
    }

    static class DynamicTemplateParserContext
    extends MappingParserContext {
        DynamicTemplateParserContext(MappingParserContext in) {
            super(in.similarityLookupService, in.typeParsers, in.runtimeFieldParsers, in.indexVersionCreated, in.searchExecutionContextSupplier, in.dateFormatter, in.scriptCompiler, in.indexAnalyzers, in.indexSettings, in.idFieldMapper);
        }

        @Override
        public boolean isFromDynamicTemplate() {
            return true;
        }
    }
}

