/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.RootObjectMapper;
import org.elasticsearch.xcontent.XContentType;

public final class MappingParser {
    private final Supplier<MappingParserContext> parserContextSupplier;
    private final RootObjectMapper.TypeParser rootObjectTypeParser = new RootObjectMapper.TypeParser();
    private final Supplier<Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>> metadataMappersSupplier;
    private final Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers;
    private final Function<String, String> documentTypeResolver;

    MappingParser(Supplier<MappingParserContext> parserContextSupplier, Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers, Supplier<Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>> metadataMappersSupplier, Function<String, String> documentTypeResolver) {
        this.parserContextSupplier = parserContextSupplier;
        this.metadataMapperParsers = metadataMapperParsers;
        this.metadataMappersSupplier = metadataMappersSupplier;
        this.documentTypeResolver = documentTypeResolver;
    }

    public static void checkNoRemainingFields(String fieldName, Map<?, ?> fieldNodeMap) {
        MappingParser.checkNoRemainingFields(fieldNodeMap, "Mapping definition for [" + fieldName + "] has unsupported parameters: ");
    }

    public static void checkNoRemainingFields(Map<?, ?> fieldNodeMap, String message) {
        if (!fieldNodeMap.isEmpty()) {
            throw new MapperParsingException(message + MappingParser.getRemainingFields(fieldNodeMap));
        }
    }

    private static String getRemainingFields(Map<?, ?> map) {
        StringBuilder remainingFields = new StringBuilder();
        for (Object key : map.keySet()) {
            remainingFields.append(" [").append(key).append(" : ").append(map.get(key)).append("]");
        }
        return remainingFields.toString();
    }

    Mapping parse(@Nullable String type, CompressedXContent source) throws MapperParsingException {
        Objects.requireNonNull(source, "source cannot be null");
        Map mapping = (Map)XContentHelper.convertToMap(source.compressedReference(), true, XContentType.JSON).v2();
        if (mapping.isEmpty()) {
            if (type == null) {
                throw new MapperParsingException("malformed mapping, no type name found");
            }
        } else {
            String rootName = (String)mapping.keySet().iterator().next();
            if (type == null || type.equals(rootName) || this.documentTypeResolver.apply(type).equals(rootName)) {
                type = rootName;
                mapping = (Map)mapping.get(rootName);
            }
        }
        if (type == null) {
            throw new MapperParsingException("Failed to derive type");
        }
        return this.parse(type, mapping);
    }

    private Mapping parse(String type, Map<String, Object> mapping) throws MapperParsingException {
        MappingParserContext parserContext = this.parserContextSupplier.get();
        RootObjectMapper rootObjectMapper = ((RootObjectMapper.Builder)this.rootObjectTypeParser.parse(type, (Map)mapping, parserContext)).build(MapperBuilderContext.ROOT);
        Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> metadataMappers = this.metadataMappersSupplier.get();
        Map<String, Object> meta = null;
        Iterator<Map.Entry<String, Object>> iterator = mapping.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String fieldName = entry.getKey();
            Object fieldNode = entry.getValue();
            MetadataFieldMapper.TypeParser typeParser = this.metadataMapperParsers.get(fieldName);
            if (typeParser == null) continue;
            iterator.remove();
            if (!(fieldNode instanceof Map)) {
                throw new IllegalArgumentException("[" + fieldName + "] config must be an object");
            }
            Map fieldNodeMap = (Map)fieldNode;
            MetadataFieldMapper metadataFieldMapper = ((MetadataFieldMapper.Builder)typeParser.parse(fieldName, fieldNodeMap, parserContext)).build(MapperBuilderContext.ROOT);
            metadataMappers.put(metadataFieldMapper.getClass(), metadataFieldMapper);
            fieldNodeMap.remove("type");
            MappingParser.checkNoRemainingFields(fieldName, fieldNodeMap);
        }
        Map removed = (Map)mapping.remove("_meta");
        if (removed != null) {
            meta = Collections.unmodifiableMap(new HashMap(removed));
        }
        MappingParser.checkNoRemainingFields(mapping, "Root mapping definition has unsupported parameters: ");
        return new Mapping(rootObjectMapper, metadataMappers.values().toArray(new MetadataFieldMapper[0]), meta);
    }
}

