/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;

public abstract class Mapper
implements ToXContentFragment,
Iterable<Mapper> {
    private final String simpleName;

    public Mapper(String simpleName) {
        Objects.requireNonNull(simpleName);
        this.simpleName = simpleName;
    }

    public final String simpleName() {
        return this.simpleName;
    }

    public abstract String name();

    public abstract String typeName();

    public abstract Mapper merge(Mapper var1);

    public abstract void validate(MappingLookup var1);

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static interface TypeParser {
        public Builder parse(String var1, Map<String, Object> var2, MappingParserContext var3) throws MapperParsingException;
    }

    public static abstract class Builder {
        protected final String name;

        protected Builder(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public abstract Mapper build(MapperBuilderContext var1);
    }
}

