/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesReference;

public class LuceneDocument
implements Iterable<IndexableField> {
    private final LuceneDocument parent;
    private final String path;
    private final String prefix;
    private final List<IndexableField> fields = new ArrayList<IndexableField>();
    private Map<Object, IndexableField> keyedFields;
    private SortedMap<String, BytesReference> dimensionBytes;

    LuceneDocument(String path, LuceneDocument parent) {
        this.path = path;
        this.prefix = path.isEmpty() ? "" : path + ".";
        this.parent = parent;
    }

    public LuceneDocument() {
        this("", null);
    }

    public String getPath() {
        return this.path;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public LuceneDocument getParent() {
        return this.parent;
    }

    @Override
    public Iterator<IndexableField> iterator() {
        return this.fields.iterator();
    }

    public List<IndexableField> getFields() {
        return this.fields;
    }

    public void addAll(List<? extends IndexableField> fields) {
        this.fields.addAll(fields);
    }

    public void add(IndexableField field) {
        assert (field.name().startsWith("_") || field.name().startsWith(this.prefix)) : field.name() + " " + this.prefix;
        this.fields.add(field);
    }

    public void addWithKey(Object key, IndexableField field) {
        if (this.keyedFields == null) {
            this.keyedFields = new HashMap<Object, IndexableField>();
        } else if (this.keyedFields.containsKey(key)) {
            throw new IllegalStateException("Only one field can be stored per key");
        }
        this.keyedFields.put(key, field);
        this.add(field);
    }

    public IndexableField getByKey(Object key) {
        return this.keyedFields == null ? null : this.keyedFields.get(key);
    }

    public void addDimensionBytes(String fieldName, BytesReference tsidBytes) {
        if (this.dimensionBytes == null) {
            this.dimensionBytes = new TreeMap<String, BytesReference>();
        } else if (this.dimensionBytes.containsKey(fieldName)) {
            throw new IllegalArgumentException("Dimension field [" + fieldName + "] cannot be a multi-valued field.");
        }
        this.dimensionBytes.put(fieldName, tsidBytes);
    }

    public SortedMap<String, BytesReference> getDimensionBytes() {
        if (this.dimensionBytes == null) {
            return Collections.emptySortedMap();
        }
        return this.dimensionBytes;
    }

    public IndexableField[] getFields(String name) {
        ArrayList<IndexableField> f = new ArrayList<IndexableField>();
        for (IndexableField field : this.fields) {
            if (!field.name().equals(name)) continue;
            f.add(field);
        }
        return f.toArray(new IndexableField[f.size()]);
    }

    public IndexableField getField(String name) {
        for (IndexableField field : this.fields) {
            if (!field.name().equals(name)) continue;
            return field;
        }
        return null;
    }

    public String get(String name) {
        for (IndexableField f : this.fields) {
            if (!f.name().equals(name) || f.stringValue() == null) continue;
            return f.stringValue();
        }
        return null;
    }

    public BytesRef getBinaryValue(String name) {
        for (IndexableField f : this.fields) {
            if (!f.name().equals(name) || f.binaryValue() == null) continue;
            return f.binaryValue();
        }
        return null;
    }

    public Number getNumericValue(String name) {
        for (IndexableField f : this.fields) {
            if (!f.name().equals(name) || f.numericValue() == null) continue;
            return f.numericValue();
        }
        return null;
    }
}

