/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Query;
import org.elasticsearch.Version;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentLeafReader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.index.mapper.NestedPathFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.RootObjectMapper;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.StrictDynamicMappingException;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xcontent.DotExpandingXContentParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public final class DocumentParser {
    private final XContentParserConfiguration parserConfiguration;
    private final Function<DateFormatter, MappingParserContext> dateParserContext;
    private final IndexSettings indexSettings;
    private final IndexAnalyzers indexAnalyzers;
    private static final FieldMapper NO_OP_FIELDMAPPER = new FieldMapper("no-op", new MappedFieldType("no-op", false, false, false, TextSearchInfo.NONE, Collections.emptyMap()){

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String typeName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new UnsupportedOperationException();
        }
    }, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty()){

        @Override
        protected void parseCreateField(DocumentParserContext context) throws IOException {
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String typeName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MappedFieldType fieldType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FieldMapper.MultiFields multiFields() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Mapper> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void doValidate(MappingLookup mappers) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void checkIncomingMergeType(FieldMapper mergeWith) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FieldMapper.Builder getMergeBuilder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected String contentType() {
            throw new UnsupportedOperationException();
        }
    };

    DocumentParser(XContentParserConfiguration parserConfiguration, Function<DateFormatter, MappingParserContext> dateParserContext, IndexSettings indexSettings, IndexAnalyzers indexAnalyzers) {
        this.dateParserContext = dateParserContext;
        this.parserConfiguration = parserConfiguration;
        this.indexSettings = indexSettings;
        this.indexAnalyzers = indexAnalyzers;
    }

    public ParsedDocument parseDocument(SourceToParse source, MappingLookup mappingLookup) throws MapperParsingException {
        InternalDocumentParserContext context;
        XContentType xContentType = source.getXContentType();
        try (XContentParser parser = XContentHelper.createParser(this.parserConfiguration, source.source(), xContentType);){
            context = new InternalDocumentParserContext(mappingLookup, this.indexSettings, this.indexAnalyzers, this.dateParserContext, source, parser);
            DocumentParser.validateStart(context.parser());
            MetadataFieldMapper[] metadataFieldsMappers = mappingLookup.getMapping().getSortedMetadataMappers();
            DocumentParser.internalParseDocument(mappingLookup.getMapping().getRoot(), metadataFieldsMappers, context);
            DocumentParser.validateEnd(context.parser());
        }
        catch (Exception e) {
            throw DocumentParser.wrapInMapperParsingException(source, e);
        }
        String remainingPath = context.path().pathAsText("");
        if (!remainingPath.isEmpty()) {
            throw new IllegalStateException("found leftover path elements: " + remainingPath);
        }
        return new ParsedDocument(context.version(), context.seqID(), context.sourceToParse().id(), source.routing(), context.reorderParentAndGetDocs(), context.sourceToParse().source(), context.sourceToParse().getXContentType(), DocumentParser.createDynamicUpdate(context));
    }

    private static void internalParseDocument(RootObjectMapper root, MetadataFieldMapper[] metadataFieldsMappers, DocumentParserContext context) throws IOException {
        boolean emptyDoc = DocumentParser.isEmptyDoc(root, context.parser());
        for (MetadataFieldMapper metadataMapper : metadataFieldsMappers) {
            metadataMapper.preParse(context);
        }
        if (!root.isEnabled()) {
            context.parser().skipChildren();
        } else if (!emptyDoc) {
            DocumentParser.parseObjectOrNested(context, root);
        }
        DocumentParser.executeIndexTimeScripts(context);
        for (MetadataFieldMapper metadataMapper : metadataFieldsMappers) {
            metadataMapper.postParse(context);
        }
    }

    private static void executeIndexTimeScripts(final DocumentParserContext context) {
        List<FieldMapper> indexTimeScriptMappers = context.mappingLookup().indexTimeScriptMappers();
        if (indexTimeScriptMappers.isEmpty()) {
            return;
        }
        final SearchLookup searchLookup = new SearchLookup(context.mappingLookup().indexTimeLookup()::get, (ft, lookup) -> ft.fielddataBuilder(context.indexSettings().getIndex().getName(), (Supplier<SearchLookup>)lookup).build(new IndexFieldDataCache.None(), new NoneCircuitBreakerService()));
        HashMap<String, Consumer<LeafReaderContext>> fieldScripts = new HashMap<String, Consumer<LeafReaderContext>>();
        indexTimeScriptMappers.forEach(mapper -> fieldScripts.put(mapper.name(), new Consumer<LeafReaderContext>(){
            boolean executed = false;

            @Override
            public void accept(LeafReaderContext leafReaderContext) {
                if (!this.executed) {
                    mapper.executeScript(searchLookup, leafReaderContext, 0, context);
                    this.executed = true;
                }
            }
        }));
        DocumentLeafReader reader = new DocumentLeafReader(context.rootDoc(), fieldScripts);
        for (Consumer script : fieldScripts.values()) {
            script.accept(reader.getContext());
        }
    }

    private static void validateStart(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new MapperParsingException("Malformed content, must start with an object");
        }
    }

    private static void validateEnd(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != null) {
            throw new IllegalArgumentException("Malformed content, found extra data after parsing: " + token);
        }
    }

    private static boolean isEmptyDoc(RootObjectMapper root, XContentParser parser) throws IOException {
        if (root.isEnabled()) {
            XContentParser.Token token = parser.nextToken();
            if (token == XContentParser.Token.END_OBJECT) {
                return true;
            }
            if (token != XContentParser.Token.FIELD_NAME) {
                throw new MapperParsingException("Malformed content, after first object, either the type field or the actual properties should exist");
            }
        }
        return false;
    }

    private static MapperParsingException wrapInMapperParsingException(SourceToParse source, Exception e) {
        if (e instanceof MapperParsingException) {
            return (MapperParsingException)e;
        }
        if (source.source() != null && source.source().length() == 0) {
            return new MapperParsingException("failed to parse, document is empty");
        }
        return new MapperParsingException("failed to parse", e);
    }

    static Mapping createDynamicUpdate(DocumentParserContext context) {
        if (context.getDynamicMappers().isEmpty() && context.getDynamicRuntimeFields().isEmpty()) {
            return null;
        }
        RootObjectMapper.Builder rootBuilder = context.updateRoot();
        for (Mapper mapper : context.getDynamicMappers()) {
            rootBuilder.addDynamic(mapper.name(), null, mapper, context);
        }
        for (RuntimeField runtimeField : context.getDynamicRuntimeFields()) {
            rootBuilder.addRuntimeField(runtimeField);
        }
        RootObjectMapper root = rootBuilder.build(MapperBuilderContext.ROOT);
        root.fixRedundantIncludes();
        return context.mappingLookup().getMapping().mappingUpdate(root);
    }

    static void parseObjectOrNested(DocumentParserContext context, ObjectMapper mapper) throws IOException {
        if (!mapper.isEnabled()) {
            context.parser().skipChildren();
            return;
        }
        XContentParser parser = context.parser();
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_NULL) {
            return;
        }
        String currentFieldName = parser.currentName();
        if (token.isValue()) {
            throw new MapperParsingException("object mapping for [" + mapper.name() + "] tried to parse field [" + currentFieldName + "] as object, but found a concrete value");
        }
        if (mapper.isNested()) {
            context = DocumentParser.nestedContext(context, (NestedObjectMapper)mapper);
        }
        if (token == XContentParser.Token.END_OBJECT) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.START_OBJECT) {
            parser.nextToken();
        }
        DocumentParser.innerParseObject(context, mapper);
        if (mapper.isNested()) {
            DocumentParser.nested(context, (NestedObjectMapper)mapper);
        }
    }

    private static void innerParseObject(DocumentParserContext context, ObjectMapper mapper) throws IOException {
        XContentParser.Token token = context.parser().currentToken();
        String currentFieldName = context.parser().currentName();
        assert (token == XContentParser.Token.FIELD_NAME || token == XContentParser.Token.END_OBJECT);
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = context.parser().currentName();
                if (currentFieldName.isBlank()) {
                    throw new MapperParsingException("Field name cannot contain only whitespace: [" + context.path().pathAsText(currentFieldName) + "]");
                }
            } else if (token == XContentParser.Token.START_OBJECT) {
                DocumentParser.parseObject(context, mapper, currentFieldName);
            } else if (token == XContentParser.Token.START_ARRAY) {
                DocumentParser.parseArray(context, mapper, currentFieldName);
            } else if (token == XContentParser.Token.VALUE_NULL) {
                DocumentParser.parseNullValue(context, mapper, currentFieldName);
            } else {
                if (token == null) {
                    throw new MapperParsingException("object mapping for [" + mapper.name() + "] tried to parse field [" + currentFieldName + "] as object, but got EOF, has a concrete value been provided to it?");
                }
                if (token.isValue()) {
                    DocumentParser.parseValue(context, mapper, currentFieldName, token);
                }
            }
            token = context.parser().nextToken();
        }
    }

    private static void nested(DocumentParserContext context, NestedObjectMapper nested) {
        LuceneDocument nestedDoc = context.doc();
        LuceneDocument parentDoc = nestedDoc.getParent();
        Version indexVersion = context.indexSettings().getIndexVersionCreated();
        if (nested.isIncludeInParent()) {
            DocumentParser.addFields(indexVersion, nestedDoc, parentDoc);
        }
        if (nested.isIncludeInRoot()) {
            LuceneDocument rootDoc = context.rootDoc();
            if (!nested.isIncludeInParent() || parentDoc != rootDoc) {
                DocumentParser.addFields(indexVersion, nestedDoc, rootDoc);
            }
        }
    }

    private static void addFields(Version indexCreatedVersion, LuceneDocument nestedDoc, LuceneDocument rootDoc) {
        String nestedPathFieldName = NestedPathFieldMapper.name(indexCreatedVersion);
        for (IndexableField field : nestedDoc.getFields()) {
            if (field.name().equals(nestedPathFieldName)) continue;
            rootDoc.add(field);
        }
    }

    private static DocumentParserContext nestedContext(DocumentParserContext context, NestedObjectMapper mapper) {
        LuceneDocument nestedDoc = (context = context.createNestedContext(mapper.fullPath())).doc();
        LuceneDocument parentDoc = nestedDoc.getParent();
        IndexableField idField = parentDoc.getField("_id");
        if (idField == null) {
            throw new IllegalStateException("The root document of a nested document should have an _id field");
        }
        nestedDoc.add((IndexableField)new Field("_id", idField.binaryValue(), (IndexableFieldType)IdFieldMapper.Defaults.NESTED_FIELD_TYPE));
        Version version = context.indexSettings().getIndexVersionCreated();
        nestedDoc.add((IndexableField)NestedPathFieldMapper.field(version, mapper.nestedTypePath()));
        return context;
    }

    static void parseObjectOrField(DocumentParserContext context, Mapper mapper) throws IOException {
        if (mapper instanceof ObjectMapper) {
            DocumentParser.parseObjectOrNested(context, (ObjectMapper)mapper);
        } else if (mapper instanceof FieldMapper) {
            FieldMapper fieldMapper = (FieldMapper)mapper;
            fieldMapper.parse(context);
            List<String> copyToFields = fieldMapper.copyTo().copyToFields();
            if (!context.isWithinCopyTo() && !copyToFields.isEmpty()) {
                XContentParser.Token currentToken = context.parser().currentToken();
                if (!currentToken.isValue() && currentToken != XContentParser.Token.VALUE_NULL) {
                    throw new MapperParsingException("Cannot copy field [" + mapper.name() + "] to fields " + copyToFields + ". Copy-to currently only works for value-type fields, not objects.");
                }
                DocumentParser.parseCopyFields(context, copyToFields);
            }
        } else {
            if (mapper instanceof FieldAliasMapper) {
                String verb = context.isWithinCopyTo() ? "copy" : "write";
                throw new MapperParsingException("Cannot " + verb + " to a field alias [" + mapper.name() + "].");
            }
            throw new IllegalStateException("The provided mapper [" + mapper.name() + "] has an unrecognized type [" + mapper.getClass().getSimpleName() + "].");
        }
    }

    private static void parseObject(DocumentParserContext context, ObjectMapper mapper, String currentFieldName) throws IOException {
        assert (currentFieldName != null);
        Mapper objectMapper = DocumentParser.getMapper(context, mapper, currentFieldName);
        if (objectMapper != null) {
            context.path().add(currentFieldName);
            DocumentParser.parseObjectOrField(context, objectMapper);
            context.path().remove();
        } else {
            ObjectMapper.Dynamic dynamic = DocumentParser.dynamicOrDefault(mapper, context);
            if (dynamic == ObjectMapper.Dynamic.STRICT) {
                throw new StrictDynamicMappingException(mapper.fullPath(), currentFieldName);
            }
            if (dynamic == ObjectMapper.Dynamic.FALSE) {
                DocumentParser.failIfMatchesRoutingPath(context, mapper, currentFieldName);
                context.parser().skipChildren();
            } else {
                Mapper dynamicObjectMapper;
                if (dynamic == ObjectMapper.Dynamic.RUNTIME) {
                    dynamicObjectMapper = new NoOpObjectMapper(currentFieldName, context.path().pathAsText(currentFieldName));
                } else {
                    dynamicObjectMapper = dynamic.getDynamicFieldsBuilder().createDynamicObjectMapper(context, currentFieldName);
                    context.addDynamicMapper(dynamicObjectMapper);
                }
                if (dynamicObjectMapper instanceof NestedObjectMapper && context.isWithinCopyTo()) {
                    throw new MapperParsingException("It is forbidden to create dynamic nested objects ([" + dynamicObjectMapper.name() + "]) through `copy_to`");
                }
                context.path().add(currentFieldName);
                DocumentParser.parseObjectOrField(context, dynamicObjectMapper);
                context.path().remove();
            }
        }
    }

    private static void parseArray(DocumentParserContext context, ObjectMapper parentMapper, String lastFieldName) throws IOException {
        Mapper mapper = DocumentParser.getLeafMapper(context, parentMapper, lastFieldName);
        if (mapper != null) {
            if (DocumentParser.parsesArrayValue(mapper)) {
                DocumentParser.parseObjectOrField(context, mapper);
            } else {
                DocumentParser.parseNonDynamicArray(context, parentMapper, lastFieldName, lastFieldName);
            }
        } else {
            ObjectMapper.Dynamic dynamic = DocumentParser.dynamicOrDefault(parentMapper, context);
            if (dynamic == ObjectMapper.Dynamic.STRICT) {
                throw new StrictDynamicMappingException(parentMapper.fullPath(), lastFieldName);
            }
            if (dynamic == ObjectMapper.Dynamic.FALSE) {
                DocumentParser.parseNonDynamicArray(context, parentMapper, lastFieldName, lastFieldName);
            } else {
                Mapper objectMapperFromTemplate = dynamic.getDynamicFieldsBuilder().createObjectMapperFromTemplate(context, lastFieldName);
                if (objectMapperFromTemplate == null) {
                    DocumentParser.parseNonDynamicArray(context, parentMapper, lastFieldName, lastFieldName);
                } else if (DocumentParser.parsesArrayValue(objectMapperFromTemplate)) {
                    context.addDynamicMapper(objectMapperFromTemplate);
                    context.path().add(lastFieldName);
                    DocumentParser.parseObjectOrField(context, objectMapperFromTemplate);
                    context.path().remove();
                } else {
                    DocumentParser.parseNonDynamicArray(context, parentMapper, lastFieldName, lastFieldName);
                }
            }
        }
    }

    private static boolean parsesArrayValue(Mapper mapper) {
        return mapper instanceof FieldMapper && ((FieldMapper)mapper).parsesArrayValue();
    }

    private static void parseNonDynamicArray(DocumentParserContext context, ObjectMapper mapper, String lastFieldName, String arrayFieldName) throws IOException {
        XContentParser.Token token;
        XContentParser parser = context.parser();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token == XContentParser.Token.START_OBJECT) {
                DocumentParser.parseObject(context, mapper, lastFieldName);
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                DocumentParser.parseArray(context, mapper, lastFieldName);
                continue;
            }
            if (token == XContentParser.Token.VALUE_NULL) {
                DocumentParser.parseNullValue(context, mapper, lastFieldName);
                continue;
            }
            if (token == null) {
                throw new MapperParsingException("object mapping for [" + mapper.name() + "] with array for [" + arrayFieldName + "] tried to parse as array, but got EOF, is there a mismatch in types for the same field?");
            }
            assert (token.isValue());
            DocumentParser.parseValue(context, mapper, lastFieldName, token);
        }
    }

    private static void parseValue(DocumentParserContext context, ObjectMapper parentMapper, String currentFieldName, XContentParser.Token token) throws IOException {
        if (currentFieldName == null) {
            throw new MapperParsingException("object mapping [" + parentMapper.name() + "] trying to serialize a value with no field associated with it, current value [" + context.parser().textOrNull() + "]");
        }
        Mapper mapper = DocumentParser.getLeafMapper(context, parentMapper, currentFieldName);
        if (mapper != null) {
            DocumentParser.parseObjectOrField(context, mapper);
        } else {
            DocumentParser.parseDynamicValue(context, parentMapper, currentFieldName, token);
        }
    }

    private static void parseNullValue(DocumentParserContext context, ObjectMapper parentMapper, String lastFieldName) throws IOException {
        Mapper mapper = DocumentParser.getLeafMapper(context, parentMapper, lastFieldName);
        if (mapper != null) {
            DocumentParser.parseObjectOrField(context, mapper);
        } else if (parentMapper.dynamic() == ObjectMapper.Dynamic.STRICT) {
            throw new StrictDynamicMappingException(parentMapper.fullPath(), lastFieldName);
        }
    }

    private static void parseDynamicValue(DocumentParserContext context, ObjectMapper parentMapper, String currentFieldName, XContentParser.Token token) throws IOException {
        ObjectMapper.Dynamic dynamic = DocumentParser.dynamicOrDefault(parentMapper, context);
        if (dynamic == ObjectMapper.Dynamic.STRICT) {
            throw new StrictDynamicMappingException(parentMapper.fullPath(), currentFieldName);
        }
        if (dynamic == ObjectMapper.Dynamic.FALSE) {
            DocumentParser.failIfMatchesRoutingPath(context, parentMapper, currentFieldName);
            return;
        }
        dynamic.getDynamicFieldsBuilder().createDynamicFieldFromValue(context, token, currentFieldName);
    }

    private static void failIfMatchesRoutingPath(DocumentParserContext context, ObjectMapper parentMapper, String currentFieldName) {
        String path;
        if (context.indexSettings().getIndexMetadata().getRoutingPaths().isEmpty()) {
            return;
        }
        String string = path = parentMapper.fullPath().isEmpty() ? currentFieldName : parentMapper.fullPath() + "." + currentFieldName;
        if (Regex.simpleMatch(context.indexSettings().getIndexMetadata().getRoutingPaths(), path)) {
            throw new MapperParsingException("All fields matching [routing_path] must be mapped but [" + path + "] was declared as [dynamic: false]");
        }
    }

    private static void parseCopyFields(DocumentParserContext context, List<String> copyToFields) throws IOException {
        for (String field : copyToFields) {
            LuceneDocument targetDoc = null;
            for (LuceneDocument doc = context.doc(); doc != null; doc = doc.getParent()) {
                if (!field.startsWith(doc.getPrefix())) continue;
                targetDoc = doc;
                break;
            }
            assert (targetDoc != null);
            DocumentParserContext copyToContext = context.createCopyToContext(field, targetDoc);
            DocumentParser.innerParseObject(copyToContext, context.root());
        }
    }

    private static ObjectMapper.Dynamic dynamicOrDefault(ObjectMapper parentMapper, DocumentParserContext context) {
        int lastDotNdx;
        ObjectMapper.Dynamic dynamic = parentMapper.dynamic();
        while (dynamic == null && (lastDotNdx = parentMapper.name().lastIndexOf(46)) != -1) {
            String parentName = parentMapper.name().substring(0, lastDotNdx);
            parentMapper = context.mappingLookup().objectMappers().get(parentName);
            if (parentMapper == null && (parentMapper = context.getDynamicObjectMapper(parentName)) == null) break;
            dynamic = parentMapper.dynamic();
        }
        if (dynamic == null) {
            return context.root().dynamic() == null ? ObjectMapper.Dynamic.TRUE : context.root().dynamic();
        }
        return dynamic;
    }

    private static Mapper getMapper(DocumentParserContext context, ObjectMapper objectMapper, String fieldName) {
        String fieldPath = context.path().pathAsText(fieldName);
        MetadataFieldMapper mapper = context.getMetadataMapper(fieldPath);
        if (mapper != null) {
            return mapper;
        }
        return objectMapper.getMapper(fieldName);
    }

    private static Mapper getLeafMapper(DocumentParserContext context, ObjectMapper objectMapper, String fieldName) {
        Mapper mapper = DocumentParser.getMapper(context, objectMapper, fieldName);
        if (mapper != null) {
            return mapper;
        }
        String fieldPath = context.path().pathAsText(fieldName);
        if (context.isShadowed(fieldPath)) {
            return NO_OP_FIELDMAPPER;
        }
        return null;
    }

    private static class InternalDocumentParserContext
    extends DocumentParserContext {
        private final ContentPath path = new ContentPath(0);
        private final XContentParser parser;
        private final LuceneDocument document;
        private final List<LuceneDocument> documents = new ArrayList<LuceneDocument>();
        private final long maxAllowedNumNestedDocs;
        private long numNestedDocs;
        private boolean docsReversed = false;

        InternalDocumentParserContext(MappingLookup mappingLookup, IndexSettings indexSettings, IndexAnalyzers indexAnalyzers, Function<DateFormatter, MappingParserContext> parserContext, SourceToParse source, XContentParser parser) throws IOException {
            super(mappingLookup, indexSettings, indexAnalyzers, parserContext, source);
            this.parser = DotExpandingXContentParser.expandDots((XContentParser)parser);
            this.document = new LuceneDocument();
            this.documents.add(this.document);
            this.maxAllowedNumNestedDocs = this.indexSettings().getMappingNestedDocsLimit();
            this.numNestedDocs = 0L;
        }

        @Override
        public ContentPath path() {
            return this.path;
        }

        @Override
        public XContentParser parser() {
            return this.parser;
        }

        @Override
        public LuceneDocument rootDoc() {
            return this.documents.get(0);
        }

        @Override
        public LuceneDocument doc() {
            return this.document;
        }

        @Override
        protected void addDoc(LuceneDocument doc) {
            ++this.numNestedDocs;
            if (this.numNestedDocs > this.maxAllowedNumNestedDocs) {
                throw new MapperParsingException("The number of nested documents has exceeded the allowed limit of [" + this.maxAllowedNumNestedDocs + "]. This limit can be set by changing the [" + MapperService.INDEX_MAPPING_NESTED_DOCS_LIMIT_SETTING.getKey() + "] index level setting.");
            }
            this.documents.add(doc);
        }

        @Override
        public Iterable<LuceneDocument> nonRootDocuments() {
            if (this.docsReversed) {
                throw new IllegalStateException("documents are already reversed");
            }
            return this.documents.subList(1, this.documents.size());
        }

        private List<LuceneDocument> reorderParentAndGetDocs() {
            if (this.documents.size() > 1 && !this.docsReversed) {
                this.docsReversed = true;
                ArrayList<LuceneDocument> newDocs = new ArrayList<LuceneDocument>(this.documents.size());
                LinkedList<LuceneDocument> parents = new LinkedList<LuceneDocument>();
                for (LuceneDocument doc : this.documents) {
                    while (parents.peek() != doc.getParent()) {
                        newDocs.add((LuceneDocument)parents.poll());
                    }
                    parents.add(0, doc);
                }
                newDocs.addAll(parents);
                this.documents.clear();
                this.documents.addAll(newDocs);
            }
            return this.documents;
        }
    }

    private static class NoOpObjectMapper
    extends ObjectMapper {
        NoOpObjectMapper(String name, String fullPath) {
            super(name, fullPath, Explicit.IMPLICIT_TRUE, ObjectMapper.Dynamic.RUNTIME, Collections.emptyMap());
        }
    }
}

