/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.List;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.IndexFieldMapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.NestedLookup;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.RootObjectMapper;
import org.elasticsearch.index.mapper.RoutingFieldMapper;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.SourceToParse;

public class DocumentMapper {
    private final String type;
    private final CompressedXContent mappingSource;
    private final MappingLookup mappingLookup;
    private final DocumentParser documentParser;

    public static DocumentMapper createEmpty(MapperService mapperService) {
        RootObjectMapper root = new RootObjectMapper.Builder("_doc").build(MapperBuilderContext.ROOT);
        MetadataFieldMapper[] metadata = mapperService.getMetadataMappers().values().toArray(new MetadataFieldMapper[0]);
        Mapping mapping = new Mapping(root, metadata, null);
        return new DocumentMapper(mapperService.documentParser(), mapping, mapping.toCompressedXContent());
    }

    DocumentMapper(DocumentParser documentParser, Mapping mapping, CompressedXContent source) {
        this.documentParser = documentParser;
        this.type = mapping.getRoot().name();
        this.mappingLookup = MappingLookup.fromMapping(mapping);
        this.mappingSource = source;
        assert (mapping.toCompressedXContent().equals(source)) : "provided source [" + source + "] differs from mapping [" + mapping.toCompressedXContent() + "]";
    }

    public Mapping mapping() {
        return this.mappingLookup.getMapping();
    }

    public String type() {
        return this.type;
    }

    public CompressedXContent mappingSource() {
        return this.mappingSource;
    }

    public <T extends MetadataFieldMapper> T metadataMapper(Class<T> type) {
        return this.mapping().getMetadataMapperByClass(type);
    }

    public SourceFieldMapper sourceMapper() {
        return this.metadataMapper(SourceFieldMapper.class);
    }

    public IdFieldMapper idFieldMapper() {
        return this.metadataMapper(IdFieldMapper.class);
    }

    public RoutingFieldMapper routingFieldMapper() {
        return this.metadataMapper(RoutingFieldMapper.class);
    }

    public IndexFieldMapper IndexFieldMapper() {
        return this.metadataMapper(IndexFieldMapper.class);
    }

    public MappingLookup mappers() {
        return this.mappingLookup;
    }

    public ParsedDocument parse(SourceToParse source) throws MapperParsingException {
        return this.documentParser.parseDocument(source, this.mappingLookup);
    }

    public void validate(IndexSettings settings, boolean checkLimits) {
        this.mapping().validate(this.mappingLookup);
        if (settings.getIndexMetadata().isRoutingPartitionedIndex() && !this.routingFieldMapper().required()) {
            throw new IllegalArgumentException("mapping type [" + this.type() + "] must have routing required for partitioned index [" + settings.getIndex().getName() + "]");
        }
        if (settings.getIndexSortConfig().hasIndexSort() && this.mappers().nestedLookup() != NestedLookup.EMPTY) {
            throw new IllegalArgumentException("cannot have nested fields when index sort is activated");
        }
        List<String> routingPaths = settings.getIndexMetadata().getRoutingPaths();
        for (String path : routingPaths) {
            for (String match : this.mappingLookup.getMatchingFieldNames(path)) {
                this.mappingLookup.getFieldType(match).validateMatchedRoutingPath();
            }
            for (String objectName : this.mappingLookup.objectMappers().keySet()) {
                if (!Regex.simpleMatch(path, objectName)) continue;
                throw new IllegalArgumentException("All fields that match routing_path must be keywords with [time_series_dimension: true] and without the [script] parameter. [" + objectName + "] was [object].");
            }
        }
        if (checkLimits) {
            this.mappingLookup.checkLimits(settings);
        }
        settings.getMode().validateMapping(this.mappingLookup);
    }
}

