/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.get;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.StoredFieldVisitor;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.lucene.uid.VersionsAndSeqNoResolver;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.XContentFieldFilter;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fieldvisitor.CustomFieldsVisitor;
import org.elasticsearch.index.fieldvisitor.FieldsVisitor;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;

public final class ShardGetService
extends AbstractIndexShardComponent {
    private final MapperService mapperService;
    private final MeanMetric existsMetric = new MeanMetric();
    private final MeanMetric missingMetric = new MeanMetric();
    private final CounterMetric currentMetric = new CounterMetric();
    private final IndexShard indexShard;

    public ShardGetService(IndexSettings indexSettings, IndexShard indexShard, MapperService mapperService) {
        super(indexShard.shardId(), indexSettings);
        this.mapperService = mapperService;
        this.indexShard = indexShard;
    }

    public GetStats stats() {
        return new GetStats(this.existsMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.existsMetric.sum()), this.missingMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.missingMetric.sum()), this.currentMetric.count());
    }

    public GetResult get(String id, String[] gFields, boolean realtime, long version, VersionType versionType, FetchSourceContext fetchSourceContext) {
        return this.get(id, gFields, realtime, version, versionType, -2L, 0L, fetchSourceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GetResult get(String id, String[] gFields, boolean realtime, long version, VersionType versionType, long ifSeqNo, long ifPrimaryTerm, FetchSourceContext fetchSourceContext) {
        this.currentMetric.inc();
        try {
            long now = System.nanoTime();
            GetResult getResult = this.innerGet(id, gFields, realtime, version, versionType, ifSeqNo, ifPrimaryTerm, fetchSourceContext);
            if (getResult.isExists()) {
                this.existsMetric.inc(System.nanoTime() - now);
            } else {
                this.missingMetric.inc(System.nanoTime() - now);
            }
            GetResult getResult2 = getResult;
            return getResult2;
        }
        finally {
            this.currentMetric.dec();
        }
    }

    public GetResult getForUpdate(String id, long ifSeqNo, long ifPrimaryTerm) {
        return this.get(id, new String[]{"_routing"}, true, -3L, VersionType.INTERNAL, ifSeqNo, ifPrimaryTerm, FetchSourceContext.FETCH_SOURCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResult get(Engine.GetResult engineGetResult, String id, String[] fields, FetchSourceContext fetchSourceContext) {
        if (!engineGetResult.exists()) {
            return new GetResult(this.shardId.getIndexName(), id, -2L, 0L, -1L, false, null, null, null);
        }
        this.currentMetric.inc();
        try {
            long now = System.nanoTime();
            fetchSourceContext = this.normalizeFetchSourceContent(fetchSourceContext, fields);
            GetResult getResult = this.innerGetLoadFromStoredFields(id, fields, fetchSourceContext, engineGetResult);
            if (getResult.isExists()) {
                this.existsMetric.inc(System.nanoTime() - now);
            } else {
                this.missingMetric.inc(System.nanoTime() - now);
            }
            GetResult getResult2 = getResult;
            return getResult2;
        }
        finally {
            this.currentMetric.dec();
        }
    }

    private FetchSourceContext normalizeFetchSourceContent(@Nullable FetchSourceContext context, @Nullable String[] gFields) {
        if (context != null) {
            return context;
        }
        if (gFields == null) {
            return FetchSourceContext.FETCH_SOURCE;
        }
        for (String field : gFields) {
            if (!"_source".equals(field)) continue;
            return FetchSourceContext.FETCH_SOURCE;
        }
        return FetchSourceContext.DO_NOT_FETCH_SOURCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GetResult innerGet(String id, String[] gFields, boolean realtime, long version, VersionType versionType, long ifSeqNo, long ifPrimaryTerm, FetchSourceContext fetchSourceContext) {
        fetchSourceContext = this.normalizeFetchSourceContent(fetchSourceContext, gFields);
        Engine.GetResult get = this.indexShard.get(new Engine.Get(realtime, realtime, id).version(version).versionType(versionType).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm));
        if (!get.exists()) {
            get.close();
        }
        if (get == null || !get.exists()) {
            return new GetResult(this.shardId.getIndexName(), id, -2L, 0L, -1L, false, null, null, null);
        }
        try {
            GetResult getResult = this.innerGetLoadFromStoredFields(id, gFields, fetchSourceContext, get);
            return getResult;
        }
        finally {
            get.close();
        }
    }

    private GetResult innerGetLoadFromStoredFields(String id, String[] storedFields, FetchSourceContext fetchSourceContext, Engine.GetResult get) {
        assert (get.exists()) : "method should only be called if document could be retrieved";
        MappingLookup mappingLookup = this.mapperService.mappingLookup();
        if (storedFields != null) {
            for (String field : storedFields) {
                Mapper fieldMapper = mappingLookup.getMapper(field);
                if (fieldMapper != null || mappingLookup.objectMappers().get(field) == null) continue;
                throw new IllegalArgumentException("field [" + field + "] isn't a leaf field");
            }
        }
        HashMap<String, DocumentField> documentFields = null;
        HashMap<String, DocumentField> metadataFields = null;
        BytesReference source = null;
        VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion = get.docIdAndVersion();
        FieldsVisitor fieldVisitor = ShardGetService.buildFieldsVisitors(storedFields, fetchSourceContext);
        if (fieldVisitor != null) {
            try {
                docIdAndVersion.reader.document(docIdAndVersion.docId, (StoredFieldVisitor)fieldVisitor);
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to get id [" + id + "]", (Throwable)e, new Object[0]);
            }
            source = fieldVisitor.source();
            if (!fieldVisitor.fields().isEmpty()) {
                fieldVisitor.postProcess(this.mapperService::fieldType);
                documentFields = new HashMap<String, DocumentField>();
                metadataFields = new HashMap<String, DocumentField>();
                for (Map.Entry<String, List<Object>> entry : fieldVisitor.fields().entrySet()) {
                    if (this.mapperService.isMetadataField(entry.getKey())) {
                        metadataFields.put(entry.getKey(), new DocumentField(entry.getKey(), entry.getValue()));
                        continue;
                    }
                    documentFields.put(entry.getKey(), new DocumentField(entry.getKey(), entry.getValue()));
                }
            }
        }
        if (source != null) {
            if (!fetchSourceContext.fetchSource()) {
                source = null;
            } else if (fetchSourceContext.includes().length > 0 || fetchSourceContext.excludes().length > 0) {
                try {
                    source = XContentFieldFilter.newFieldFilter(fetchSourceContext.includes(), fetchSourceContext.excludes()).apply(source, null);
                }
                catch (IOException e) {
                    throw new ElasticsearchException("Failed to get id [" + id + "] with includes/excludes set", (Throwable)e, new Object[0]);
                }
            }
        }
        return new GetResult(this.shardId.getIndexName(), id, get.docIdAndVersion().seqNo, get.docIdAndVersion().primaryTerm, get.version(), get.exists(), source, documentFields, metadataFields);
    }

    private static FieldsVisitor buildFieldsVisitors(String[] fields, FetchSourceContext fetchSourceContext) {
        if (fields == null || fields.length == 0) {
            return fetchSourceContext.fetchSource() ? new FieldsVisitor(true) : null;
        }
        return new CustomFieldsVisitor(Sets.newHashSet(fields), fetchSourceContext.fetchSource());
    }
}

