/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.LongValuesComparatorSource;
import org.elasticsearch.index.fielddata.plain.LeafLongFieldData;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.field.DocValuesField;
import org.elasticsearch.script.field.ToScriptField;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class SortedNumericIndexFieldData
extends IndexNumericFieldData {
    private final IndexNumericFieldData.NumericType numericType;
    protected final String fieldName;
    protected final ValuesSourceType valuesSourceType;
    protected final ToScriptField<SortedNumericDocValues> toScriptField;

    public SortedNumericIndexFieldData(String fieldName, IndexNumericFieldData.NumericType numericType, ToScriptField<SortedNumericDocValues> toScriptField) {
        this.fieldName = fieldName;
        this.numericType = Objects.requireNonNull(numericType);
        assert (!this.numericType.isFloatingPoint());
        this.valuesSourceType = numericType.getValuesSourceType();
        this.toScriptField = toScriptField;
    }

    @Override
    public final String getFieldName() {
        return this.fieldName;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    @Override
    protected boolean sortRequiresCustomComparator() {
        return false;
    }

    @Override
    protected IndexFieldData.XFieldComparatorSource dateComparatorSource(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        if (this.numericType == IndexNumericFieldData.NumericType.DATE_NANOSECONDS) {
            return new LongValuesComparatorSource(this, missingValue, sortMode, nested, dvs -> SortedNumericIndexFieldData.convertNumeric(dvs, DateUtils::toMilliSeconds), IndexNumericFieldData.NumericType.DATE);
        }
        return new LongValuesComparatorSource(this, missingValue, sortMode, nested, IndexNumericFieldData.NumericType.DATE);
    }

    @Override
    protected IndexFieldData.XFieldComparatorSource dateNanosComparatorSource(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        if (this.numericType == IndexNumericFieldData.NumericType.DATE) {
            return new LongValuesComparatorSource(this, missingValue, sortMode, nested, dvs -> SortedNumericIndexFieldData.convertNumeric(dvs, DateUtils::toNanoSeconds), IndexNumericFieldData.NumericType.DATE_NANOSECONDS);
        }
        return new LongValuesComparatorSource(this, missingValue, sortMode, nested, IndexNumericFieldData.NumericType.DATE_NANOSECONDS);
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return this.numericType;
    }

    @Override
    public LeafNumericFieldData loadDirect(LeafReaderContext context) throws Exception {
        return this.load(context);
    }

    @Override
    public LeafNumericFieldData load(LeafReaderContext context) {
        LeafReader reader = context.reader();
        String field = this.fieldName;
        if (this.numericType == IndexNumericFieldData.NumericType.DATE_NANOSECONDS) {
            return new NanoSecondFieldData(reader, field, this.toScriptField);
        }
        return new SortedNumericLongFieldData(reader, field, this.toScriptField);
    }

    public static final class NanoSecondFieldData
    extends LeafLongFieldData {
        private final LeafReader reader;
        private final String fieldName;
        protected final ToScriptField<SortedNumericDocValues> toScriptField;

        NanoSecondFieldData(LeafReader reader, String fieldName, ToScriptField<SortedNumericDocValues> toScriptField) {
            super(0L);
            this.reader = reader;
            this.fieldName = fieldName;
            this.toScriptField = toScriptField;
        }

        @Override
        public SortedNumericDocValues getLongValues() {
            return SortedNumericIndexFieldData.convertNumeric(this.getLongValuesAsNanos(), DateUtils::toMilliSeconds);
        }

        public SortedNumericDocValues getLongValuesAsNanos() {
            try {
                return DocValues.getSortedNumeric((LeafReader)this.reader, (String)this.fieldName);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public DocValuesField<?> getScriptField(String name) {
            return this.toScriptField.getScriptField(this.getLongValuesAsNanos(), name);
        }

        @Override
        public FormattedDocValues getFormattedValues(DocValueFormat format) {
            final DocValueFormat nanosFormat = DocValueFormat.withNanosecondResolution(format);
            final SortedNumericDocValues values = this.getLongValuesAsNanos();
            return new FormattedDocValues(){

                @Override
                public boolean advanceExact(int docId) throws IOException {
                    return values.advanceExact(docId);
                }

                @Override
                public int docValueCount() throws IOException {
                    return values.docValueCount();
                }

                @Override
                public Object nextValue() throws IOException {
                    return nanosFormat.format(values.nextValue());
                }
            };
        }
    }

    static final class SortedNumericLongFieldData
    extends LeafLongFieldData {
        final LeafReader reader;
        final String field;
        protected final ToScriptField<SortedNumericDocValues> toScriptField;

        SortedNumericLongFieldData(LeafReader reader, String field, ToScriptField<SortedNumericDocValues> toScriptField) {
            super(0L);
            this.reader = reader;
            this.field = field;
            this.toScriptField = toScriptField;
        }

        @Override
        public SortedNumericDocValues getLongValues() {
            try {
                return DocValues.getSortedNumeric((LeafReader)this.reader, (String)this.field);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }

        @Override
        public DocValuesField<?> getScriptField(String name) {
            return this.toScriptField.getScriptField(this.getLongValues(), name);
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final IndexNumericFieldData.NumericType numericType;
        protected final ToScriptField<SortedNumericDocValues> toScriptField;

        public Builder(String name, IndexNumericFieldData.NumericType numericType, ToScriptField<SortedNumericDocValues> toScriptField) {
            this.name = name;
            this.numericType = numericType;
            this.toScriptField = toScriptField;
        }

        public SortedNumericIndexFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new SortedNumericIndexFieldData(this.name, this.numericType, this.toScriptField);
        }
    }
}

