/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.LeafGeoPointFieldData;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.script.field.DocValuesField;
import org.elasticsearch.script.field.ToScriptField;

public abstract class AbstractLeafGeoPointFieldData
implements LeafGeoPointFieldData {
    protected final ToScriptField<MultiGeoPointValues> toScriptField;

    public AbstractLeafGeoPointFieldData(ToScriptField<MultiGeoPointValues> toScriptField) {
        this.toScriptField = toScriptField;
    }

    @Override
    public final SortedBinaryDocValues getBytesValues() {
        return FieldData.toString(this.getGeoPointValues());
    }

    @Override
    public DocValuesField<?> getScriptField(String name) {
        return this.toScriptField.getScriptField(this.getGeoPointValues(), name);
    }

    public static LeafGeoPointFieldData empty(int maxDoc, ToScriptField<MultiGeoPointValues> toScriptField) {
        return new AbstractLeafGeoPointFieldData((ToScriptField)toScriptField){

            public long ramBytesUsed() {
                return 0L;
            }

            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }

            public void close() {
            }

            @Override
            public MultiGeoPointValues getGeoPointValues() {
                return FieldData.emptyMultiGeoPoints();
            }
        };
    }
}

