/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fielddata.BinaryScriptFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.StringScriptDocValues;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.StringFieldScript;
import org.elasticsearch.script.field.DocValuesField;
import org.elasticsearch.script.field.ToScriptField;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class StringScriptFieldData
extends BinaryScriptFieldData {
    private final StringFieldScript.LeafFactory leafFactory;
    protected final ToScriptField<SortedBinaryDocValues> toScriptField;

    private StringScriptFieldData(String fieldName, StringFieldScript.LeafFactory leafFactory, ToScriptField<SortedBinaryDocValues> toScriptField) {
        super(fieldName);
        this.leafFactory = leafFactory;
        this.toScriptField = toScriptField;
    }

    @Override
    public BinaryScriptFieldData.BinaryScriptLeafFieldData loadDirect(LeafReaderContext context) throws Exception {
        final StringFieldScript script = this.leafFactory.newInstance(context);
        return new BinaryScriptFieldData.BinaryScriptLeafFieldData(){

            @Override
            public DocValuesField<?> getScriptField(String name) {
                return StringScriptFieldData.this.toScriptField.getScriptField(this.getBytesValues(), name);
            }

            @Override
            public SortedBinaryDocValues getBytesValues() {
                return new StringScriptDocValues(script);
            }
        };
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return CoreValuesSourceType.KEYWORD;
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final StringFieldScript.LeafFactory leafFactory;
        protected final ToScriptField<SortedBinaryDocValues> toScriptField;

        public Builder(String name, StringFieldScript.LeafFactory leafFactory, ToScriptField<SortedBinaryDocValues> toScriptField) {
            this.name = name;
            this.leafFactory = leafFactory;
            this.toScriptField = toScriptField;
        }

        public StringScriptFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new StringScriptFieldData(this.name, this.leafFactory, this.toScriptField);
        }
    }
}

