/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fielddata.BinaryScriptFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IpScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.IpFieldScript;
import org.elasticsearch.script.field.DocValuesField;
import org.elasticsearch.script.field.ToScriptField;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class IpScriptFieldData
extends BinaryScriptFieldData {
    private final IpFieldScript.LeafFactory leafFactory;
    private final ToScriptField<SortedBinaryDocValues> toScriptField;

    private IpScriptFieldData(String fieldName, IpFieldScript.LeafFactory leafFactory, ToScriptField<SortedBinaryDocValues> toScriptField) {
        super(fieldName);
        this.leafFactory = leafFactory;
        this.toScriptField = toScriptField;
    }

    @Override
    public BinaryScriptFieldData.BinaryScriptLeafFieldData loadDirect(LeafReaderContext context) throws Exception {
        final IpFieldScript script = this.leafFactory.newInstance(context);
        return new BinaryScriptFieldData.BinaryScriptLeafFieldData(){

            @Override
            public DocValuesField<?> getScriptField(String name) {
                return IpScriptFieldData.this.toScriptField.getScriptField(this.getBytesValues(), name);
            }

            @Override
            public SortedBinaryDocValues getBytesValues() {
                return new IpScriptDocValues(script);
            }
        };
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return CoreValuesSourceType.IP;
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final IpFieldScript.LeafFactory leafFactory;
        private final ToScriptField<SortedBinaryDocValues> toScriptField;

        public Builder(String name, IpFieldScript.LeafFactory leafFactory, ToScriptField<SortedBinaryDocValues> toScriptField) {
            this.name = name;
            this.leafFactory = leafFactory;
            this.toScriptField = toScriptField;
        }

        public IpScriptFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new IpScriptFieldData(this.name, this.leafFactory, this.toScriptField);
        }
    }
}

