/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.SortField;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.fielddata.GeoPointScriptDocValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.LeafGeoPointFieldData;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.plain.AbstractLeafGeoPointFieldData;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.GeoPointFieldScript;
import org.elasticsearch.script.field.ToScriptField;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;

public class GeoPointScriptFieldData
implements IndexGeoPointFieldData {
    private final GeoPointFieldScript.LeafFactory leafFactory;
    private final String name;
    private final ToScriptField<MultiGeoPointValues> toScriptField;

    private GeoPointScriptFieldData(String fieldName, GeoPointFieldScript.LeafFactory leafFactory, ToScriptField<MultiGeoPointValues> toScriptField) {
        this.name = fieldName;
        this.leafFactory = leafFactory;
        this.toScriptField = toScriptField;
    }

    @Override
    public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        throw new IllegalArgumentException("can't sort on geo_point field without using specific sorting feature, like geo_distance");
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new IllegalArgumentException("can't sort on geo_point field without using specific sorting feature, like geo_distance");
    }

    @Override
    public String getFieldName() {
        return this.name;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return CoreValuesSourceType.GEOPOINT;
    }

    @Override
    public LeafGeoPointFieldData load(LeafReaderContext context) {
        final GeoPointFieldScript script = this.leafFactory.newInstance(context);
        return new AbstractLeafGeoPointFieldData(this.toScriptField){

            @Override
            public MultiGeoPointValues getGeoPointValues() {
                return new GeoPointScriptDocValues(script);
            }

            public long ramBytesUsed() {
                return 0L;
            }

            public void close() {
            }
        };
    }

    @Override
    public LeafGeoPointFieldData loadDirect(LeafReaderContext context) {
        return this.load(context);
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final GeoPointFieldScript.LeafFactory leafFactory;
        private final ToScriptField<MultiGeoPointValues> toScriptField;

        public Builder(String name, GeoPointFieldScript.LeafFactory leafFactory, ToScriptField<MultiGeoPointValues> toScriptField) {
            this.name = name;
            this.leafFactory = leafFactory;
            this.toScriptField = toScriptField;
        }

        public GeoPointScriptFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new GeoPointScriptFieldData(this.name, this.leafFactory, this.toScriptField);
        }
    }
}

