/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.index.fielddata.DoubleScriptDocValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.plain.LeafDoubleFieldData;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.DoubleFieldScript;
import org.elasticsearch.script.field.DocValuesField;
import org.elasticsearch.script.field.ToScriptField;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public final class DoubleScriptFieldData
extends IndexNumericFieldData {
    private final String fieldName;
    DoubleFieldScript.LeafFactory leafFactory;
    protected final ToScriptField<SortedNumericDoubleValues> toScriptField;

    private DoubleScriptFieldData(String fieldName, DoubleFieldScript.LeafFactory leafFactory, ToScriptField<SortedNumericDoubleValues> toScriptField) {
        this.fieldName = fieldName;
        this.leafFactory = leafFactory;
        this.toScriptField = toScriptField;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return CoreValuesSourceType.NUMERIC;
    }

    @Override
    public DoubleScriptLeafFieldData load(LeafReaderContext context) {
        try {
            return this.loadDirect(context);
        }
        catch (Exception e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
    }

    @Override
    public DoubleScriptLeafFieldData loadDirect(LeafReaderContext context) {
        return new DoubleScriptLeafFieldData(new DoubleScriptDocValues(this.leafFactory.newInstance(context)), this.toScriptField);
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return IndexNumericFieldData.NumericType.DOUBLE;
    }

    @Override
    protected boolean sortRequiresCustomComparator() {
        return true;
    }

    public static class DoubleScriptLeafFieldData
    extends LeafDoubleFieldData {
        private final DoubleScriptDocValues doubleScriptDocValues;
        protected final ToScriptField<SortedNumericDoubleValues> toScriptField;

        DoubleScriptLeafFieldData(DoubleScriptDocValues doubleScriptDocValues, ToScriptField<SortedNumericDoubleValues> toScriptField) {
            super(0L);
            this.doubleScriptDocValues = doubleScriptDocValues;
            this.toScriptField = toScriptField;
        }

        @Override
        public SortedNumericDoubleValues getDoubleValues() {
            return this.doubleScriptDocValues;
        }

        @Override
        public void close() {
        }

        @Override
        public DocValuesField<?> getScriptField(String name) {
            return this.toScriptField.getScriptField(this.getDoubleValues(), name);
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final String name;
        private final DoubleFieldScript.LeafFactory leafFactory;
        protected final ToScriptField<SortedNumericDoubleValues> toScriptField;

        public Builder(String name, DoubleFieldScript.LeafFactory leafFactory, ToScriptField<SortedNumericDoubleValues> toScriptField) {
            this.name = name;
            this.leafFactory = leafFactory;
            this.toScriptField = toScriptField;
        }

        public DoubleScriptFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new DoubleScriptFieldData(this.name, this.leafFactory, this.toScriptField);
        }
    }
}

