/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.time.Instant;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.index.IndexSettings;

public class TimestampBounds {
    private final long startTime;
    private volatile long endTime;

    TimestampBounds(IndexScopedSettings scopedSettings) {
        this.startTime = scopedSettings.get(IndexSettings.TIME_SERIES_START_TIME).toEpochMilli();
        this.endTime = scopedSettings.get(IndexSettings.TIME_SERIES_END_TIME).toEpochMilli();
        scopedSettings.addSettingsUpdateConsumer(IndexSettings.TIME_SERIES_END_TIME, this::updateEndTime);
    }

    public long startTime() {
        return this.startTime;
    }

    public long endTime() {
        return this.endTime;
    }

    private void updateEndTime(Instant endTimeInstant) {
        long newEndTime = endTimeInstant.toEpochMilli();
        if (this.endTime > newEndTime) {
            throw new IllegalArgumentException("index.time_series.end_time must be larger than current value [" + this.endTime + "] but was [" + newEndTime + "]");
        }
        this.endTime = newEndTime;
    }

    public String toString() {
        return this.startTime + "-" + this.endTime;
    }
}

