/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MetadataCreateDataStreamService;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexSortConfig;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.RoutingFieldMapper;
import org.elasticsearch.index.mapper.TimeSeriesIdFieldMapper;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum IndexMode {
    STANDARD("standard"){

        @Override
        void validateWithOtherSettings(Map<Setting<?>, Object> settings) {
            this.settingRequiresTimeSeries(settings, IndexMetadata.INDEX_ROUTING_PATH);
            this.settingRequiresTimeSeries(settings, IndexSettings.TIME_SERIES_START_TIME);
            this.settingRequiresTimeSeries(settings, IndexSettings.TIME_SERIES_END_TIME);
        }

        private void settingRequiresTimeSeries(Map<Setting<?>, Object> settings, Setting<?> setting) {
            if (!Objects.equals(setting.getDefault(Settings.EMPTY), settings.get(setting))) {
                throw new IllegalArgumentException("[" + setting.getKey() + "] requires [" + IndexSettings.MODE.getKey() + "=time_series]");
            }
        }

        @Override
        public void validateMapping(MappingLookup lookup) {
        }

        @Override
        public void validateAlias(@Nullable String indexRouting, @Nullable String searchRouting) {
        }

        @Override
        public void validateTimestampFieldMapping(boolean isDataStream, MappingLookup mappingLookup) throws IOException {
            if (isDataStream) {
                MetadataCreateDataStreamService.validateTimestampFieldMapping(mappingLookup);
            }
        }

        @Override
        public CompressedXContent getDefaultMapping() {
            return null;
        }

        @Override
        public MetadataFieldMapper buildTimeSeriesIdFieldMapper() {
            return null;
        }
    }
    ,
    TIME_SERIES("time_series"){

        @Override
        void validateWithOtherSettings(Map<Setting<?>, Object> settings) {
            if (settings.get(IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING) != Integer.valueOf(1)) {
                throw new IllegalArgumentException(this.error(IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING));
            }
            for (Setting<?> unsupported : TIME_SERIES_UNSUPPORTED) {
                if (Objects.equals(unsupported.getDefault(Settings.EMPTY), settings.get(unsupported))) continue;
                throw new IllegalArgumentException(this.error(unsupported));
            }
            this.settingRequiresTimeSeries(settings, IndexMetadata.INDEX_ROUTING_PATH);
            this.settingRequiresTimeSeries(settings, IndexSettings.TIME_SERIES_START_TIME);
            this.settingRequiresTimeSeries(settings, IndexSettings.TIME_SERIES_END_TIME);
        }

        private void settingRequiresTimeSeries(Map<Setting<?>, Object> settings, Setting<?> setting) {
            if (Objects.equals(setting.getDefault(Settings.EMPTY), settings.get(setting))) {
                throw new IllegalArgumentException("[" + IndexSettings.MODE.getKey() + "=time_series] requires [" + setting.getKey() + "]");
            }
        }

        private String error(Setting<?> unsupported) {
            return this.tsdbMode() + " is incompatible with [" + unsupported.getKey() + "]";
        }

        @Override
        public void validateMapping(MappingLookup lookup) {
            if (((RoutingFieldMapper)lookup.getMapper("_routing")).required()) {
                throw new IllegalArgumentException(this.routingRequiredBad());
            }
        }

        @Override
        public void validateAlias(@Nullable String indexRouting, @Nullable String searchRouting) {
            if (indexRouting != null || searchRouting != null) {
                throw new IllegalArgumentException(this.routingRequiredBad());
            }
        }

        @Override
        public void validateTimestampFieldMapping(boolean isDataStream, MappingLookup mappingLookup) throws IOException {
            MetadataCreateDataStreamService.validateTimestampFieldMapping(mappingLookup);
        }

        @Override
        public CompressedXContent getDefaultMapping() {
            return DEFAULT_TIME_SERIES_TIMESTAMP_MAPPING;
        }

        private String routingRequiredBad() {
            return "routing is forbidden on CRUD operations that target indices in " + this.tsdbMode();
        }

        private String tsdbMode() {
            return "[" + IndexSettings.MODE.getKey() + "=time_series]";
        }

        @Override
        public MetadataFieldMapper buildTimeSeriesIdFieldMapper() {
            return TimeSeriesIdFieldMapper.INSTANCE;
        }
    };

    public static final CompressedXContent DEFAULT_TIME_SERIES_TIMESTAMP_MAPPING;
    private static final List<Setting<?>> TIME_SERIES_UNSUPPORTED;
    static final List<Setting<?>> VALIDATE_WITH_SETTINGS;
    private final String name;

    private IndexMode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    abstract void validateWithOtherSettings(Map<Setting<?>, Object> var1);

    public abstract void validateMapping(MappingLookup var1);

    public abstract void validateAlias(@Nullable String var1, @Nullable String var2);

    public abstract void validateTimestampFieldMapping(boolean var1, MappingLookup var2) throws IOException;

    @Nullable
    public abstract CompressedXContent getDefaultMapping();

    public abstract MetadataFieldMapper buildTimeSeriesIdFieldMapper();

    public static IndexMode fromString(String value) {
        return switch (value) {
            case "standard" -> STANDARD;
            case "time_series" -> TIME_SERIES;
            default -> throw new IllegalArgumentException("[" + value + "] is an invalid index mode, valid modes are: [" + Arrays.stream(IndexMode.values()).map(IndexMode::toString).collect(Collectors.joining()) + "]");
        };
    }

    public String toString() {
        return this.getName();
    }

    static {
        try {
            DEFAULT_TIME_SERIES_TIMESTAMP_MAPPING = new CompressedXContent((builder, params) -> builder.startObject("_doc").startObject("_data_stream_timestamp").field("enabled", true).endObject().startObject("properties").startObject("@timestamp").field("type", "date").endObject().endObject().endObject());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        TIME_SERIES_UNSUPPORTED = List.of(IndexSortConfig.INDEX_SORT_FIELD_SETTING, IndexSortConfig.INDEX_SORT_ORDER_SETTING, IndexSortConfig.INDEX_SORT_MODE_SETTING, IndexSortConfig.INDEX_SORT_MISSING_SETTING);
        VALIDATE_WITH_SETTINGS = List.copyOf(Stream.concat(Stream.of(IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING, IndexMetadata.INDEX_ROUTING_PATH, IndexSettings.TIME_SERIES_START_TIME, IndexSettings.TIME_SERIES_END_TIME), TIME_SERIES_UNSUPPORTED.stream()).collect(Collectors.toSet()));
    }
}

