/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.elasticsearch.health.HealthIndicatorResult;
import org.elasticsearch.health.HealthStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record HealthComponentResult(String name, HealthStatus status, List<HealthIndicatorResult> indicators) implements ToXContentObject
{
    public static Collection<HealthComponentResult> createComponentsFromIndicators(Collection<HealthIndicatorResult> indicators) {
        return indicators.stream().collect(Collectors.groupingBy(HealthIndicatorResult::component, TreeMap::new, Collectors.collectingAndThen(Collectors.toList(), HealthComponentResult::createComponentFromIndicators))).values();
    }

    private static HealthComponentResult createComponentFromIndicators(List<HealthIndicatorResult> indicators) {
        assert (indicators.size() > 0) : "Component should not be non empty";
        assert (indicators.stream().map(HealthIndicatorResult::component).distinct().count() == 1L) : "Should not mix indicators from different components";
        return new HealthComponentResult(indicators.get(0).component(), HealthStatus.merge(indicators.stream().map(HealthIndicatorResult::status)), indicators);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("status", (Enum)this.status);
        builder.startObject("indicators");
        for (HealthIndicatorResult indicator : this.indicators) {
            builder.field(indicator.name(), (ToXContent)indicator, params);
        }
        builder.endObject();
        return builder.endObject();
    }
}

