/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.CancellableThreads;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.discovery.ConfiguredHostsResolver;
import org.elasticsearch.discovery.SeedHostsProvider;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class SeedHostsResolver
extends AbstractLifecycleComponent
implements ConfiguredHostsResolver,
SeedHostsProvider.HostsResolver {
    public static final Setting<Integer> DISCOVERY_SEED_RESOLVER_MAX_CONCURRENT_RESOLVERS_SETTING = Setting.intSetting("discovery.seed_resolver.max_concurrent_resolvers", 10, 0, Setting.Property.NodeScope);
    public static final Setting<TimeValue> DISCOVERY_SEED_RESOLVER_TIMEOUT_SETTING = Setting.positiveTimeSetting("discovery.seed_resolver.timeout", TimeValue.timeValueSeconds((long)5L), Setting.Property.NodeScope);
    private static final Logger logger = LogManager.getLogger(SeedHostsResolver.class);
    private final Settings settings;
    private final AtomicBoolean resolveInProgress = new AtomicBoolean();
    private final TransportService transportService;
    private final SeedHostsProvider hostsProvider;
    private final SetOnce<ExecutorService> executorService = new SetOnce();
    private final TimeValue resolveTimeout;
    private final String nodeName;
    private final int concurrentConnects;
    private final CancellableThreads cancellableThreads = new CancellableThreads();

    public SeedHostsResolver(String nodeName, Settings settings, TransportService transportService, SeedHostsProvider seedProvider) {
        this.settings = settings;
        this.nodeName = nodeName;
        this.transportService = transportService;
        this.hostsProvider = seedProvider;
        this.resolveTimeout = SeedHostsResolver.getResolveTimeout(settings);
        this.concurrentConnects = SeedHostsResolver.getMaxConcurrentResolvers(settings);
    }

    public static int getMaxConcurrentResolvers(Settings settings) {
        return DISCOVERY_SEED_RESOLVER_MAX_CONCURRENT_RESOLVERS_SETTING.get(settings);
    }

    public static TimeValue getResolveTimeout(Settings settings) {
        return DISCOVERY_SEED_RESOLVER_TIMEOUT_SETTING.get(settings);
    }

    @Override
    public List<TransportAddress> resolveHosts(List<String> hosts) {
        Objects.requireNonNull(hosts);
        if (this.resolveTimeout.nanos() < 0L) {
            throw new IllegalArgumentException("resolve timeout must be non-negative but was [" + this.resolveTimeout + "]");
        }
        List callables = hosts.stream().map(hn -> () -> this.transportService.addressesFromString((String)hn)).collect(Collectors.toList());
        SetOnce futures = new SetOnce();
        long startTimeNanos = this.transportService.getThreadPool().relativeTimeInNanos();
        try {
            this.cancellableThreads.execute(() -> futures.set(((ExecutorService)this.executorService.get()).invokeAll(callables, this.resolveTimeout.nanos(), TimeUnit.NANOSECONDS)));
        }
        catch (CancellableThreads.ExecutionCancelledException e) {
            return Collections.emptyList();
        }
        TimeValue duration = TimeValue.timeValueNanos((long)(this.transportService.getThreadPool().relativeTimeInNanos() - startTimeNanos));
        ArrayList<TransportAddress> transportAddresses = new ArrayList<TransportAddress>();
        HashSet<TransportAddress> localAddresses = new HashSet<TransportAddress>();
        localAddresses.add(this.transportService.boundAddress().publishAddress());
        localAddresses.addAll(Arrays.asList(this.transportService.boundAddress().boundAddresses()));
        Iterator<String> it = hosts.iterator();
        for (Future future : (List)futures.get()) {
            assert (future.isDone());
            assert (it.hasNext());
            String hostname = it.next();
            if (!future.isCancelled()) {
                try {
                    TransportAddress[] addresses = (TransportAddress[])future.get();
                    logger.trace("resolved host [{}] to {}", (Object)hostname, (Object)addresses);
                    for (TransportAddress address : addresses) {
                        if (localAddresses.contains(address)) continue;
                        transportAddresses.add(address);
                    }
                    continue;
                }
                catch (ExecutionException e) {
                    assert (e.getCause() != null);
                    String message = "failed to resolve host [" + hostname + "]";
                    logger.warn(message, e.getCause());
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
            }
            logger.warn("timed out after [{}/{}ms] ([{}]=[{}]) resolving host [{}]", (Object)duration, (Object)duration.getMillis(), (Object)DISCOVERY_SEED_RESOLVER_TIMEOUT_SETTING.getKey(), (Object)this.resolveTimeout, (Object)hostname);
        }
        return Collections.unmodifiableList(transportAddresses);
    }

    @Override
    protected void doStart() {
        logger.debug("using max_concurrent_resolvers [{}], resolver timeout [{}]", (Object)this.concurrentConnects, (Object)this.resolveTimeout);
        ThreadFactory threadFactory = EsExecutors.daemonThreadFactory(this.settings, "[unicast_configured_hosts_resolver]");
        this.executorService.set((Object)EsExecutors.newScaling(this.nodeName + "/unicast_configured_hosts_resolver", 0, this.concurrentConnects, 60L, TimeUnit.SECONDS, false, threadFactory, this.transportService.getThreadPool().getThreadContext()));
    }

    @Override
    protected void doStop() {
        this.cancellableThreads.cancel("stopping SeedHostsResolver");
        ThreadPool.terminate((ExecutorService)this.executorService.get(), 10L, TimeUnit.SECONDS);
    }

    @Override
    protected void doClose() {
    }

    @Override
    public void resolveConfiguredHosts(final Consumer<List<TransportAddress>> consumer) {
        if (!this.lifecycle.started()) {
            logger.debug("resolveConfiguredHosts: lifecycle is {}, not proceeding", (Object)this.lifecycle);
            return;
        }
        if (this.resolveInProgress.compareAndSet(false, true)) {
            this.transportService.getThreadPool().generic().execute(new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    logger.debug("failure when resolving unicast hosts list", (Throwable)e);
                }

                @Override
                protected void doRun() {
                    if (!SeedHostsResolver.this.lifecycle.started()) {
                        logger.debug("resolveConfiguredHosts.doRun: lifecycle is {}, not proceeding", (Object)SeedHostsResolver.this.lifecycle);
                        return;
                    }
                    List<TransportAddress> providedAddresses = SeedHostsResolver.this.hostsProvider.getSeedAddresses(SeedHostsResolver.this);
                    consumer.accept(providedAddresses);
                }

                @Override
                public void onAfter() {
                    SeedHostsResolver.this.resolveInProgress.set(false);
                }

                public String toString() {
                    return "SeedHostsResolver resolving unicast hosts list";
                }
            });
        }
    }
}

