/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import java.io.Closeable;
import java.util.Collections;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.NotifyOnceListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.discovery.ProbeConnectionResult;
import org.elasticsearch.discovery.TransportAddressConnector;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class HandshakingTransportAddressConnector
implements TransportAddressConnector {
    private static final Logger logger = LogManager.getLogger(HandshakingTransportAddressConnector.class);
    public static final Setting<TimeValue> PROBE_CONNECT_TIMEOUT_SETTING = Setting.timeSetting("discovery.probe.connect_timeout", TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueMillis((long)1L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> PROBE_HANDSHAKE_TIMEOUT_SETTING = Setting.timeSetting("discovery.probe.handshake_timeout", TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueMillis((long)1L), Setting.Property.NodeScope);
    private final TransportService transportService;
    private final TimeValue probeConnectTimeout;
    private final TimeValue probeHandshakeTimeout;

    public HandshakingTransportAddressConnector(Settings settings, TransportService transportService) {
        this.transportService = transportService;
        this.probeConnectTimeout = PROBE_CONNECT_TIMEOUT_SETTING.get(settings);
        this.probeHandshakeTimeout = PROBE_HANDSHAKE_TIMEOUT_SETTING.get(settings);
    }

    @Override
    public void connectToRemoteMasterNode(final TransportAddress transportAddress, ActionListener<ProbeConnectionResult> listener) {
        this.transportService.getThreadPool().generic().execute(new ActionRunnable<ProbeConnectionResult>(listener){
            private final AbstractRunnable thisConnectionAttempt;
            {
                super(listener);
                this.thisConnectionAttempt = this;
            }

            @Override
            protected void doRun() {
                DiscoveryNode targetNode = new DiscoveryNode("", transportAddress.toString(), UUIDs.randomBase64UUID(Randomness.get()), transportAddress.address().getHostString(), transportAddress.getAddress(), transportAddress, Collections.emptyMap(), Collections.emptySet(), Version.CURRENT.minimumCompatibilityVersion());
                logger.trace("[{}] opening probe connection", (Object)this.thisConnectionAttempt);
                HandshakingTransportAddressConnector.this.transportService.openConnection(targetNode, ConnectionProfile.buildSingleChannelProfile(TransportRequestOptions.Type.REG, HandshakingTransportAddressConnector.this.probeConnectTimeout, HandshakingTransportAddressConnector.this.probeHandshakeTimeout, TimeValue.MINUS_ONE, null, null), this.listener.delegateFailure((l, connection) -> {
                    logger.trace("[{}] opened probe connection", (Object)this.thisConnectionAttempt);
                    HandshakingTransportAddressConnector.this.transportService.handshake((Transport.Connection)connection, HandshakingTransportAddressConnector.this.probeHandshakeTimeout, (ActionListener<DiscoveryNode>)new NotifyOnceListener<DiscoveryNode>(){

                        @Override
                        protected void innerOnResponse(final DiscoveryNode remoteNode) {
                            try {
                                logger.trace("[{}] handshake successful: {}", (Object)thisConnectionAttempt, (Object)remoteNode);
                                IOUtils.closeWhileHandlingException((Closeable)connection);
                                if (remoteNode.equals(HandshakingTransportAddressConnector.this.transportService.getLocalNode())) {
                                    listener.onFailure(new ConnectTransportException(remoteNode, String.format(Locale.ROOT, "successfully discovered local node %s at [%s]", remoteNode.descriptionWithoutAttributes(), transportAddress)));
                                } else if (!remoteNode.isMasterNode()) {
                                    listener.onFailure(new ConnectTransportException(remoteNode, String.format(Locale.ROOT, "successfully discovered master-ineligible node %s at [%s]; to suppress this message, remove address [%s] from your discovery configuration or ensure that traffic to this address is routed only to master-eligible nodes", remoteNode.descriptionWithoutAttributes(), transportAddress, transportAddress)));
                                } else {
                                    HandshakingTransportAddressConnector.this.transportService.connectToNode(remoteNode, new ActionListener<Releasable>(){

                                        @Override
                                        public void onResponse(Releasable connectionReleasable) {
                                            logger.trace("[{}] completed full connection with [{}]", (Object)thisConnectionAttempt, (Object)remoteNode);
                                            listener.onResponse(new ProbeConnectionResult(remoteNode, connectionReleasable));
                                        }

                                        @Override
                                        public void onFailure(Exception e) {
                                            logger.warn((Message)new ParameterizedMessage("[{}] completed handshake with [{}] but followup connection failed", (Object)thisConnectionAttempt, (Object)remoteNode), (Throwable)e);
                                            listener.onFailure(e);
                                        }
                                    });
                                }
                            }
                            catch (Exception e) {
                                listener.onFailure(e);
                            }
                        }

                        @Override
                        protected void innerOnFailure(Exception e) {
                            logger.warn((Message)new ParameterizedMessage("handshake failed for [{}]", (Object)thisConnectionAttempt), (Throwable)e);
                            IOUtils.closeWhileHandlingException((Closeable)connection);
                            listener.onFailure(e);
                        }
                    });
                }));
            }

            @Override
            public String toString() {
                return "connectToRemoteMasterNode[" + transportAddress + "]";
            }
        });
    }
}

