/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public interface XContentFieldFilter {
    public BytesReference apply(BytesReference var1, @Nullable XContentType var2) throws IOException;

    public static XContentFieldFilter newFieldFilter(String[] includes, String[] excludes) {
        CheckedFunction emptyValueSupplier = xContentType -> {
            BytesStreamOutput bStream = new BytesStreamOutput();
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)xContentType, (OutputStream)bStream).map(Collections.emptyMap());
            builder.close();
            return bStream.bytes();
        };
        if (!CollectionUtils.isEmpty(excludes) && Arrays.stream(excludes).filter(field -> field.contains("*")).count() > 0L) {
            return (originalSource, contentType) -> {
                if (originalSource == null || originalSource.length() <= 0) {
                    if (contentType == null) {
                        throw new IllegalStateException("originalSource and contentType can not be null at the same time");
                    }
                    return (BytesReference)emptyValueSupplier.apply((Object)contentType);
                }
                Function<Map<String, ?>, Map<String, Object>> mapFilter = XContentMapValues.filter(includes, excludes);
                Tuple<XContentType, Map<String, Object>> mapTuple = XContentHelper.convertToMap(originalSource, true, contentType);
                Map<String, Object> filteredSource = mapFilter.apply((Map)mapTuple.v2());
                BytesStreamOutput bStream = new BytesStreamOutput();
                XContentType actualContentType = (XContentType)mapTuple.v1();
                XContentBuilder builder = XContentFactory.contentBuilder((XContentType)actualContentType, (OutputStream)bStream).map(filteredSource);
                builder.close();
                return bStream.bytes();
            };
        }
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withFiltering(Set.of(includes), Set.of(excludes), true);
        return (originalSource, contentType) -> {
            if (originalSource == null || originalSource.length() <= 0) {
                if (contentType == null) {
                    throw new IllegalStateException("originalSource and contentType can not be null at the same time");
                }
                return (BytesReference)emptyValueSupplier.apply((Object)contentType);
            }
            if (contentType == null) {
                contentType = XContentHelper.xContentTypeMayCompressed(originalSource);
            }
            BytesStreamOutput streamOutput = new BytesStreamOutput(Math.min(1024, originalSource.length()));
            XContentBuilder builder = new XContentBuilder(contentType.xContent(), (OutputStream)streamOutput);
            XContentParser parser = contentType.xContent().createParser(parserConfig, (InputStream)originalSource.streamInput());
            if (parser.currentToken() == null && parser.nextToken() == null) {
                return (BytesReference)emptyValueSupplier.apply((Object)contentType);
            }
            builder.copyCurrentStructure(parser);
            return BytesReference.bytes(builder);
        };
    }
}

