/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;

public final class ByteUtils
extends Enum<ByteUtils> {
    public static final VarHandle LITTLE_ENDIAN_INT;
    public static final VarHandle LITTLE_ENDIAN_LONG;
    private static final /* synthetic */ ByteUtils[] $VALUES;

    public static ByteUtils[] values() {
        return (ByteUtils[])$VALUES.clone();
    }

    public static ByteUtils valueOf(String name) {
        return Enum.valueOf(ByteUtils.class, name);
    }

    public static long zigZagDecode(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    public static long zigZagEncode(long n) {
        return n >> 63 ^ n << 1;
    }

    public static void writeLongLE(long l, byte[] arr, int offset) {
        LITTLE_ENDIAN_LONG.set(arr, offset, l);
    }

    public static long readLongLE(byte[] arr, int offset) {
        return LITTLE_ENDIAN_LONG.get(arr, offset);
    }

    public static void writeIntLE(int l, byte[] arr, int offset) {
        LITTLE_ENDIAN_INT.set(arr, offset, l);
    }

    public static int readIntLE(byte[] arr, int offset) {
        return LITTLE_ENDIAN_INT.get(arr, offset);
    }

    public static void writeDoubleLE(double d, byte[] arr, int offset) {
        ByteUtils.writeLongLE(Double.doubleToRawLongBits(d), arr, offset);
    }

    public static double readDoubleLE(byte[] arr, int offset) {
        return Double.longBitsToDouble(ByteUtils.readLongLE(arr, offset));
    }

    public static void writeFloatLE(float d, byte[] arr, int offset) {
        ByteUtils.writeIntLE(Float.floatToRawIntBits(d), arr, offset);
    }

    public static float readFloatLE(byte[] arr, int offset) {
        return Float.intBitsToFloat(ByteUtils.readIntLE(arr, offset));
    }

    private static /* synthetic */ ByteUtils[] $values() {
        return new ByteUtils[0];
    }

    static {
        $VALUES = ByteUtils.$values();
        LITTLE_ENDIAN_INT = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
        LITTLE_ENDIAN_LONG = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    }
}

