/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.common.io.stream.BytesStream;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class RecyclerBytesStreamOutput
extends BytesStream
implements Releasable {
    static final VarHandle VH_BE_INT = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.BIG_ENDIAN);
    static final VarHandle VH_BE_LONG = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.BIG_ENDIAN);
    private final ArrayList<Recycler.V<BytesRef>> pages = new ArrayList();
    private final Recycler<BytesRef> recycler;
    private final int pageSize;
    private int pageIndex = -1;
    private int currentCapacity = 0;
    private int currentPageOffset;

    public RecyclerBytesStreamOutput(Recycler<BytesRef> recycler) {
        this.recycler = recycler;
        try (Recycler.V<BytesRef> obtain = recycler.obtain();){
            this.pageSize = obtain.v().length;
        }
        this.currentPageOffset = this.pageSize;
    }

    @Override
    public long position() {
        return (long)this.pageSize * (long)this.pageIndex + (long)this.currentPageOffset;
    }

    @Override
    public void writeByte(byte b) {
        this.ensureCapacity(1);
        BytesRef currentPage = this.pages.get(this.pageIndex).v();
        currentPage.bytes[currentPage.offset + this.currentPageOffset] = b;
        ++this.currentPageOffset;
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) {
        if (length == 0) {
            return;
        }
        if (b.length < offset + length) {
            throw new IllegalArgumentException("Illegal offset " + offset + "/length " + length + " for byte[] of length " + b.length);
        }
        this.ensureCapacity(length);
        int bytesToCopy = length;
        int srcOff = offset;
        int j = 0;
        while (true) {
            BytesRef currentPage = this.pages.get(this.pageIndex + j).v();
            int toCopyThisLoop = Math.min(this.pageSize - this.currentPageOffset, bytesToCopy);
            System.arraycopy(b, srcOff, currentPage.bytes, currentPage.offset + this.currentPageOffset, toCopyThisLoop);
            srcOff += toCopyThisLoop;
            if ((bytesToCopy -= toCopyThisLoop) <= 0) {
                this.currentPageOffset += toCopyThisLoop;
                break;
            }
            this.currentPageOffset = 0;
            ++j;
        }
        this.pageIndex += j;
    }

    @Override
    public void writeInt(int i) throws IOException {
        if (4 > this.pageSize - this.currentPageOffset) {
            super.writeInt(i);
        } else {
            BytesRef currentPage = this.pages.get(this.pageIndex).v();
            VH_BE_INT.set(currentPage.bytes, currentPage.offset + this.currentPageOffset, i);
            this.currentPageOffset += 4;
        }
    }

    @Override
    public void writeLong(long i) throws IOException {
        if (8 > this.pageSize - this.currentPageOffset) {
            super.writeLong(i);
        } else {
            BytesRef currentPage = this.pages.get(this.pageIndex).v();
            VH_BE_LONG.set(currentPage.bytes, currentPage.offset + this.currentPageOffset, i);
            this.currentPageOffset += 8;
        }
    }

    @Override
    public void reset() {
        Releasables.close(this.pages);
        this.pages.clear();
        this.pageIndex = -1;
        this.currentPageOffset = this.pageSize;
    }

    @Override
    public void flush() {
    }

    @Override
    public void seek(long position) {
        this.ensureCapacityFromPosition(position);
        this.pageIndex = (int)position / this.pageSize;
        this.currentPageOffset = (int)position % this.pageSize;
    }

    public void skip(int length) {
        this.seek(this.position() + (long)length);
    }

    @Override
    public void close() {
        try {
            Releasables.close(this.pages);
        }
        finally {
            this.pages.clear();
        }
    }

    public int size() {
        return Math.toIntExact(this.position());
    }

    @Override
    public BytesReference bytes() {
        int bytesInLastPage;
        int adjustment;
        int position = (int)this.position();
        if (position == 0) {
            return BytesArray.EMPTY;
        }
        int remainder = position % this.pageSize;
        if (remainder != 0) {
            adjustment = 1;
            bytesInLastPage = remainder;
        } else {
            adjustment = 0;
            bytesInLastPage = this.pageSize;
        }
        int pageCount = position / this.pageSize + adjustment;
        if (pageCount == 1) {
            BytesRef page = this.pages.get(0).v();
            return new BytesArray(page.bytes, page.offset, bytesInLastPage);
        }
        BytesReference[] references = new BytesReference[pageCount];
        for (int i = 0; i < pageCount - 1; ++i) {
            references[i] = new BytesArray(this.pages.get(i).v());
        }
        BytesRef last = this.pages.get(pageCount - 1).v();
        references[pageCount - 1] = new BytesArray(last.bytes, last.offset, bytesInLastPage);
        return CompositeBytesReference.of(references);
    }

    private void ensureCapacity(int bytesNeeded) {
        if (bytesNeeded > this.pageSize - this.currentPageOffset) {
            this.ensureCapacityFromPosition(this.position() + (long)bytesNeeded);
        }
    }

    private void ensureCapacityFromPosition(long newPosition) {
        while (newPosition > (long)this.currentCapacity) {
            if (newPosition > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(this.getClass().getSimpleName() + " cannot hold more than 2GB of data");
            }
            Recycler.V<BytesRef> newPage = this.recycler.obtain();
            assert (this.pageSize == newPage.v().length);
            this.pages.add(newPage);
            if (this.currentPageOffset == this.pageSize) {
                ++this.pageIndex;
                this.currentPageOffset = 0;
            }
            this.currentCapacity += this.pageSize;
        }
    }
}

