/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;

public class DiskIoBufferPool {
    public static final int BUFFER_SIZE = StrictMath.toIntExact(ByteSizeValue.parseBytesSizeValue(System.getProperty("es.disk_io.direct.buffer.size", "64KB"), "es.disk_io.direct.buffer.size").getBytes());
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    protected static final ThreadLocal<ByteBuffer> ioBufferPool = ThreadLocal.withInitial(() -> {
        if (DiskIoBufferPool.isWriteOrFlushThread()) {
            return ByteBuffer.allocateDirect(BUFFER_SIZE);
        }
        return EMPTY_BUFFER;
    });
    public static final DiskIoBufferPool INSTANCE = new DiskIoBufferPool();

    protected DiskIoBufferPool() {
    }

    @Nullable
    public ByteBuffer maybeGetDirectIOBuffer() {
        ByteBuffer ioBuffer = ioBufferPool.get();
        if (ioBuffer == EMPTY_BUFFER) {
            return null;
        }
        return ioBuffer.clear();
    }

    private static boolean isWriteOrFlushThread() {
        String threadName = Thread.currentThread().getName();
        for (String s : Arrays.asList("[write]", "[flush]", "[system_write]", "[system_critical_write]")) {
            if (!threadName.contains(s)) continue;
            return true;
        }
        return false;
    }
}

