/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.service.SourcePrioritizedRunnable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.PrioritizedEsThreadPoolExecutor;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;

public abstract class TaskBatcher {
    private final Logger logger;
    private final PrioritizedEsThreadPoolExecutor threadExecutor;
    final Map<Object, Set<BatchedTask>> tasksPerBatchingKey = new ConcurrentHashMap<Object, Set<BatchedTask>>();
    private static final int MAX_TASK_DESCRIPTION_CHARS = 8192;

    public TaskBatcher(Logger logger, PrioritizedEsThreadPoolExecutor threadExecutor) {
        this.logger = logger;
        this.threadExecutor = threadExecutor;
    }

    public void submitTasks(List<? extends BatchedTask> tasks, @Nullable TimeValue timeout) throws EsRejectedExecutionException {
        if (tasks.isEmpty()) {
            return;
        }
        BatchedTask firstTask = tasks.get(0);
        assert (tasks.stream().allMatch(t -> t.batchingKey == firstTask.batchingKey)) : "tasks submitted in a batch should share the same batching key: " + tasks;
        this.tasksPerBatchingKey.compute(firstTask.batchingKey, (k, existingTasks) -> {
            assert (TaskBatcher.assertNoDuplicateTasks(tasks, existingTasks));
            if (existingTasks == null) {
                return Collections.synchronizedSet(new LinkedHashSet(tasks));
            }
            existingTasks.addAll(tasks);
            return existingTasks;
        });
        if (timeout != null) {
            this.threadExecutor.execute(firstTask, timeout, () -> this.onTimeoutInternal(tasks, timeout));
        } else {
            this.threadExecutor.execute(firstTask);
        }
    }

    private static boolean assertNoDuplicateTasks(List<? extends BatchedTask> tasks, Set<BatchedTask> existingTasks) {
        Map tasksIdentity = tasks.stream().collect(Collectors.toMap(BatchedTask::getTask, Function.identity(), (a, b) -> {
            throw new AssertionError((Object)("cannot add duplicate task: " + a));
        }, IdentityHashMap::new));
        if (existingTasks == null) {
            return true;
        }
        for (BatchedTask existing : existingTasks) {
            BatchedTask duplicateTask = (BatchedTask)tasksIdentity.get(existing.getTask());
            assert (duplicateTask == null) : "task [" + duplicateTask.describeTasks(Collections.singletonList(existing)) + "] with source [" + duplicateTask.source + "] is already queued";
        }
        return true;
    }

    private void onTimeoutInternal(List<? extends BatchedTask> tasks, TimeValue timeout) {
        ArrayList<BatchedTask> toRemove = new ArrayList<BatchedTask>();
        for (BatchedTask batchedTask : tasks) {
            if (batchedTask.processed.getAndSet(true)) continue;
            this.logger.debug("task [{}] timed out after [{}]", (Object)batchedTask.source, (Object)timeout);
            toRemove.add(batchedTask);
        }
        if (!toRemove.isEmpty()) {
            BatchedTask firstTask = (BatchedTask)toRemove.get(0);
            Object object = firstTask.batchingKey;
            assert (tasks.stream().allMatch(t -> t.batchingKey == batchingKey)) : "tasks submitted in a batch should share the same batching key: " + tasks;
            this.tasksPerBatchingKey.computeIfPresent(object, (key, existingTasks) -> {
                toRemove.forEach(existingTasks::remove);
                if (existingTasks.isEmpty()) {
                    return null;
                }
                return existingTasks;
            });
            this.onTimeout(toRemove, timeout);
        }
    }

    protected abstract void onTimeout(List<? extends BatchedTask> var1, TimeValue var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runIfNotProcessed(BatchedTask updateTask) {
        if (!updateTask.processed.get()) {
            ArrayList<BatchedTask> toExecute = new ArrayList<BatchedTask>();
            HashMap<String, List<BatchedTask>> processTasksBySource = new HashMap<String, List<BatchedTask>>();
            Set<BatchedTask> pending = this.tasksPerBatchingKey.remove(updateTask.batchingKey);
            if (pending != null) {
                Set<BatchedTask> set = pending;
                synchronized (set) {
                    for (BatchedTask task : pending) {
                        if (!task.processed.getAndSet(true)) {
                            this.logger.trace("will process {}", (Object)task);
                            toExecute.add(task);
                            processTasksBySource.computeIfAbsent(task.source, s -> new ArrayList()).add(task);
                            continue;
                        }
                        this.logger.trace("skipping {}, already processed", (Object)task);
                    }
                }
            }
            if (!toExecute.isEmpty()) {
                this.run(updateTask.batchingKey, toExecute, this.buildTasksDescription(updateTask, toExecute, processTasksBySource));
            }
        }
    }

    private String buildTasksDescription(BatchedTask updateTask, List<BatchedTask> toExecute, Map<String, List<BatchedTask>> processTasksBySource) {
        StringBuilder output = new StringBuilder();
        Strings.collectionToDelimitedStringWithLimit(() -> processTasksBySource.entrySet().stream().map(entry -> {
            String tasks = updateTask.describeTasks((List)entry.getValue());
            return tasks.isEmpty() ? (String)entry.getKey() : (String)entry.getKey() + "[" + tasks + "]";
        }).filter(s -> !s.isEmpty()).iterator(), ", ", "", "", 8192, output);
        if (output.length() > 8192) {
            output.append(" (").append(toExecute.size()).append(" tasks in total)");
        }
        return output.toString();
    }

    protected abstract void run(Object var1, List<? extends BatchedTask> var2, String var3);

    protected abstract class BatchedTask
    extends SourcePrioritizedRunnable {
        protected final AtomicBoolean processed;
        protected final Object batchingKey;
        protected final Object task;

        protected BatchedTask(Priority priority, String source, Object batchingKey, Object task) {
            super(priority, source);
            this.processed = new AtomicBoolean();
            this.batchingKey = batchingKey;
            this.task = task;
        }

        @Override
        public void run() {
            TaskBatcher.this.runIfNotProcessed(this);
        }

        @Override
        public String toString() {
            String taskDescription = this.describeTasks(Collections.singletonList(this));
            if (taskDescription.isEmpty()) {
                return "[" + this.source + "]";
            }
            return "[" + this.source + "[" + taskDescription + "]]";
        }

        public abstract String describeTasks(List<? extends BatchedTask> var1);

        public Object getTask() {
            return this.task;
        }
    }
}

