/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingChangesObserver;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.IndexMetadataUpdater;
import org.elasticsearch.cluster.routing.allocation.RoutingNodesChangedObserver;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.snapshots.SnapshotShardSizeInfo;

public class RoutingAllocation {
    private final AllocationDeciders deciders;
    @Nullable
    private final RoutingNodes routingNodes;
    private final ClusterState clusterState;
    private final ClusterInfo clusterInfo;
    private final SnapshotShardSizeInfo shardSizeInfo;
    private Map<ShardId, Set<String>> ignoredShardToNodes = null;
    private boolean ignoreDisable = false;
    private DebugMode debugDecision = DebugMode.OFF;
    private boolean hasPendingAsyncFetch = false;
    private final long currentNanoTime;
    private final IndexMetadataUpdater indexMetadataUpdater = new IndexMetadataUpdater();
    private final RoutingNodesChangedObserver nodesChangedObserver = new RoutingNodesChangedObserver();
    private final RestoreService.RestoreInProgressUpdater restoreInProgressUpdater = new RestoreService.RestoreInProgressUpdater();
    private final RoutingChangesObserver routingChangesObserver = new RoutingChangesObserver.DelegatingRoutingChangesObserver(this.nodesChangedObserver, this.indexMetadataUpdater, this.restoreInProgressUpdater);
    private final Map<String, SingleNodeShutdownMetadata> nodeReplacementTargets;

    public RoutingAllocation(AllocationDeciders deciders, ClusterState clusterState, ClusterInfo clusterInfo, SnapshotShardSizeInfo shardSizeInfo, long currentNanoTime) {
        this(deciders, null, clusterState, clusterInfo, shardSizeInfo, currentNanoTime);
    }

    public RoutingAllocation(AllocationDeciders deciders, @Nullable RoutingNodes routingNodes, ClusterState clusterState, ClusterInfo clusterInfo, SnapshotShardSizeInfo shardSizeInfo, long currentNanoTime) {
        this.deciders = deciders;
        this.routingNodes = routingNodes;
        this.clusterState = clusterState;
        this.clusterInfo = clusterInfo;
        this.shardSizeInfo = shardSizeInfo;
        this.currentNanoTime = currentNanoTime;
        HashMap<String, SingleNodeShutdownMetadata> targetNameToShutdown = new HashMap<String, SingleNodeShutdownMetadata>();
        for (SingleNodeShutdownMetadata shutdown : clusterState.metadata().nodeShutdowns().values()) {
            if (shutdown.getType() != SingleNodeShutdownMetadata.Type.REPLACE) continue;
            targetNameToShutdown.put(shutdown.getTargetNodeName(), shutdown);
        }
        this.nodeReplacementTargets = Collections.unmodifiableMap(targetNameToShutdown);
    }

    public long getCurrentNanoTime() {
        return this.currentNanoTime;
    }

    public AllocationDeciders deciders() {
        return this.deciders;
    }

    public RoutingTable routingTable() {
        return this.clusterState.routingTable();
    }

    public RoutingNodes routingNodes() {
        if (this.routingNodes != null) {
            return this.routingNodes;
        }
        return this.clusterState.getRoutingNodes();
    }

    public Metadata metadata() {
        return this.clusterState.metadata();
    }

    public DiscoveryNodes nodes() {
        return this.clusterState.nodes();
    }

    public ClusterInfo clusterInfo() {
        return this.clusterInfo;
    }

    public SnapshotShardSizeInfo snapshotShardSizeInfo() {
        return this.shardSizeInfo;
    }

    public Map<String, SingleNodeShutdownMetadata> nodeShutdowns() {
        return this.metadata().nodeShutdowns();
    }

    public Map<String, SingleNodeShutdownMetadata> replacementTargetShutdowns() {
        return this.nodeReplacementTargets;
    }

    public <T extends ClusterState.Custom> T custom(String key) {
        return (T)this.clusterState.customs().get(key);
    }

    public ImmutableOpenMap<String, ClusterState.Custom> getCustoms() {
        return this.clusterState.getCustoms();
    }

    public void ignoreDisable(boolean ignoreDisable) {
        this.ignoreDisable = ignoreDisable;
    }

    public boolean ignoreDisable() {
        return this.ignoreDisable;
    }

    public void setDebugMode(DebugMode debug) {
        this.debugDecision = debug;
    }

    public void debugDecision(boolean debug) {
        this.debugDecision = debug ? DebugMode.ON : DebugMode.OFF;
    }

    public boolean debugDecision() {
        return this.debugDecision != DebugMode.OFF;
    }

    public DebugMode getDebugMode() {
        return this.debugDecision;
    }

    public void addIgnoreShardForNode(ShardId shardId, String nodeId) {
        if (this.ignoredShardToNodes == null) {
            this.ignoredShardToNodes = new HashMap<ShardId, Set<String>>();
        }
        this.ignoredShardToNodes.computeIfAbsent(shardId, k -> new HashSet()).add(nodeId);
    }

    public boolean shouldIgnoreShardForNode(ShardId shardId, String nodeId) {
        if (this.ignoredShardToNodes == null) {
            return false;
        }
        Set<String> nodes = this.ignoredShardToNodes.get(shardId);
        return nodes != null && nodes.contains(nodeId);
    }

    public Set<String> getIgnoreNodes(ShardId shardId) {
        if (this.ignoredShardToNodes == null) {
            return Collections.emptySet();
        }
        Set<String> ignore = this.ignoredShardToNodes.get(shardId);
        if (ignore == null) {
            return Collections.emptySet();
        }
        return Set.copyOf(ignore);
    }

    public void removeAllocationId(ShardRouting shardRouting) {
        this.indexMetadataUpdater.removeAllocationId(shardRouting);
    }

    public RoutingChangesObserver changes() {
        return this.routingChangesObserver;
    }

    public Metadata updateMetadataWithRoutingChanges(RoutingTable newRoutingTable) {
        return this.indexMetadataUpdater.applyChanges(this.metadata(), newRoutingTable);
    }

    public RestoreInProgress updateRestoreInfoWithRoutingChanges(RestoreInProgress restoreInProgress) {
        return this.restoreInProgressUpdater.applyChanges(restoreInProgress);
    }

    public boolean routingNodesChanged() {
        return this.nodesChangedObserver.isChanged();
    }

    public Decision decision(Decision decision, String deciderLabel, String reason, Object ... params) {
        if (this.debugDecision()) {
            return Decision.single(decision.type(), deciderLabel, reason, params);
        }
        return decision;
    }

    public boolean hasPendingAsyncFetch() {
        return this.hasPendingAsyncFetch;
    }

    public void setHasPendingAsyncFetch() {
        this.hasPendingAsyncFetch = true;
    }

    public static enum DebugMode {
        OFF,
        ON,
        EXCLUDE_YES_DECISIONS;

    }
}

