/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.IntConsumer;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.routing.Murmur3HashFunction;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public abstract class IndexRouting {
    protected final String indexName;
    private final int routingNumShards;
    private final int routingFactor;

    public static IndexRouting fromIndexMetadata(IndexMetadata metadata) {
        if (!metadata.getRoutingPaths().isEmpty()) {
            return new ExtractFromSource(metadata);
        }
        if (metadata.isRoutingPartitionedIndex()) {
            return new Partitioned(metadata);
        }
        return new Unpartitioned(metadata);
    }

    private IndexRouting(IndexMetadata metadata) {
        this.indexName = metadata.getIndex().getName();
        this.routingNumShards = metadata.getRoutingNumShards();
        this.routingFactor = metadata.getRoutingFactor();
    }

    public abstract int indexShard(String var1, @Nullable String var2, XContentType var3, BytesReference var4);

    public abstract int updateShard(String var1, @Nullable String var2);

    public abstract int deleteShard(String var1, @Nullable String var2);

    public abstract int getShard(String var1, @Nullable String var2);

    public abstract void collectSearchShards(String var1, IntConsumer var2);

    protected final int hashToShardId(int hash) {
        return Math.floorMod(hash, this.routingNumShards) / this.routingFactor;
    }

    private static int effectiveRoutingToHash(String effectiveRouting) {
        return Murmur3HashFunction.hash(effectiveRouting);
    }

    public void checkIndexSplitAllowed() {
    }

    private static class ExtractFromSource
    extends IndexRouting {
        private final XContentParserConfiguration parserConfig;

        ExtractFromSource(IndexMetadata metadata) {
            super(metadata);
            if (metadata.isRoutingPartitionedIndex()) {
                throw new IllegalArgumentException("routing_partition_size is incompatible with routing_path");
            }
            this.parserConfig = XContentParserConfiguration.EMPTY.withFiltering(Set.copyOf(metadata.getRoutingPaths()), null, true);
        }

        @Override
        public int indexShard(String id, @Nullable String routing, XContentType sourceType, BytesReference source) {
            if (routing != null) {
                throw new IllegalArgumentException(this.error("indexing with a specified routing"));
            }
            assert (Transports.assertNotTransportThread("parsing the _source can get slow"));
            ArrayList<NameAndHash> hashes = new ArrayList<NameAndHash>();
            try (XContentParser parser = sourceType.xContent().createParser(this.parserConfig, (InputStream)source.streamInput());){
                parser.nextToken();
                if (parser.currentToken() == null) {
                    throw new IllegalArgumentException("Error extracting routing: source didn't contain any routing fields");
                }
                parser.nextToken();
                ExtractFromSource.extractObject(hashes, null, parser);
                XContentParserUtils.ensureExpectedToken(null, parser.nextToken(), parser);
            }
            catch (IOException | ParsingException e) {
                throw new IllegalArgumentException("Error extracting routing: " + e.getMessage(), e);
            }
            return this.hashToShardId(ExtractFromSource.hashesToHash(hashes));
        }

        private static void extractObject(List<NameAndHash> hashes, @Nullable String path, XContentParser source) throws IOException {
            while (source.currentToken() != XContentParser.Token.END_OBJECT) {
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, source.currentToken(), source);
                String fieldName = source.currentName();
                String subPath = path == null ? fieldName : path + "." + fieldName;
                source.nextToken();
                ExtractFromSource.extractItem(hashes, subPath, source);
            }
        }

        private static void extractItem(List<NameAndHash> hashes, String path, XContentParser source) throws IOException {
            switch (source.currentToken()) {
                case START_OBJECT: {
                    source.nextToken();
                    ExtractFromSource.extractObject(hashes, path, source);
                    source.nextToken();
                    break;
                }
                case VALUE_STRING: {
                    hashes.add(new NameAndHash(new BytesRef((CharSequence)path), ExtractFromSource.hash(new BytesRef((CharSequence)source.text()))));
                    source.nextToken();
                    break;
                }
                case VALUE_NULL: {
                    source.nextToken();
                    break;
                }
                default: {
                    throw new ParsingException(source.getTokenLocation(), "Routing values must be strings but found [{}]", source.currentToken());
                }
            }
        }

        private static int hash(BytesRef ref) {
            return StringHelper.murmurhash3_x86_32((BytesRef)ref, (int)0);
        }

        private static int hashesToHash(List<NameAndHash> hashes) {
            Collections.sort(hashes);
            Iterator<NameAndHash> itr = hashes.iterator();
            if (!itr.hasNext()) {
                throw new IllegalArgumentException("Error extracting routing: source didn't contain any routing fields");
            }
            NameAndHash prev = itr.next();
            int hash = ExtractFromSource.hash(prev.name) ^ prev.hash;
            while (itr.hasNext()) {
                NameAndHash next = itr.next();
                if (prev.name.equals((Object)next.name)) {
                    throw new IllegalArgumentException("Duplicate routing dimension for [" + next.name + "]");
                }
                int thisHash = ExtractFromSource.hash(next.name) ^ next.hash;
                hash = 31 * hash + thisHash;
                prev = next;
            }
            return hash;
        }

        @Override
        public int updateShard(String id, @Nullable String routing) {
            throw new IllegalArgumentException(this.error("update"));
        }

        @Override
        public int deleteShard(String id, @Nullable String routing) {
            throw new IllegalArgumentException(this.error("delete"));
        }

        @Override
        public int getShard(String id, @Nullable String routing) {
            throw new IllegalArgumentException(this.error("get"));
        }

        @Override
        public void checkIndexSplitAllowed() {
            throw new IllegalArgumentException(this.error("index-split"));
        }

        @Override
        public void collectSearchShards(String routing, IntConsumer consumer) {
            throw new IllegalArgumentException(this.error("searching with a specified routing"));
        }

        private String error(String operation) {
            return operation + " is not supported because the destination index [" + this.indexName + "] is in time series mode";
        }
    }

    private static class Partitioned
    extends IdAndRoutingOnly {
        private final int routingPartitionSize;

        Partitioned(IndexMetadata metadata) {
            super(metadata);
            this.routingPartitionSize = metadata.getRoutingPartitionSize();
        }

        @Override
        protected int shardId(String id, @Nullable String routing) {
            if (routing == null) {
                throw new IllegalArgumentException("A routing value is required for gets from a partitioned index");
            }
            int offset = Math.floorMod(IndexRouting.effectiveRoutingToHash(id), this.routingPartitionSize);
            return this.hashToShardId(IndexRouting.effectiveRoutingToHash(routing) + offset);
        }

        @Override
        public void collectSearchShards(String routing, IntConsumer consumer) {
            int hash = IndexRouting.effectiveRoutingToHash(routing);
            for (int i = 0; i < this.routingPartitionSize; ++i) {
                consumer.accept(this.hashToShardId(hash + i));
            }
        }
    }

    private static class Unpartitioned
    extends IdAndRoutingOnly {
        Unpartitioned(IndexMetadata metadata) {
            super(metadata);
        }

        @Override
        protected int shardId(String id, @Nullable String routing) {
            return this.hashToShardId(IndexRouting.effectiveRoutingToHash(routing == null ? id : routing));
        }

        @Override
        public void collectSearchShards(String routing, IntConsumer consumer) {
            consumer.accept(this.hashToShardId(IndexRouting.effectiveRoutingToHash(routing)));
        }
    }

    private record NameAndHash(BytesRef name, int hash) implements Comparable<NameAndHash>
    {
        @Override
        public int compareTo(NameAndHash o) {
            return this.name.compareTo(o.name);
        }
    }

    private static abstract class IdAndRoutingOnly
    extends IndexRouting {
        private final boolean routingRequired;

        IdAndRoutingOnly(IndexMetadata metadata) {
            super(metadata);
            MappingMetadata mapping = metadata.mapping();
            this.routingRequired = mapping == null ? false : mapping.routingRequired();
        }

        protected abstract int shardId(String var1, @Nullable String var2);

        @Override
        public int indexShard(String id, @Nullable String routing, XContentType sourceType, BytesReference source) {
            this.checkRoutingRequired(id, routing);
            return this.shardId(id, routing);
        }

        @Override
        public int updateShard(String id, @Nullable String routing) {
            this.checkRoutingRequired(id, routing);
            return this.shardId(id, routing);
        }

        @Override
        public int deleteShard(String id, @Nullable String routing) {
            this.checkRoutingRequired(id, routing);
            return this.shardId(id, routing);
        }

        @Override
        public int getShard(String id, @Nullable String routing) {
            this.checkRoutingRequired(id, routing);
            return this.shardId(id, routing);
        }

        private void checkRoutingRequired(String id, @Nullable String routing) {
            if (this.routingRequired && routing == null) {
                throw new RoutingMissingException(this.indexName, id);
            }
        }
    }
}

