/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsClusterStateUpdateRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.threadpool.ThreadPool;

public class MetadataUpdateSettingsService {
    private static final Logger logger = LogManager.getLogger(MetadataUpdateSettingsService.class);
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final IndexScopedSettings indexScopedSettings;
    private final IndicesService indicesService;
    private final ShardLimitValidator shardLimitValidator;
    private final ThreadPool threadPool;
    private final ClusterStateTaskExecutor<AckedClusterStateUpdateTask> executor;

    public MetadataUpdateSettingsService(ClusterService clusterService, AllocationService allocationService, IndexScopedSettings indexScopedSettings, IndicesService indicesService, ShardLimitValidator shardLimitValidator, ThreadPool threadPool) {
        this.clusterService = clusterService;
        this.allocationService = allocationService;
        this.indexScopedSettings = indexScopedSettings;
        this.indicesService = indicesService;
        this.shardLimitValidator = shardLimitValidator;
        this.threadPool = threadPool;
        this.executor = (currentState, tasks) -> {
            ClusterStateTaskExecutor.ClusterTasksResult.Builder<AckedClusterStateUpdateTask> builder = ClusterStateTaskExecutor.ClusterTasksResult.builder();
            ClusterState state = currentState;
            for (AckedClusterStateUpdateTask task : tasks) {
                try {
                    state = task.execute(state);
                    builder.success(task);
                }
                catch (Exception e) {
                    builder.failure(task, e);
                }
            }
            if (state != currentState) {
                state = allocationService.reroute(state, "settings update");
            }
            return builder.build(state);
        };
    }

    public void updateSettings(final UpdateSettingsClusterStateUpdateRequest request, ActionListener<AcknowledgedResponse> listener) {
        final Settings normalizedSettings = Settings.builder().put(request.settings()).normalizePrefix("index.").build();
        Settings.Builder settingsForClosedIndices = Settings.builder();
        Settings.Builder settingsForOpenIndices = Settings.builder();
        final HashSet<String> skippedSettings = new HashSet<String>();
        this.indexScopedSettings.validate(normalizedSettings.filter(s -> !Regex.isSimpleMatchPattern(s)), false, true);
        for (String key : normalizedSettings.keySet()) {
            boolean isWildcard;
            Setting<?> setting = this.indexScopedSettings.get(key);
            boolean bl = isWildcard = setting == null && Regex.isSimpleMatchPattern(key);
            assert (setting != null || isWildcard && !normalizedSettings.hasValue(key)) : "unknown setting: " + key + " isWildcard: " + isWildcard + " hasValue: " + normalizedSettings.hasValue(key);
            settingsForClosedIndices.copy(key, normalizedSettings);
            if (isWildcard || setting.isDynamic()) {
                settingsForOpenIndices.copy(key, normalizedSettings);
                continue;
            }
            skippedSettings.add(key);
        }
        final Settings closedSettings = settingsForClosedIndices.build();
        final Settings openSettings = settingsForOpenIndices.build();
        final boolean preserveExisting = request.isPreserveExisting();
        AckedClusterStateUpdateTask clusterTask = new AckedClusterStateUpdateTask(Priority.URGENT, request, ContextPreservingActionListener.wrapPreservingContext(listener, this.threadPool.getThreadContext())){

            @Override
            public ClusterState execute(ClusterState currentState) {
                RoutingTable.Builder routingTableBuilder = null;
                Metadata.Builder metadataBuilder = Metadata.builder(currentState.metadata());
                HashSet<Index> openIndices = new HashSet<Index>();
                HashSet<Index> closedIndices = new HashSet<Index>();
                String[] actualIndices = new String[request.indices().length];
                for (int i = 0; i < request.indices().length; ++i) {
                    Index index2 = request.indices()[i];
                    actualIndices[i] = index2.getName();
                    IndexMetadata metadata = currentState.metadata().getIndexSafe(index2);
                    if (metadata.getState() == IndexMetadata.State.OPEN) {
                        openIndices.add(index2);
                        continue;
                    }
                    closedIndices.add(index2);
                }
                if (!skippedSettings.isEmpty() && !openIndices.isEmpty()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Can't update non dynamic settings [%s] for open indices %s", skippedSettings, openIndices));
                }
                if (IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.exists(openSettings)) {
                    int updatedNumberOfReplicas = IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(openSettings);
                    if (!preserveExisting) {
                        MetadataUpdateSettingsService.this.shardLimitValidator.validateShardLimitOnReplicaUpdate(currentState, request.indices(), updatedNumberOfReplicas);
                        routingTableBuilder = RoutingTable.builder(currentState.routingTable());
                        routingTableBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                        metadataBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                        logger.info("updating number_of_replicas to [{}] for indices {}", (Object)updatedNumberOfReplicas, (Object)actualIndices);
                    }
                }
                MetadataUpdateSettingsService.updateIndexSettings(openIndices, metadataBuilder, (index, indexSettings) -> MetadataUpdateSettingsService.this.indexScopedSettings.updateDynamicSettings(openSettings, (Settings.Builder)indexSettings, Settings.builder(), index.getName()), preserveExisting, MetadataUpdateSettingsService.this.indexScopedSettings);
                MetadataUpdateSettingsService.updateIndexSettings(closedIndices, metadataBuilder, (index, indexSettings) -> MetadataUpdateSettingsService.this.indexScopedSettings.updateSettings(closedSettings, (Settings.Builder)indexSettings, Settings.builder(), index.getName()), preserveExisting, MetadataUpdateSettingsService.this.indexScopedSettings);
                if (IndexSettings.INDEX_TRANSLOG_RETENTION_AGE_SETTING.exists(normalizedSettings) || IndexSettings.INDEX_TRANSLOG_RETENTION_SIZE_SETTING.exists(normalizedSettings)) {
                    for (String index3 : actualIndices) {
                        Settings settings = metadataBuilder.get(index3).getSettings();
                        MetadataCreateIndexService.validateTranslogRetentionSettings(settings);
                        MetadataCreateIndexService.validateStoreTypeSetting(settings);
                    }
                }
                boolean changed = false;
                for (String index4 : actualIndices) {
                    if (IndexSettings.same(currentState.metadata().index(index4).getSettings(), metadataBuilder.get(index4).getSettings())) continue;
                    changed = true;
                    IndexMetadata.Builder builder = IndexMetadata.builder(metadataBuilder.get(index4));
                    builder.settingsVersion(1L + builder.settingsVersion());
                    metadataBuilder.put(builder);
                }
                ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                boolean changedBlocks = false;
                for (IndexMetadata.APIBlock block : IndexMetadata.APIBlock.values()) {
                    changedBlocks |= MetadataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, block.block, block.setting, openSettings);
                }
                if (!(changed |= changedBlocks)) {
                    return currentState;
                }
                ClusterState updatedState = ClusterState.builder(currentState).metadata(metadataBuilder).routingTable(routingTableBuilder == null ? currentState.routingTable() : routingTableBuilder.build()).blocks(changedBlocks ? blocks.build() : currentState.blocks()).build();
                try {
                    IndexMetadata updatedMetadata;
                    IndexMetadata currentMetadata;
                    for (Index index5 : openIndices) {
                        currentMetadata = currentState.metadata().getIndexSafe(index5);
                        updatedMetadata = updatedState.metadata().getIndexSafe(index5);
                        MetadataUpdateSettingsService.this.indicesService.verifyIndexMetadata(currentMetadata, updatedMetadata);
                    }
                    for (Index index6 : closedIndices) {
                        currentMetadata = currentState.metadata().getIndexSafe(index6);
                        updatedMetadata = updatedState.metadata().getIndexSafe(index6);
                        MetadataUpdateSettingsService.this.indicesService.verifyIndexMetadata(currentMetadata, updatedMetadata);
                        MetadataUpdateSettingsService.this.indicesService.verifyIndexMetadata(updatedMetadata, updatedMetadata);
                    }
                }
                catch (IOException ex) {
                    throw ExceptionsHelper.convertToElastic(ex);
                }
                return updatedState;
            }
        };
        this.clusterService.submitStateUpdateTask("update-settings " + Arrays.toString(request.indices()), clusterTask, this.executor);
    }

    public static void updateIndexSettings(Set<Index> indices, Metadata.Builder metadataBuilder, BiFunction<Index, Settings.Builder, Boolean> settingUpdater, Boolean preserveExisting, IndexScopedSettings indexScopedSettings) {
        for (Index index : indices) {
            IndexMetadata indexMetadata = metadataBuilder.getSafe(index);
            Settings.Builder indexSettings = Settings.builder().put(indexMetadata.getSettings());
            if (!settingUpdater.apply(index, indexSettings).booleanValue()) continue;
            if (preserveExisting.booleanValue()) {
                indexSettings.put(indexMetadata.getSettings());
            }
            if (!IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.exists(indexSettings)) {
                indexSettings.put("index.number_of_replicas", IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(Settings.EMPTY));
            }
            Settings finalSettings = indexSettings.build();
            indexScopedSettings.validate(finalSettings.filter(k -> !indexScopedSettings.isPrivateSetting((String)k)), true);
            metadataBuilder.put(IndexMetadata.builder(indexMetadata).settings(finalSettings));
        }
    }

    private static boolean maybeUpdateClusterBlock(String[] actualIndices, ClusterBlocks.Builder blocks, ClusterBlock block, Setting<Boolean> setting, Settings openSettings) {
        boolean changed = false;
        if (setting.exists(openSettings)) {
            boolean updateBlock = setting.get(openSettings);
            for (String index : actualIndices) {
                if (updateBlock) {
                    if (blocks.hasIndexBlock(index, block)) continue;
                    blocks.addIndexBlock(index, block);
                    changed = true;
                    continue;
                }
                if (!blocks.hasIndexBlock(index, block)) continue;
                blocks.removeIndexBlock(index, block);
                changed = true;
            }
        }
        return changed;
    }
}

