/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public interface IndexAbstraction {
    public Type getType();

    public String getName();

    public List<Index> getIndices();

    @Nullable
    public Index getWriteIndex();

    default public Index getWriteIndex(IndexRequest request, Metadata metadata) {
        return this.getWriteIndex();
    }

    @Nullable
    public DataStream getParentDataStream();

    public boolean isHidden();

    public boolean isSystem();

    default public boolean isDataStreamRelated() {
        return false;
    }

    @Nullable
    public List<String> getAliases();

    public static class DataStream
    implements IndexAbstraction {
        public static final XContentParserConfiguration TS_EXTRACT_CONFIG = XContentParserConfiguration.EMPTY.withFiltering(Set.of("@timestamp"), null, false);
        private final org.elasticsearch.cluster.metadata.DataStream dataStream;
        private final List<String> referencedByDataStreamAliases;

        public DataStream(org.elasticsearch.cluster.metadata.DataStream dataStream, List<String> aliases) {
            this.dataStream = dataStream;
            this.referencedByDataStreamAliases = aliases;
        }

        @Override
        public String getName() {
            return this.dataStream.getName();
        }

        @Override
        public Type getType() {
            return Type.DATA_STREAM;
        }

        @Override
        public List<Index> getIndices() {
            return this.dataStream.getIndices();
        }

        @Override
        public Index getWriteIndex() {
            return this.dataStream.getWriteIndex();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Index getWriteIndex(IndexRequest request, Metadata metadata) {
            if (request.opType() != DocWriteRequest.OpType.CREATE) {
                return this.getWriteIndex();
            }
            if (this.getType() != Type.DATA_STREAM) {
                return this.getWriteIndex();
            }
            if (this.dataStream.getIndexMode() != IndexMode.TIME_SERIES) {
                return this.getWriteIndex();
            }
            formatter = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER;
            xContent = request.getContentType().xContent();
            try {
                parser = xContent.createParser(DataStream.TS_EXTRACT_CONFIG, (InputStream)request.source().streamInput());
                try {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.nextToken(), parser);
                    switch (1.$SwitchMap$org$elasticsearch$xcontent$XContentParser$Token[parser.nextToken().ordinal()]) {
                        case 1: {
                            timestamp = DateFormatters.from(formatter.parse(parser.text()), formatter.locale()).toInstant();
                            ** break;
lbl18:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            timestamp = Instant.ofEpochMilli(parser.longValue());
                            ** break;
lbl22:
                            // 1 sources

                            break;
                        }
                        default: {
                            throw new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, "Failed to parse object: expecting token of type [%s] or [%s] but found [%s]", new Object[]{XContentParser.Token.VALUE_STRING, XContentParser.Token.VALUE_NUMBER, parser.currentToken()}), new Object[0]);
                        }
                    }
                }
                finally {
                    if (parser != null) {
                        parser.close();
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error extracting timestamp: " + e.getMessage(), e);
            }
            result = this.dataStream.selectTimeSeriesWriteIndex(timestamp, metadata);
            if (result == null) {
                timestampAsString = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.format(timestamp);
                writeableIndicesString = this.dataStream.getIndices().stream().map((Function<Index, IndexMetadata>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, index(org.elasticsearch.index.Index ), (Lorg/elasticsearch/index/Index;)Lorg/elasticsearch/cluster/metadata/IndexMetadata;)((Metadata)metadata)).map((Function<IndexMetadata, Settings>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getSettings(), (Lorg/elasticsearch/cluster/metadata/IndexMetadata;)Lorg/elasticsearch/common/settings/Settings;)()).map((Function<Settings, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getWriteIndex$0(org.elasticsearch.common.settings.Settings ), (Lorg/elasticsearch/common/settings/Settings;)Ljava/lang/String;)()).collect(Collectors.joining());
                throw new IllegalArgumentException("the document timestamp [" + timestampAsString + "] is outside of ranges of currently writable indices [" + writeableIndicesString + "]");
            }
            return result;
        }

        @Override
        public DataStream getParentDataStream() {
            return null;
        }

        @Override
        public boolean isHidden() {
            return this.dataStream.isHidden();
        }

        @Override
        public boolean isSystem() {
            return this.dataStream.isSystem();
        }

        @Override
        public boolean isDataStreamRelated() {
            return true;
        }

        @Override
        public List<String> getAliases() {
            return this.referencedByDataStreamAliases;
        }

        public org.elasticsearch.cluster.metadata.DataStream getDataStream() {
            return this.dataStream;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataStream that = (DataStream)o;
            return this.dataStream.equals(that.dataStream) && Objects.equals(this.referencedByDataStreamAliases, that.referencedByDataStreamAliases);
        }

        public int hashCode() {
            return Objects.hash(this.dataStream, this.referencedByDataStreamAliases);
        }

        private static /* synthetic */ String lambda$getWriteIndex$0(Settings settings) {
            return "[" + settings.get(IndexSettings.TIME_SERIES_START_TIME.getKey()) + "," + settings.get(IndexSettings.TIME_SERIES_END_TIME.getKey()) + "]";
        }
    }

    public static class Alias
    implements IndexAbstraction {
        private final String aliasName;
        private final List<Index> referenceIndexMetadatas;
        private final Index writeIndex;
        private final boolean isHidden;
        private final boolean isSystem;
        private final boolean dataStreamAlias;

        public Alias(AliasMetadata aliasMetadata, List<IndexMetadata> indices) {
            this.aliasName = aliasMetadata.getAlias();
            this.referenceIndexMetadatas = new ArrayList<Index>(indices.size());
            for (IndexMetadata imd : indices) {
                this.referenceIndexMetadatas.add(imd.getIndex());
            }
            List writeIndices = indices.stream().filter(idxMeta -> Boolean.TRUE.equals(idxMeta.getAliases().get(this.aliasName).writeIndex())).collect(Collectors.toList());
            if (writeIndices.isEmpty() && indices.size() == 1 && indices.get(0).getAliases().get(this.aliasName).writeIndex() == null) {
                writeIndices.add(indices.get(0));
            }
            if (writeIndices.size() == 0) {
                this.writeIndex = null;
            } else if (writeIndices.size() == 1) {
                this.writeIndex = ((IndexMetadata)writeIndices.get(0)).getIndex();
            } else {
                List writeIndicesStrings = writeIndices.stream().map(i -> i.getIndex().getName()).collect(Collectors.toList());
                throw new IllegalStateException("alias [" + this.aliasName + "] has more than one write index [" + Strings.collectionToCommaDelimitedString(writeIndicesStrings) + "]");
            }
            this.isHidden = aliasMetadata.isHidden() == null ? false : aliasMetadata.isHidden();
            this.isSystem = indices.stream().allMatch(IndexMetadata::isSystem);
            this.dataStreamAlias = false;
            this.validateAliasProperties(indices);
        }

        public Alias(DataStreamAlias dataStreamAlias, List<Index> indicesOfAllDataStreams, Index writeIndexOfWriteDataStream) {
            this.aliasName = dataStreamAlias.getName();
            this.referenceIndexMetadatas = indicesOfAllDataStreams;
            this.writeIndex = writeIndexOfWriteDataStream;
            this.isHidden = false;
            this.isSystem = false;
            this.dataStreamAlias = true;
        }

        @Override
        public Type getType() {
            return Type.ALIAS;
        }

        @Override
        public String getName() {
            return this.aliasName;
        }

        @Override
        public List<Index> getIndices() {
            return this.referenceIndexMetadatas;
        }

        @Override
        @Nullable
        public Index getWriteIndex() {
            return this.writeIndex;
        }

        @Override
        public DataStream getParentDataStream() {
            return null;
        }

        @Override
        public boolean isHidden() {
            return this.isHidden;
        }

        @Override
        public boolean isSystem() {
            return this.isSystem;
        }

        @Override
        public boolean isDataStreamRelated() {
            return this.dataStreamAlias;
        }

        @Override
        public List<String> getAliases() {
            return null;
        }

        private void validateAliasProperties(List<IndexMetadata> referenceIndexMetadatas) {
            List newVersionSystemIndices;
            Map<Boolean, List<IndexMetadata>> groupedByHiddenStatus = referenceIndexMetadatas.stream().collect(Collectors.groupingBy(idxMeta -> Boolean.TRUE.equals(idxMeta.getAliases().get(this.aliasName).isHidden())));
            if (this.isNonEmpty(groupedByHiddenStatus.get(true)) && this.isNonEmpty(groupedByHiddenStatus.get(false))) {
                List hiddenOn = groupedByHiddenStatus.get(true).stream().map(idx -> idx.getIndex().getName()).collect(Collectors.toList());
                List nonHiddenOn = groupedByHiddenStatus.get(false).stream().map(idx -> idx.getIndex().getName()).collect(Collectors.toList());
                throw new IllegalStateException("alias [" + this.aliasName + "] has is_hidden set to true on indices [" + Strings.collectionToCommaDelimitedString(hiddenOn) + "] but does not have is_hidden set to true on indices [" + Strings.collectionToCommaDelimitedString(nonHiddenOn) + "]; alias must have the same is_hidden setting on all indices");
            }
            Map<Boolean, List<IndexMetadata>> groupedBySystemStatus = referenceIndexMetadatas.stream().collect(Collectors.groupingBy(IndexMetadata::isSystem));
            if (this.isNonEmpty(groupedBySystemStatus.get(false)) && this.isNonEmpty(groupedBySystemStatus.get(true)) && !(newVersionSystemIndices = groupedBySystemStatus.get(true).stream().filter(i -> i.getCreationVersion().onOrAfter(IndexNameExpressionResolver.SYSTEM_INDEX_ENFORCEMENT_VERSION)).map(i -> i.getIndex().getName()).sorted().collect(Collectors.toList())).isEmpty()) {
                List nonSystemIndices = groupedBySystemStatus.get(false).stream().map(i -> i.getIndex().getName()).sorted().collect(Collectors.toList());
                throw new IllegalStateException("alias [" + this.aliasName + "] refers to both system indices " + newVersionSystemIndices + " and non-system indices: " + nonSystemIndices + ", but aliases must refer to either system or non-system indices, not both");
            }
        }

        private boolean isNonEmpty(List<IndexMetadata> idxMetas) {
            return !(Objects.isNull(idxMetas) || idxMetas.isEmpty());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Alias alias = (Alias)o;
            return this.isHidden == alias.isHidden && this.isSystem == alias.isSystem && this.dataStreamAlias == alias.dataStreamAlias && this.aliasName.equals(alias.aliasName) && this.referenceIndexMetadatas.equals(alias.referenceIndexMetadatas) && Objects.equals(this.writeIndex, alias.writeIndex);
        }

        public int hashCode() {
            return Objects.hash(this.aliasName, this.referenceIndexMetadatas, this.writeIndex, this.isHidden, this.isSystem, this.dataStreamAlias);
        }
    }

    public static class ConcreteIndex
    implements IndexAbstraction {
        private final Index concreteIndexName;
        private final boolean isHidden;
        private final boolean isSystem;
        private final List<String> aliases;
        private final DataStream dataStream;

        public ConcreteIndex(IndexMetadata indexMetadata, DataStream dataStream) {
            this.concreteIndexName = indexMetadata.getIndex();
            this.isHidden = indexMetadata.isHidden();
            this.isSystem = indexMetadata.isSystem();
            this.aliases = indexMetadata.getAliases() != null ? List.of((String[])indexMetadata.getAliases().keys().toArray(String.class)) : null;
            this.dataStream = dataStream;
        }

        public ConcreteIndex(IndexMetadata indexMetadata) {
            this(indexMetadata, null);
        }

        @Override
        public String getName() {
            return this.concreteIndexName.getName();
        }

        @Override
        public Type getType() {
            return Type.CONCRETE_INDEX;
        }

        @Override
        public List<Index> getIndices() {
            return List.of(this.concreteIndexName);
        }

        @Override
        public Index getWriteIndex() {
            return this.concreteIndexName;
        }

        @Override
        public DataStream getParentDataStream() {
            return this.dataStream;
        }

        @Override
        public boolean isHidden() {
            return this.isHidden;
        }

        @Override
        public boolean isSystem() {
            return this.isSystem;
        }

        @Override
        public List<String> getAliases() {
            return this.aliases;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConcreteIndex that = (ConcreteIndex)o;
            return this.isHidden == that.isHidden && this.isSystem == that.isSystem && this.concreteIndexName.equals(that.concreteIndexName) && Objects.equals(this.aliases, that.aliases) && Objects.equals(this.dataStream, that.dataStream);
        }

        public int hashCode() {
            return Objects.hash(this.concreteIndexName, this.isHidden, this.isSystem, this.aliases, this.dataStream);
        }
    }

    public static enum Type {
        CONCRETE_INDEX("concrete index"),
        ALIAS("alias"),
        DATA_STREAM("data_stream");

        private final String displayName;

        private Type(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

