/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.cluster.metadata.DesiredNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.node.Node;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record DesiredNodes(String historyID, long version, List<DesiredNode> nodes) implements Writeable,
ToXContentObject
{
    private static final ParseField HISTORY_ID_FIELD = new ParseField("history_id", new String[0]);
    private static final ParseField VERSION_FIELD = new ParseField("version", new String[0]);
    private static final ParseField NODES_FIELD = new ParseField("nodes", new String[0]);
    public static final ConstructingObjectParser<DesiredNodes, Void> PARSER = new ConstructingObjectParser("desired_nodes", false, (args, unused) -> new DesiredNodes((String)args[0], (Long)args[1], (List)args[2]));

    public DesiredNodes {
        assert (historyID != null && !historyID.isBlank());
        assert (version != Long.MIN_VALUE);
        DesiredNodes.checkForDuplicatedExternalIDs(nodes);
    }

    public DesiredNodes(StreamInput in) throws IOException {
        this(in.readString(), in.readLong(), in.readList(DesiredNode::new));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.historyID);
        out.writeLong(this.version);
        out.writeList(this.nodes);
    }

    static DesiredNodes fromXContent(XContentParser parser) throws IOException {
        return (DesiredNodes)PARSER.parse(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(HISTORY_ID_FIELD.getPreferredName(), this.historyID);
        builder.field(VERSION_FIELD.getPreferredName(), this.version);
        builder.xContentList(NODES_FIELD.getPreferredName(), this.nodes);
        builder.endObject();
        return builder;
    }

    public boolean isSupersededBy(DesiredNodes otherDesiredNodes) {
        return !this.historyID.equals(otherDesiredNodes.historyID) || this.version < otherDesiredNodes.version;
    }

    public boolean hasSameVersion(DesiredNodes other) {
        return this.historyID.equals(other.historyID) && this.version == other.version;
    }

    public boolean hasSameHistoryId(DesiredNodes other) {
        return this.historyID.equals(other.historyID);
    }

    private static void checkForDuplicatedExternalIDs(List<DesiredNode> nodes) {
        HashSet<String> nodeIDs = new HashSet<String>(nodes.size());
        HashSet<String> duplicatedIDs = new HashSet<String>();
        for (DesiredNode node : nodes) {
            String externalID = node.externalId();
            if (externalID == null || nodeIDs.add(externalID)) continue;
            duplicatedIDs.add(externalID);
        }
        if (!duplicatedIDs.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Some nodes contain the same setting value %s for [%s]", duplicatedIDs, Node.NODE_EXTERNAL_ID_SETTING.getKey()));
        }
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), HISTORY_ID_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), VERSION_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> DesiredNode.fromXContent(p), NODES_FIELD);
    }
}

