/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeRoleSettings;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record DesiredNode(Settings settings, int processors, ByteSizeValue memory, ByteSizeValue storage, Version version) implements Writeable,
ToXContentObject
{
    private static final ParseField SETTINGS_FIELD = new ParseField("settings", new String[0]);
    private static final ParseField PROCESSORS_FIELD = new ParseField("processors", new String[0]);
    private static final ParseField MEMORY_FIELD = new ParseField("memory", new String[0]);
    private static final ParseField STORAGE_FIELD = new ParseField("storage", new String[0]);
    private static final ParseField VERSION_FIELD = new ParseField("node_version", new String[0]);
    public static final ConstructingObjectParser<DesiredNode, String> PARSER = new ConstructingObjectParser("desired_node", false, (args, name) -> new DesiredNode((Settings)args[0], (Integer)args[1], (ByteSizeValue)args[2], (ByteSizeValue)args[3], (Version)args[4]));

    public DesiredNode {
        assert (memory != null);
        assert (storage != null);
        assert (version != null);
        if (processors <= 0) {
            throw new IllegalArgumentException("processors must be greater than 0, but got " + processors);
        }
    }

    public DesiredNode(StreamInput in) throws IOException {
        this(Settings.readSettingsFromStream(in), in.readInt(), new ByteSizeValue(in), new ByteSizeValue(in), Version.readVersion(in));
    }

    private static Version parseVersion(String version) {
        if (version == null || version.isBlank()) {
            throw new IllegalArgumentException(VERSION_FIELD.getPreferredName() + " must not be empty");
        }
        return Version.fromString(version);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        Settings.writeSettingsToStream(this.settings, out);
        out.writeInt(this.processors);
        this.memory.writeTo(out);
        this.storage.writeTo(out);
        Version.writeVersion(this.version, out);
    }

    public static DesiredNode fromXContent(XContentParser parser) throws IOException {
        return (DesiredNode)PARSER.parse(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(SETTINGS_FIELD.getPreferredName());
        this.settings.toXContent(builder, params);
        builder.endObject();
        builder.field(PROCESSORS_FIELD.getPreferredName(), this.processors);
        builder.field(MEMORY_FIELD.getPreferredName(), (ToXContent)this.memory);
        builder.field(STORAGE_FIELD.getPreferredName(), (ToXContent)this.storage);
        builder.field(VERSION_FIELD.getPreferredName(), (ToXContent)this.version);
        builder.endObject();
        return builder;
    }

    public String externalId() {
        String externalId = Node.NODE_EXTERNAL_ID_SETTING.get(this.settings);
        return externalId.isBlank() ? null : externalId;
    }

    public boolean hasMasterRole() {
        return NodeRoleSettings.NODE_ROLES_SETTING.get(this.settings).contains(DiscoveryNodeRole.MASTER_ROLE);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Settings.fromXContent(p), SETTINGS_FIELD);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), PROCESSORS_FIELD);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), MEMORY_FIELD.getPreferredName()), MEMORY_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), STORAGE_FIELD.getPreferredName()), STORAGE_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> DesiredNode.parseVersion(p.text()), VERSION_FIELD, ObjectParser.ValueType.STRING);
    }
}

