/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.desirednodes;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.DesiredNode;
import org.elasticsearch.cluster.metadata.DesiredNodes;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.node.Node;

public class DesiredNodesSettingsValidator {
    private final ClusterSettings clusterSettings;

    public DesiredNodesSettingsValidator(ClusterSettings clusterSettings) {
        this.clusterSettings = clusterSettings;
    }

    public void validate(DesiredNodes desiredNodes) {
        ArrayList<DesiredNodeValidationError> validationErrors = new ArrayList<DesiredNodeValidationError>();
        List<DesiredNode> nodes = desiredNodes.nodes();
        for (int i2 = 0; i2 < nodes.size(); ++i2) {
            DesiredNode node = nodes.get(i2);
            try {
                this.validate(node);
                continue;
            }
            catch (IllegalArgumentException e) {
                validationErrors.add(new DesiredNodeValidationError(i2, node.externalId(), e));
            }
        }
        if (!validationErrors.isEmpty()) {
            String nodeIndicesWithFailures = validationErrors.stream().map(DesiredNodeValidationError::position).map(i -> Integer.toString(i)).collect(Collectors.joining(","));
            String nodeIdsWithFailures = validationErrors.stream().map(DesiredNodeValidationError::externalId).collect(Collectors.joining(","));
            IllegalArgumentException invalidSettingsException = new IllegalArgumentException(String.format(Locale.ROOT, "Nodes with ids [%s] in positions [%s] contain invalid settings", nodeIdsWithFailures, nodeIndicesWithFailures));
            for (DesiredNodeValidationError exceptionTuple : validationErrors) {
                invalidSettingsException.addSuppressed(exceptionTuple.exception);
            }
            throw invalidSettingsException;
        }
    }

    private void validate(DesiredNode node) {
        if (node.version().before(Version.CURRENT)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Illegal node version [%s]. Only [%s] or newer versions are supported", node.version(), Version.CURRENT));
        }
        if (node.externalId() == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] or [%s] is missing or empty", Node.NODE_NAME_SETTING.getKey(), Node.NODE_EXTERNAL_ID_SETTING.getKey()));
        }
        if (node.version().after(Version.CURRENT)) {
            return;
        }
        Settings settings = node.settings();
        if (settings.hasValue(EsExecutors.NODE_PROCESSORS_SETTING.getKey())) {
            Setting.intSetting(EsExecutors.NODE_PROCESSORS_SETTING.getKey(), node.processors(), 1, node.processors(), Setting.Property.NodeScope).get(settings);
            Settings.Builder updatedSettings = Settings.builder().put(settings);
            updatedSettings.remove(EsExecutors.NODE_PROCESSORS_SETTING.getKey());
            settings = updatedSettings.build();
        }
        this.clusterSettings.validate(settings, true);
    }

    private record DesiredNodeValidationError(int position, @Nullable String externalId, RuntimeException exception) {
        @Nullable
        private final String externalId;

        public String externalId() {
            return this.externalId == null ? "<missing>" : this.externalId;
        }
    }
}

