/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;

public class NodeRemovalClusterStateTaskExecutor
implements ClusterStateTaskExecutor<Task> {
    private static final Logger logger = LogManager.getLogger(NodeRemovalClusterStateTaskExecutor.class);
    private final AllocationService allocationService;

    public NodeRemovalClusterStateTaskExecutor(AllocationService allocationService) {
        this.allocationService = allocationService;
    }

    @Override
    public ClusterStateTaskExecutor.ClusterTasksResult<Task> execute(ClusterState currentState, List<Task> tasks) throws Exception {
        DiscoveryNodes.Builder remainingNodesBuilder = DiscoveryNodes.builder(currentState.nodes());
        boolean removed = false;
        for (Task task : tasks) {
            if (currentState.nodes().nodeExists(task.node())) {
                remainingNodesBuilder.remove(task.node());
                removed = true;
                continue;
            }
            logger.debug("node [{}] does not exist in cluster state, ignoring", (Object)task);
        }
        if (!removed) {
            return ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks).build(currentState);
        }
        ClusterState remainingNodesClusterState = this.remainingNodesClusterState(currentState, remainingNodesBuilder);
        ClusterState ptasksDisassociatedState = PersistentTasksCustomMetadata.disassociateDeadNodes(remainingNodesClusterState);
        ClusterState finalState = this.allocationService.disassociateDeadNodes(ptasksDisassociatedState, true, this.describeTasks(tasks));
        return ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks).build(finalState);
    }

    protected ClusterState remainingNodesClusterState(ClusterState currentState, DiscoveryNodes.Builder remainingNodesBuilder) {
        return ClusterState.builder(currentState).nodes(remainingNodesBuilder).build();
    }

    public record Task(DiscoveryNode node, String reason, Runnable onClusterStateProcessed) implements ClusterStateTaskListener
    {
        @Override
        public void onFailure(Exception e) {
            logger.error("unexpected failure during [node-left]", (Throwable)e);
        }

        @Override
        public void onNoLongerMaster() {
            logger.debug("no longer master while processing node removal [node-left]");
        }

        @Override
        public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
            this.onClusterStateProcessed.run();
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.node.appendDescriptionWithoutAttributes(stringBuilder);
            stringBuilder.append(" reason: ").append(this.reason);
            return stringBuilder.toString();
        }
    }
}

