/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.action.shard;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ResultDeduplicator;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ClusterStatePublicationEvent;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.MasterNodeChangePredicate;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.FailedShard;
import org.elasticsearch.cluster.routing.allocation.StaleShard;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.IndexLongFieldRange;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardLongFieldRange;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class ShardStateAction {
    private static final Logger logger = LogManager.getLogger(ShardStateAction.class);
    public static final String SHARD_STARTED_ACTION_NAME = "internal:cluster/shard/started";
    public static final String SHARD_FAILED_ACTION_NAME = "internal:cluster/shard/failure";
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final ResultDeduplicator<TransportRequest, Void> remoteShardStateUpdateDeduplicator;
    private static final Class<?>[] MASTER_CHANNEL_EXCEPTIONS = new Class[]{NotMasterException.class, ConnectTransportException.class, FailedToCommitClusterStateException.class};

    @Inject
    public ShardStateAction(ClusterService clusterService, TransportService transportService, AllocationService allocationService, RerouteService rerouteService, ThreadPool threadPool) {
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.remoteShardStateUpdateDeduplicator = new ResultDeduplicator(threadPool.getThreadContext());
        transportService.registerRequestHandler(SHARD_STARTED_ACTION_NAME, "same", StartedShardEntry::new, new ShardStartedTransportHandler(clusterService, new ShardStartedClusterStateTaskExecutor(allocationService, rerouteService)));
        transportService.registerRequestHandler(SHARD_FAILED_ACTION_NAME, "same", FailedShardEntry::new, new ShardFailedTransportHandler(clusterService, new ShardFailedClusterStateTaskExecutor(allocationService, rerouteService)));
    }

    private void sendShardAction(final String actionName, ClusterState currentState, final TransportRequest request, final ActionListener<Void> listener) {
        final ClusterStateObserver observer = new ClusterStateObserver(currentState, this.clusterService, null, logger, this.threadPool.getThreadContext());
        final DiscoveryNode masterNode = currentState.nodes().getMasterNode();
        final Predicate<ClusterState> changePredicate = MasterNodeChangePredicate.build(currentState);
        if (masterNode == null) {
            logger.warn("no master known for action [{}] for shard entry [{}]", (Object)actionName, (Object)request);
            this.waitForNewMasterAndRetry(actionName, observer, request, listener, changePredicate);
        } else {
            logger.debug("sending [{}] to [{}] for shard entry [{}]", (Object)actionName, (Object)masterNode.getId(), (Object)request);
            this.transportService.sendRequest(masterNode, actionName, request, new EmptyTransportResponseHandler("same"){

                @Override
                public void handleResponse(TransportResponse.Empty response) {
                    listener.onResponse(null);
                }

                @Override
                public void handleException(TransportException exp) {
                    if (ShardStateAction.isMasterChannelException(exp)) {
                        ShardStateAction.this.waitForNewMasterAndRetry(actionName, observer, request, listener, changePredicate);
                    } else {
                        logger.warn((Message)new ParameterizedMessage("unexpected failure while sending request [{}] to [{}] for shard entry [{}]", new Object[]{actionName, masterNode, request}), (Throwable)exp);
                        listener.onFailure(exp instanceof RemoteTransportException ? (Exception)(exp.getCause() instanceof Exception ? exp.getCause() : new ElasticsearchException(exp.getCause())) : exp);
                    }
                }
            });
        }
    }

    private static boolean isMasterChannelException(TransportException exp) {
        return ExceptionsHelper.unwrap(exp, MASTER_CHANNEL_EXCEPTIONS) != null;
    }

    public void remoteShardFailed(ShardId shardId, String allocationId, long primaryTerm, boolean markAsStale, String message, @Nullable Exception failure, ActionListener<Void> listener) {
        assert (primaryTerm > 0L) : "primary term should be strictly positive";
        this.remoteShardStateUpdateDeduplicator.executeOnce(new FailedShardEntry(shardId, allocationId, primaryTerm, message, failure, markAsStale), listener, (req, reqListener) -> this.sendShardAction(SHARD_FAILED_ACTION_NAME, this.clusterService.state(), (TransportRequest)req, (ActionListener<Void>)reqListener));
    }

    int remoteShardRequestsInFlight() {
        return this.remoteShardStateUpdateDeduplicator.size();
    }

    public void clearRemoteShardRequestDeduplicator() {
        this.remoteShardStateUpdateDeduplicator.clear();
    }

    public void localShardFailed(ShardRouting shardRouting, String message, @Nullable Exception failure, ActionListener<Void> listener) {
        this.localShardFailed(shardRouting, message, failure, listener, this.clusterService.state());
    }

    public void localShardFailed(ShardRouting shardRouting, String message, @Nullable Exception failure, ActionListener<Void> listener, ClusterState currentState) {
        FailedShardEntry shardEntry = new FailedShardEntry(shardRouting.shardId(), shardRouting.allocationId().getId(), 0L, message, failure, true);
        this.sendShardAction(SHARD_FAILED_ACTION_NAME, currentState, shardEntry, listener);
    }

    protected void waitForNewMasterAndRetry(final String actionName, ClusterStateObserver observer, final TransportRequest request, final ActionListener<Void> listener, Predicate<ClusterState> changePredicate) {
        observer.waitForNextChange(new ClusterStateObserver.Listener(){

            @Override
            public void onNewClusterState(ClusterState state) {
                if (logger.isTraceEnabled()) {
                    logger.trace("new cluster state [{}] after waiting for master election for shard entry [{}]", (Object)state, (Object)request);
                }
                ShardStateAction.this.sendShardAction(actionName, state, request, listener);
            }

            @Override
            public void onClusterServiceClose() {
                logger.warn("node closed while execution action [{}] for shard entry [{}]", (Object)actionName, (Object)request);
                listener.onFailure(new NodeClosedException(ShardStateAction.this.clusterService.localNode()));
            }

            @Override
            public void onTimeout(TimeValue timeout) {
                assert (false);
            }
        }, changePredicate);
    }

    public void shardStarted(ShardRouting shardRouting, long primaryTerm, String message, ShardLongFieldRange timestampRange, ActionListener<Void> listener) {
        this.shardStarted(shardRouting, primaryTerm, message, timestampRange, listener, this.clusterService.state());
    }

    public void shardStarted(ShardRouting shardRouting, long primaryTerm, String message, ShardLongFieldRange timestampRange, ActionListener<Void> listener, ClusterState currentState) {
        this.remoteShardStateUpdateDeduplicator.executeOnce(new StartedShardEntry(shardRouting.shardId(), shardRouting.allocationId().getId(), primaryTerm, message, timestampRange), listener, (req, l) -> this.sendShardAction(SHARD_STARTED_ACTION_NAME, currentState, (TransportRequest)req, (ActionListener<Void>)l));
    }

    private static class ShardStartedTransportHandler
    implements TransportRequestHandler<StartedShardEntry> {
        private final ClusterService clusterService;
        private final ShardStartedClusterStateTaskExecutor shardStartedClusterStateTaskExecutor;

        ShardStartedTransportHandler(ClusterService clusterService, ShardStartedClusterStateTaskExecutor shardStartedClusterStateTaskExecutor) {
            this.clusterService = clusterService;
            this.shardStartedClusterStateTaskExecutor = shardStartedClusterStateTaskExecutor;
        }

        @Override
        public void messageReceived(StartedShardEntry request, TransportChannel channel, Task task) throws Exception {
            logger.debug("{} received shard started for [{}]", (Object)request.shardId, (Object)request);
            ChannelActionListener listener = new ChannelActionListener(channel, ShardStateAction.SHARD_STARTED_ACTION_NAME, request);
            StartedShardUpdateTask update = new StartedShardUpdateTask(request, listener);
            this.clusterService.submitStateUpdateTask("shard-started " + request, update, ClusterStateTaskConfig.build(Priority.URGENT), this.shardStartedClusterStateTaskExecutor);
        }
    }

    public static class ShardStartedClusterStateTaskExecutor
    implements ClusterStateTaskExecutor<StartedShardUpdateTask> {
        private final AllocationService allocationService;
        private final RerouteService rerouteService;

        public ShardStartedClusterStateTaskExecutor(AllocationService allocationService, RerouteService rerouteService) {
            this.allocationService = allocationService;
            this.rerouteService = rerouteService;
        }

        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<StartedShardUpdateTask> execute(ClusterState currentState, List<StartedShardUpdateTask> tasks) throws Exception {
            ClusterStateTaskExecutor.ClusterTasksResult.Builder<StartedShardUpdateTask> builder = ClusterStateTaskExecutor.ClusterTasksResult.builder();
            ArrayList<StartedShardUpdateTask> tasksToBeApplied = new ArrayList<StartedShardUpdateTask>();
            ArrayList<ShardRouting> shardRoutingsToBeApplied = new ArrayList<ShardRouting>(tasks.size());
            HashSet<ShardRouting> seenShardRoutings = new HashSet<ShardRouting>();
            HashMap<Index, IndexLongFieldRange> updatedTimestampRanges = new HashMap<Index, IndexLongFieldRange>();
            for (StartedShardUpdateTask task : tasks) {
                IndexLongFieldRange newTimestampMillisRange;
                StartedShardEntry entry = task.getEntry();
                ShardRouting matched = currentState.getRoutingTable().getByAllocationId(entry.shardId, entry.allocationId);
                if (matched == null) {
                    logger.debug("{} ignoring shard started task [{}] (shard does not exist anymore)", (Object)entry.shardId, (Object)entry);
                    builder.success(task);
                    continue;
                }
                if (matched.primary() && entry.primaryTerm > 0L) {
                    IndexMetadata indexMetadata = currentState.metadata().index(entry.shardId.getIndex());
                    assert (indexMetadata != null);
                    long currentPrimaryTerm = indexMetadata.primaryTerm(entry.shardId.id());
                    if (currentPrimaryTerm != entry.primaryTerm) {
                        assert (currentPrimaryTerm > entry.primaryTerm) : "received a primary term with a higher term than in the current cluster state (received [" + entry.primaryTerm + "] but current is [" + currentPrimaryTerm + "])";
                        logger.debug("{} ignoring shard started task [{}] (primary term {} does not match current term {})", (Object)entry.shardId, (Object)entry, (Object)entry.primaryTerm, (Object)currentPrimaryTerm);
                        builder.success(task);
                        continue;
                    }
                }
                if (!matched.initializing()) {
                    assert (matched.active()) : "expected active shard routing for task " + entry + " but found " + matched;
                    logger.debug("{} ignoring shard started task [{}] (shard exists but is not initializing: {})", (Object)entry.shardId, (Object)entry, (Object)matched);
                    builder.success(task);
                    continue;
                }
                if (seenShardRoutings.contains(matched)) {
                    logger.trace("{} ignoring shard started task [{}] (already scheduled to start {})", (Object)entry.shardId, (Object)entry, (Object)matched);
                    tasksToBeApplied.add(task);
                    continue;
                }
                logger.debug("{} starting shard {} (shard started task: [{}])", (Object)entry.shardId, (Object)matched, (Object)entry);
                tasksToBeApplied.add(task);
                shardRoutingsToBeApplied.add(matched);
                seenShardRoutings.add(matched);
                Index index = entry.shardId.getIndex();
                IndexLongFieldRange currentTimestampMillisRange = (IndexLongFieldRange)updatedTimestampRanges.get(index);
                IndexMetadata indexMetadata = currentState.metadata().index(index);
                if (currentTimestampMillisRange == null) {
                    currentTimestampMillisRange = indexMetadata.getTimestampRange();
                }
                if ((newTimestampMillisRange = currentTimestampMillisRange.extendWithShardRange(entry.shardId.id(), indexMetadata.getNumberOfShards(), entry.timestampRange)) == currentTimestampMillisRange) continue;
                updatedTimestampRanges.put(index, newTimestampMillisRange);
            }
            assert (tasksToBeApplied.size() >= shardRoutingsToBeApplied.size());
            ClusterState maybeUpdatedState = currentState;
            try {
                maybeUpdatedState = this.allocationService.applyStartedShards(currentState, shardRoutingsToBeApplied);
                if (!updatedTimestampRanges.isEmpty()) {
                    Metadata.Builder metadataBuilder = Metadata.builder(maybeUpdatedState.metadata());
                    for (Map.Entry updatedTimestampRangeEntry : updatedTimestampRanges.entrySet()) {
                        metadataBuilder.put(IndexMetadata.builder(metadataBuilder.getSafe((Index)updatedTimestampRangeEntry.getKey())).timestampRange((IndexLongFieldRange)updatedTimestampRangeEntry.getValue()));
                    }
                    maybeUpdatedState = ClusterState.builder(maybeUpdatedState).metadata(metadataBuilder).build();
                }
                assert (ShardStartedClusterStateTaskExecutor.assertStartedIndicesHaveCompleteTimestampRanges(maybeUpdatedState));
                builder.successes(tasksToBeApplied);
            }
            catch (Exception e) {
                logger.warn(() -> new ParameterizedMessage("failed to apply started shards {}", (Object)shardRoutingsToBeApplied), (Throwable)e);
                builder.failures(tasksToBeApplied, e);
            }
            return builder.build(maybeUpdatedState);
        }

        private static boolean assertStartedIndicesHaveCompleteTimestampRanges(ClusterState clusterState) {
            for (Map.Entry<String, IndexRoutingTable> cursor : clusterState.getRoutingTable().getIndicesRouting().entrySet()) {
                assert (!cursor.getValue().allPrimaryShardsActive() || clusterState.metadata().index(cursor.getKey()).getTimestampRange().isComplete()) : "index [" + cursor.getKey() + "] should have complete timestamp range, but got " + clusterState.metadata().index(cursor.getKey()).getTimestampRange() + " for " + cursor.getValue().prettyPrint();
            }
            return true;
        }

        @Override
        public void clusterStatePublished(ClusterStatePublicationEvent clusterStatePublicationEvent) {
            this.rerouteService.reroute("reroute after starting shards", Priority.NORMAL, ActionListener.wrap(r -> logger.trace("reroute after starting shards succeeded"), e -> logger.debug("reroute after starting shards failed", (Throwable)e)));
        }
    }

    private static class ShardFailedTransportHandler
    implements TransportRequestHandler<FailedShardEntry> {
        private final ClusterService clusterService;
        private final ShardFailedClusterStateTaskExecutor shardFailedClusterStateTaskExecutor;
        private static final String TASK_SOURCE = "shard-failed";

        ShardFailedTransportHandler(ClusterService clusterService, ShardFailedClusterStateTaskExecutor shardFailedClusterStateTaskExecutor) {
            this.clusterService = clusterService;
            this.shardFailedClusterStateTaskExecutor = shardFailedClusterStateTaskExecutor;
        }

        @Override
        public void messageReceived(FailedShardEntry request, TransportChannel channel, Task task) throws Exception {
            logger.debug(() -> new ParameterizedMessage("{} received shard failed for [{}]", (Object)request.getShardId(), (Object)request), (Throwable)request.failure);
            FailedShardUpdateTask update = new FailedShardUpdateTask(request, new ChannelActionListener(channel, TASK_SOURCE, request));
            this.clusterService.submitStateUpdateTask(TASK_SOURCE, update, ClusterStateTaskConfig.build(Priority.HIGH), this.shardFailedClusterStateTaskExecutor);
        }
    }

    public static class ShardFailedClusterStateTaskExecutor
    implements ClusterStateTaskExecutor<FailedShardUpdateTask> {
        private final AllocationService allocationService;
        private final RerouteService rerouteService;

        public ShardFailedClusterStateTaskExecutor(AllocationService allocationService, RerouteService rerouteService) {
            this.allocationService = allocationService;
            this.rerouteService = rerouteService;
        }

        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<FailedShardUpdateTask> execute(ClusterState currentState, List<FailedShardUpdateTask> tasks) throws Exception {
            ClusterStateTaskExecutor.ClusterTasksResult.Builder<FailedShardUpdateTask> batchResultBuilder = ClusterStateTaskExecutor.ClusterTasksResult.builder();
            ArrayList<FailedShardUpdateTask> tasksToBeApplied = new ArrayList<FailedShardUpdateTask>();
            ArrayList<FailedShard> failedShardsToBeApplied = new ArrayList<FailedShard>();
            ArrayList<StaleShard> staleShardsToBeApplied = new ArrayList<StaleShard>();
            for (FailedShardUpdateTask task : tasks) {
                long currentPrimaryTerm;
                FailedShardEntry entry = task.entry();
                IndexMetadata indexMetadata = currentState.metadata().index(entry.getShardId().getIndex());
                if (indexMetadata == null) {
                    logger.debug("{} ignoring shard failed task [{}] (unknown index {})", (Object)entry.getShardId(), (Object)entry, (Object)entry.getShardId().getIndex());
                    batchResultBuilder.success(task);
                    continue;
                }
                if (entry.primaryTerm > 0L && (currentPrimaryTerm = indexMetadata.primaryTerm(entry.getShardId().id())) != entry.primaryTerm) {
                    assert (currentPrimaryTerm > entry.primaryTerm) : "received a primary term with a higher term than in the current cluster state (received [" + entry.primaryTerm + "] but current is [" + currentPrimaryTerm + "])";
                    logger.debug("{} failing shard failed task [{}] (primary term {} does not match current term {})", (Object)entry.getShardId(), (Object)entry, (Object)entry.primaryTerm, (Object)indexMetadata.primaryTerm(entry.getShardId().id()));
                    batchResultBuilder.failure(task, new NoLongerPrimaryShardException(entry.getShardId(), "primary term [" + entry.primaryTerm + "] did not match current primary term [" + currentPrimaryTerm + "]"));
                    continue;
                }
                ShardRouting matched = currentState.getRoutingTable().getByAllocationId(entry.getShardId(), entry.getAllocationId());
                if (matched == null) {
                    Set<String> inSyncAllocationIds = indexMetadata.inSyncAllocationIds(entry.getShardId().id());
                    if (entry.primaryTerm > 0L && inSyncAllocationIds.contains(entry.getAllocationId())) {
                        logger.debug("{} marking shard {} as stale (shard failed task: [{}])", (Object)entry.getShardId(), (Object)entry.getAllocationId(), (Object)entry);
                        tasksToBeApplied.add(task);
                        staleShardsToBeApplied.add(new StaleShard(entry.getShardId(), entry.getAllocationId()));
                        continue;
                    }
                    logger.debug("{} ignoring shard failed task [{}] (shard does not exist anymore)", (Object)entry.getShardId(), (Object)entry);
                    batchResultBuilder.success(task);
                    continue;
                }
                logger.debug("{} failing shard {} (shard failed task: [{}])", (Object)entry.getShardId(), (Object)matched, (Object)task);
                tasksToBeApplied.add(task);
                failedShardsToBeApplied.add(new FailedShard(matched, entry.message, entry.failure, entry.markAsStale));
            }
            assert (tasksToBeApplied.size() == failedShardsToBeApplied.size() + staleShardsToBeApplied.size());
            ClusterState maybeUpdatedState = currentState;
            try {
                maybeUpdatedState = this.applyFailedShards(currentState, failedShardsToBeApplied, staleShardsToBeApplied);
                batchResultBuilder.successes(tasksToBeApplied);
            }
            catch (Exception e) {
                logger.warn(() -> new ParameterizedMessage("failed to apply failed shards {}", (Object)failedShardsToBeApplied), (Throwable)e);
                batchResultBuilder.failures(tasksToBeApplied, e);
            }
            return batchResultBuilder.build(maybeUpdatedState);
        }

        ClusterState applyFailedShards(ClusterState currentState, List<FailedShard> failedShards, List<StaleShard> staleShards) {
            return this.allocationService.applyFailedShards(currentState, failedShards, staleShards);
        }

        @Override
        public void clusterStatePublished(ClusterStatePublicationEvent clusterStatePublicationEvent) {
            int numberOfUnassignedShards = clusterStatePublicationEvent.getNewState().getRoutingNodes().unassigned().size();
            if (numberOfUnassignedShards > 0) {
                String reason = String.format(Locale.ROOT, "[%d] unassigned shards after failing shards", numberOfUnassignedShards);
                logger.trace("{}, scheduling a reroute", (Object)reason);
                this.rerouteService.reroute(reason, Priority.NORMAL, ActionListener.wrap(r -> logger.trace("{}, reroute completed", (Object)reason), e -> logger.debug((Message)new ParameterizedMessage("{}, reroute failed", (Object)reason), (Throwable)e)));
            }
        }
    }

    public static class FailedShardEntry
    extends TransportRequest {
        final ShardId shardId;
        final String allocationId;
        final long primaryTerm;
        final String message;
        @Nullable
        final Exception failure;
        final boolean markAsStale;

        FailedShardEntry(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.allocationId = in.readString();
            this.primaryTerm = in.readVLong();
            this.message = in.readString();
            this.failure = in.readException();
            this.markAsStale = in.readBoolean();
        }

        public FailedShardEntry(ShardId shardId, String allocationId, long primaryTerm, String message, @Nullable Exception failure, boolean markAsStale) {
            this.shardId = shardId;
            this.allocationId = allocationId;
            this.primaryTerm = primaryTerm;
            this.message = message;
            this.failure = failure;
            this.markAsStale = markAsStale;
        }

        public ShardId getShardId() {
            return this.shardId;
        }

        public String getAllocationId() {
            return this.allocationId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            out.writeString(this.allocationId);
            out.writeVLong(this.primaryTerm);
            out.writeString(this.message);
            out.writeException(this.failure);
            out.writeBoolean(this.markAsStale);
        }

        @Override
        public String toString() {
            ArrayList<CallSite> components = new ArrayList<CallSite>(6);
            components.add((CallSite)((Object)("shard id [" + this.shardId + "]")));
            components.add((CallSite)((Object)("allocation id [" + this.allocationId + "]")));
            components.add((CallSite)((Object)("primary term [" + this.primaryTerm + "]")));
            components.add((CallSite)((Object)("message [" + this.message + "]")));
            components.add((CallSite)((Object)("markAsStale [" + this.markAsStale + "]")));
            if (this.failure != null) {
                components.add((CallSite)((Object)("failure [" + ExceptionsHelper.stackTrace(this.failure) + "]")));
            }
            return String.join((CharSequence)", ", components);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FailedShardEntry that = (FailedShardEntry)o;
            return Objects.equals(this.shardId, that.shardId) && Objects.equals(this.allocationId, that.allocationId) && this.primaryTerm == that.primaryTerm && this.markAsStale == that.markAsStale;
        }

        public int hashCode() {
            return Objects.hash(this.shardId, this.allocationId, this.primaryTerm, this.markAsStale);
        }
    }

    public static class StartedShardEntry
    extends TransportRequest {
        final ShardId shardId;
        final String allocationId;
        final long primaryTerm;
        final String message;
        final ShardLongFieldRange timestampRange;

        StartedShardEntry(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.allocationId = in.readString();
            this.primaryTerm = in.readVLong();
            this.message = in.readString();
            this.timestampRange = ShardLongFieldRange.readFrom(in);
        }

        public StartedShardEntry(ShardId shardId, String allocationId, long primaryTerm, String message, ShardLongFieldRange timestampRange) {
            this.shardId = shardId;
            this.allocationId = allocationId;
            this.primaryTerm = primaryTerm;
            this.message = message;
            this.timestampRange = timestampRange;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            out.writeString(this.allocationId);
            out.writeVLong(this.primaryTerm);
            out.writeString(this.message);
            this.timestampRange.writeTo(out);
        }

        @Override
        public String toString() {
            return String.format(Locale.ROOT, "StartedShardEntry{shardId [%s], allocationId [%s], primary term [%d], message [%s]}", this.shardId, this.allocationId, this.primaryTerm, this.message);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StartedShardEntry that = (StartedShardEntry)o;
            return this.primaryTerm == that.primaryTerm && this.shardId.equals(that.shardId) && this.allocationId.equals(that.allocationId) && this.message.equals(that.message) && this.timestampRange.equals(that.timestampRange);
        }

        public int hashCode() {
            return Objects.hash(this.shardId, this.allocationId, this.primaryTerm, this.message, this.timestampRange);
        }
    }

    public static class NoLongerPrimaryShardException
    extends ElasticsearchException {
        public NoLongerPrimaryShardException(ShardId shardId, String msg) {
            super(msg, new Object[0]);
            this.setShard(shardId);
        }

        public NoLongerPrimaryShardException(StreamInput in) throws IOException {
            super(in);
        }
    }

    public static class StartedShardUpdateTask
    implements ClusterStateTaskListener {
        private final StartedShardEntry entry;
        private final ActionListener<TransportResponse.Empty> listener;

        public StartedShardUpdateTask(StartedShardEntry entry, ActionListener<TransportResponse.Empty> listener) {
            this.entry = entry;
            this.listener = listener;
        }

        public StartedShardEntry getEntry() {
            return this.entry;
        }

        @Override
        public void onFailure(Exception e) {
            if (e instanceof NotMasterException) {
                logger.debug(() -> new ParameterizedMessage("{} no longer master while starting shard [{}]", (Object)this.entry.shardId, (Object)this.entry));
            } else if (e instanceof FailedToCommitClusterStateException) {
                logger.debug(() -> new ParameterizedMessage("{} unexpected failure while starting shard [{}]", (Object)this.entry.shardId, (Object)this.entry), (Throwable)e);
            } else {
                logger.error(() -> new ParameterizedMessage("{} unexpected failure while starting shard [{}]", (Object)this.entry.shardId, (Object)this.entry), (Throwable)e);
            }
            this.listener.onFailure(e);
        }

        @Override
        public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
            this.listener.onResponse(TransportResponse.Empty.INSTANCE);
        }

        public String toString() {
            return "StartedShardUpdateTask{entry=" + this.entry + ", listener=" + this.listener + "}";
        }
    }

    public record FailedShardUpdateTask(FailedShardEntry entry, ActionListener<TransportResponse.Empty> listener) implements ClusterStateTaskListener
    {
        @Override
        public void onFailure(Exception e) {
            if (e instanceof NotMasterException) {
                logger.debug(() -> new ParameterizedMessage("{} no longer master while failing shard [{}]", (Object)this.entry.shardId, (Object)this.entry));
            } else if (e instanceof FailedToCommitClusterStateException) {
                logger.debug(() -> new ParameterizedMessage("{} unexpected failure while failing shard [{}]", (Object)this.entry.shardId, (Object)this.entry), (Throwable)e);
            } else {
                logger.error(() -> new ParameterizedMessage("{} unexpected failure while failing shard [{}]", (Object)this.entry.shardId, (Object)this.entry), (Throwable)e);
            }
            this.listener.onFailure(e);
        }

        @Override
        public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
            this.listener.onResponse(TransportResponse.Empty.INSTANCE);
        }
    }
}

