/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.List;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.Priority;

public abstract class LocalMasterServiceTask
implements ClusterStateTaskListener {
    private final Priority priority;

    public LocalMasterServiceTask(Priority priority) {
        this.priority = priority;
    }

    public void execute(ClusterState currentState) throws Exception {
    }

    public void submit(MasterService masterService, String source) {
        masterService.submitStateUpdateTask(source, this, ClusterStateTaskConfig.build(this.priority), new ClusterStateTaskExecutor<LocalMasterServiceTask>(){

            @Override
            public boolean runOnlyOnMaster() {
                return false;
            }

            @Override
            public String describeTasks(List<LocalMasterServiceTask> tasks) {
                return "";
            }

            @Override
            public ClusterStateTaskExecutor.ClusterTasksResult<LocalMasterServiceTask> execute(ClusterState currentState, List<LocalMasterServiceTask> tasks) throws Exception {
                assert (tasks.size() == 1 && tasks.get(0) == LocalMasterServiceTask.this) : "expected one-element task list containing current object but was " + tasks;
                LocalMasterServiceTask.this.execute(currentState);
                return ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks).build(currentState);
            }
        });
    }
}

