/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStatePublicationEvent;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;

public interface ClusterStateTaskExecutor<T extends ClusterStateTaskListener> {
    public ClusterTasksResult<T> execute(ClusterState var1, List<T> var2) throws Exception;

    default public boolean runOnlyOnMaster() {
        return true;
    }

    default public void clusterStatePublished(ClusterStatePublicationEvent clusterStatePublicationEvent) {
    }

    default public String describeTasks(List<T> tasks) {
        StringBuilder output = new StringBuilder();
        Strings.collectionToDelimitedStringWithLimit(() -> tasks.stream().map(Object::toString).filter(s -> !s.isEmpty()).iterator(), ", ", "", "", 1024, output);
        return output.toString();
    }

    public static <T extends ClusterStateUpdateTask> ClusterStateTaskExecutor<T> unbatched() {
        return new ClusterStateTaskExecutor<T>(){

            @Override
            public ClusterTasksResult<T> execute(ClusterState currentState, List<T> tasks) throws Exception {
                assert (tasks.size() == 1) : "this only supports a single task but received " + tasks;
                ClusterState result = ((ClusterStateUpdateTask)tasks.get(0)).execute(currentState);
                return ClusterTasksResult.builder().successes(tasks).build(result);
            }

            @Override
            public String describeTasks(List<T> tasks) {
                return "";
            }
        };
    }

    public record TaskResult(Exception failure) {
        private static final TaskResult SUCCESS = new TaskResult(null);

        public static TaskResult success() {
            return SUCCESS;
        }

        public static TaskResult failure(Exception failure) {
            return new TaskResult(failure);
        }

        public boolean isSuccess() {
            return this == SUCCESS;
        }

        public Exception getFailure() {
            assert (!this.isSuccess());
            return this.failure;
        }
    }

    public record ClusterTasksResult<T extends ClusterStateTaskListener>(@Nullable ClusterState resultingState, Map<T, TaskResult> executionResults) {
        public static <T extends ClusterStateTaskListener> Builder<T> builder() {
            return new Builder();
        }

        public static class Builder<T extends ClusterStateTaskListener> {
            private final Map<T, TaskResult> executionResults = new IdentityHashMap<T, TaskResult>();

            public Builder<T> success(T task) {
                return this.result(task, TaskResult.success());
            }

            public Builder<T> successes(Iterable<T> tasks) {
                for (ClusterStateTaskListener task : tasks) {
                    this.success(task);
                }
                return this;
            }

            public Builder<T> failure(T task, Exception e) {
                return this.result(task, TaskResult.failure(e));
            }

            public Builder<T> failures(Iterable<T> tasks, Exception e) {
                for (ClusterStateTaskListener task : tasks) {
                    this.failure(task, e);
                }
                return this;
            }

            private Builder<T> result(T task, TaskResult executionResult) {
                TaskResult existing = this.executionResults.put(task, executionResult);
                assert (existing == null) : task + " already has result " + existing;
                return this;
            }

            public ClusterTasksResult<T> build(ClusterState resultingState) {
                return new ClusterTasksResult<T>(resultingState, this.executionResults);
            }
        }
    }
}

