/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap.plugins;

import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.ExtendedLoggerWrapper;
import org.elasticsearch.cli.Terminal;

public final class LoggerTerminal
extends Terminal {
    private final ExtendedLoggerWrapper logger;
    private static final String FQCN = LoggerTerminal.class.getName();

    private LoggerTerminal(Logger logger) {
        super(System.lineSeparator());
        this.logger = new ExtendedLoggerWrapper((ExtendedLogger)((AbstractLogger)logger), logger.getName(), logger.getMessageFactory());
    }

    public static LoggerTerminal getLogger(String logger) {
        return new LoggerTerminal(LogManager.getLogger((String)logger));
    }

    public boolean isHeadless() {
        return true;
    }

    public String readText(String prompt) {
        throw new UnsupportedOperationException();
    }

    public char[] readSecret(String prompt) {
        throw new UnsupportedOperationException();
    }

    public char[] readSecret(String prompt, int maxLength) {
        throw new UnsupportedOperationException();
    }

    public PrintWriter getWriter() {
        throw new UnsupportedOperationException();
    }

    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException();
    }

    public PrintWriter getErrorWriter() {
        throw new UnsupportedOperationException();
    }

    protected void print(Terminal.Verbosity verbosity, String msg, boolean isError) {
        Level level = switch (verbosity) {
            default -> throw new IncompatibleClassChangeError();
            case Terminal.Verbosity.SILENT -> {
                if (isError) {
                    yield Level.ERROR;
                }
                yield Level.WARN;
            }
            case Terminal.Verbosity.VERBOSE -> Level.DEBUG;
            case Terminal.Verbosity.NORMAL -> isError ? Level.WARN : Level.INFO;
        };
        this.logger.logIfEnabled(FQCN, level, null, msg.trim(), (Throwable)null);
    }

    public void flush() {
        throw new UnsupportedOperationException();
    }
}

