/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BiFunction;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.elasticsearch.action.search.CanMatchNodeRequest;
import org.elasticsearch.action.search.CanMatchNodeResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchActionListener;
import org.elasticsearch.action.search.SearchShardTask;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.CanMatchShardResponse;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.fetch.ScrollQueryFetchSearchResult;
import org.elasticsearch.search.fetch.ShardFetchRequest;
import org.elasticsearch.search.fetch.ShardFetchSearchRequest;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.ScrollQuerySearchResult;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class SearchTransportService {
    public static final String FREE_CONTEXT_SCROLL_ACTION_NAME = "indices:data/read/search[free_context/scroll]";
    public static final String FREE_CONTEXT_ACTION_NAME = "indices:data/read/search[free_context]";
    public static final String CLEAR_SCROLL_CONTEXTS_ACTION_NAME = "indices:data/read/search[clear_scroll_contexts]";
    public static final String DFS_ACTION_NAME = "indices:data/read/search[phase/dfs]";
    public static final String QUERY_ACTION_NAME = "indices:data/read/search[phase/query]";
    public static final String QUERY_ID_ACTION_NAME = "indices:data/read/search[phase/query/id]";
    public static final String QUERY_SCROLL_ACTION_NAME = "indices:data/read/search[phase/query/scroll]";
    public static final String QUERY_FETCH_SCROLL_ACTION_NAME = "indices:data/read/search[phase/query+fetch/scroll]";
    public static final String FETCH_ID_SCROLL_ACTION_NAME = "indices:data/read/search[phase/fetch/id/scroll]";
    public static final String FETCH_ID_ACTION_NAME = "indices:data/read/search[phase/fetch/id]";
    public static final String QUERY_CAN_MATCH_NAME = "indices:data/read/search[can_match]";
    public static final String QUERY_CAN_MATCH_NODE_NAME = "indices:data/read/search[can_match][n]";
    private final TransportService transportService;
    private final NodeClient client;
    private final BiFunction<Transport.Connection, SearchActionListener<? super SearchPhaseResult>, ActionListener<? super SearchPhaseResult>> responseWrapper;
    private final Map<String, Long> clientConnections = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();

    public SearchTransportService(TransportService transportService, NodeClient client, BiFunction<Transport.Connection, SearchActionListener<? super SearchPhaseResult>, ActionListener<? super SearchPhaseResult>> responseWrapper) {
        this.transportService = transportService;
        this.client = client;
        this.responseWrapper = responseWrapper;
    }

    public void sendFreeContext(Transport.Connection connection, ShardSearchContextId contextId, OriginalIndices originalIndices) {
        this.transportService.sendRequest(connection, FREE_CONTEXT_ACTION_NAME, (TransportRequest)new SearchFreeContextRequest(originalIndices, contextId), TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<SearchFreeContextResponse>(new ActionListener<SearchFreeContextResponse>(){

            @Override
            public void onResponse(SearchFreeContextResponse response) {
            }

            @Override
            public void onFailure(Exception e) {
            }
        }, SearchFreeContextResponse::new));
    }

    public void sendFreeContext(Transport.Connection connection, ShardSearchContextId contextId, ActionListener<SearchFreeContextResponse> listener) {
        this.transportService.sendRequest(connection, FREE_CONTEXT_SCROLL_ACTION_NAME, (TransportRequest)new ScrollFreeContextRequest(contextId), TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<SearchFreeContextResponse>(listener, SearchFreeContextResponse::new));
    }

    public void sendCanMatch(Transport.Connection connection, ShardSearchRequest request, SearchTask task, ActionListener<CanMatchShardResponse> listener) {
        this.transportService.sendChildRequest(connection, QUERY_CAN_MATCH_NAME, (TransportRequest)request, (Task)task, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<CanMatchShardResponse>(listener, CanMatchShardResponse::new));
    }

    public void sendCanMatch(Transport.Connection connection, CanMatchNodeRequest request, SearchTask task, ActionListener<CanMatchNodeResponse> listener) {
        if (connection.getVersion().onOrAfter(Version.V_7_16_0) && connection.getNode().getVersion().onOrAfter(Version.V_7_16_0)) {
            this.transportService.sendChildRequest(connection, QUERY_CAN_MATCH_NODE_NAME, (TransportRequest)request, (Task)task, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<CanMatchNodeResponse>(listener, CanMatchNodeResponse::new));
        } else {
            List<ShardSearchRequest> shardSearchRequests = request.createShardSearchRequests();
            final AtomicReferenceArray<CanMatchNodeResponse.ResponseOrFailure> results = new AtomicReferenceArray<CanMatchNodeResponse.ResponseOrFailure>(shardSearchRequests.size());
            CountDown counter = new CountDown(shardSearchRequests.size());
            final Runnable maybeFinish = () -> {
                if (counter.countDown()) {
                    CanMatchNodeResponse.ResponseOrFailure[] responses = new CanMatchNodeResponse.ResponseOrFailure[shardSearchRequests.size()];
                    for (int i = 0; i < responses.length; ++i) {
                        responses[i] = (CanMatchNodeResponse.ResponseOrFailure)results.get(i);
                    }
                    CanMatchNodeResponse response = new CanMatchNodeResponse(Arrays.asList(responses));
                    listener.onResponse(response);
                }
            };
            for (int i = 0; i < shardSearchRequests.size(); ++i) {
                ShardSearchRequest shardSearchRequest = shardSearchRequests.get(i);
                final int finalI = i;
                try {
                    this.sendCanMatch(connection, shardSearchRequest, task, new ActionListener<CanMatchShardResponse>(){

                        @Override
                        public void onResponse(CanMatchShardResponse response) {
                            results.set(finalI, new CanMatchNodeResponse.ResponseOrFailure(response));
                            maybeFinish.run();
                        }

                        @Override
                        public void onFailure(Exception e) {
                            results.set(finalI, new CanMatchNodeResponse.ResponseOrFailure(e));
                            maybeFinish.run();
                        }
                    });
                    continue;
                }
                catch (Exception e) {
                    results.set(finalI, new CanMatchNodeResponse.ResponseOrFailure(e));
                    maybeFinish.run();
                }
            }
        }
    }

    public void sendClearAllScrollContexts(Transport.Connection connection, ActionListener<TransportResponse> listener) {
        this.transportService.sendRequest(connection, CLEAR_SCROLL_CONTEXTS_ACTION_NAME, (TransportRequest)TransportRequest.Empty.INSTANCE, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<TransportResponse.Empty>(listener, in -> TransportResponse.Empty.INSTANCE));
    }

    public void sendExecuteDfs(Transport.Connection connection, ShardSearchRequest request, SearchTask task, SearchActionListener<DfsSearchResult> listener) {
        this.transportService.sendChildRequest(connection, DFS_ACTION_NAME, request, task, new ConnectionCountingHandler<DfsSearchResult>(listener, DfsSearchResult::new, this.clientConnections, connection.getNode().getId()));
    }

    public void sendExecuteQuery(Transport.Connection connection, ShardSearchRequest request, SearchTask task, SearchActionListener<? super SearchPhaseResult> listener) {
        boolean fetchDocuments = request.numberOfShards() == 1;
        Writeable.Reader<SearchPhaseResult> reader = fetchDocuments ? QueryFetchSearchResult::new : in -> new QuerySearchResult(in, true);
        ActionListener<? super SearchPhaseResult> handler = this.responseWrapper.apply(connection, listener);
        this.transportService.sendChildRequest(connection, QUERY_ACTION_NAME, request, task, new ConnectionCountingHandler<SearchPhaseResult>(handler, reader, this.clientConnections, connection.getNode().getId()));
    }

    public void sendExecuteQuery(Transport.Connection connection, QuerySearchRequest request, SearchTask task, SearchActionListener<QuerySearchResult> listener) {
        this.transportService.sendChildRequest(connection, QUERY_ID_ACTION_NAME, request, task, new ConnectionCountingHandler<QuerySearchResult>(listener, QuerySearchResult::new, this.clientConnections, connection.getNode().getId()));
    }

    public void sendExecuteScrollQuery(Transport.Connection connection, InternalScrollSearchRequest request, SearchTask task, SearchActionListener<ScrollQuerySearchResult> listener) {
        this.transportService.sendChildRequest(connection, QUERY_SCROLL_ACTION_NAME, request, task, new ConnectionCountingHandler<ScrollQuerySearchResult>(listener, ScrollQuerySearchResult::new, this.clientConnections, connection.getNode().getId()));
    }

    public void sendExecuteScrollFetch(Transport.Connection connection, InternalScrollSearchRequest request, SearchTask task, SearchActionListener<ScrollQueryFetchSearchResult> listener) {
        this.transportService.sendChildRequest(connection, QUERY_FETCH_SCROLL_ACTION_NAME, request, task, new ConnectionCountingHandler<ScrollQueryFetchSearchResult>(listener, ScrollQueryFetchSearchResult::new, this.clientConnections, connection.getNode().getId()));
    }

    public void sendExecuteFetch(Transport.Connection connection, ShardFetchSearchRequest request, SearchTask task, SearchActionListener<FetchSearchResult> listener) {
        this.sendExecuteFetch(connection, FETCH_ID_ACTION_NAME, request, task, listener);
    }

    public void sendExecuteFetchScroll(Transport.Connection connection, ShardFetchRequest request, SearchTask task, SearchActionListener<FetchSearchResult> listener) {
        this.sendExecuteFetch(connection, FETCH_ID_SCROLL_ACTION_NAME, request, task, listener);
    }

    private void sendExecuteFetch(Transport.Connection connection, String action, ShardFetchRequest request, SearchTask task, SearchActionListener<FetchSearchResult> listener) {
        this.transportService.sendChildRequest(connection, action, request, task, new ConnectionCountingHandler<FetchSearchResult>(listener, FetchSearchResult::new, this.clientConnections, connection.getNode().getId()));
    }

    void sendExecuteMultiSearch(MultiSearchRequest request, SearchTask task, ActionListener<MultiSearchResponse> listener) {
        Transport.Connection connection = this.transportService.getConnection(this.transportService.getLocalNode());
        this.transportService.sendChildRequest(connection, "indices:data/read/msearch", request, task, new ConnectionCountingHandler<MultiSearchResponse>(listener, MultiSearchResponse::new, this.clientConnections, connection.getNode().getId()));
    }

    public RemoteClusterService getRemoteClusterService() {
        return this.transportService.getRemoteClusterService();
    }

    public Map<String, Long> getPendingSearchRequests() {
        return new HashMap<String, Long>(this.clientConnections);
    }

    public static void registerRequestHandler(TransportService transportService, SearchService searchService) {
        transportService.registerRequestHandler(FREE_CONTEXT_SCROLL_ACTION_NAME, "same", ScrollFreeContextRequest::new, (request, channel, task) -> {
            boolean freed = searchService.freeReaderContext(request.id());
            channel.sendResponse(new SearchFreeContextResponse(freed));
        });
        TransportActionProxy.registerProxyAction(transportService, FREE_CONTEXT_SCROLL_ACTION_NAME, false, SearchFreeContextResponse::new);
        transportService.registerRequestHandler(FREE_CONTEXT_ACTION_NAME, "same", SearchFreeContextRequest::new, (request, channel, task) -> {
            boolean freed = searchService.freeReaderContext(request.id());
            channel.sendResponse(new SearchFreeContextResponse(freed));
        });
        TransportActionProxy.registerProxyAction(transportService, FREE_CONTEXT_ACTION_NAME, false, SearchFreeContextResponse::new);
        transportService.registerRequestHandler(CLEAR_SCROLL_CONTEXTS_ACTION_NAME, "same", TransportRequest.Empty::new, (request, channel, task) -> {
            searchService.freeAllScrollContexts();
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        });
        TransportActionProxy.registerProxyAction(transportService, CLEAR_SCROLL_CONTEXTS_ACTION_NAME, false, in -> TransportResponse.Empty.INSTANCE);
        transportService.registerRequestHandler(DFS_ACTION_NAME, "same", ShardSearchRequest::new, (request, channel, task) -> searchService.executeDfsPhase((ShardSearchRequest)request, (SearchShardTask)task, new ChannelActionListener(channel, DFS_ACTION_NAME, (ShardSearchRequest)request)));
        TransportActionProxy.registerProxyAction(transportService, DFS_ACTION_NAME, true, DfsSearchResult::new);
        transportService.registerRequestHandler(QUERY_ACTION_NAME, "same", ShardSearchRequest::new, (request, channel, task) -> searchService.executeQueryPhase((ShardSearchRequest)request, (SearchShardTask)task, new ChannelActionListener(channel, QUERY_ACTION_NAME, (ShardSearchRequest)request)));
        TransportActionProxy.registerProxyActionWithDynamicResponseType(transportService, QUERY_ACTION_NAME, true, request -> ((ShardSearchRequest)request).numberOfShards() == 1 ? QueryFetchSearchResult::new : QuerySearchResult::new);
        transportService.registerRequestHandler(QUERY_ID_ACTION_NAME, "same", QuerySearchRequest::new, (request, channel, task) -> searchService.executeQueryPhase((QuerySearchRequest)request, (SearchShardTask)task, new ChannelActionListener(channel, QUERY_ID_ACTION_NAME, (QuerySearchRequest)request)));
        TransportActionProxy.registerProxyAction(transportService, QUERY_ID_ACTION_NAME, true, QuerySearchResult::new);
        transportService.registerRequestHandler(QUERY_SCROLL_ACTION_NAME, "same", InternalScrollSearchRequest::new, (request, channel, task) -> searchService.executeQueryPhase((InternalScrollSearchRequest)request, (SearchShardTask)task, new ChannelActionListener(channel, QUERY_SCROLL_ACTION_NAME, (InternalScrollSearchRequest)request)));
        TransportActionProxy.registerProxyAction(transportService, QUERY_SCROLL_ACTION_NAME, true, ScrollQuerySearchResult::new);
        transportService.registerRequestHandler(QUERY_FETCH_SCROLL_ACTION_NAME, "same", InternalScrollSearchRequest::new, (request, channel, task) -> searchService.executeFetchPhase((InternalScrollSearchRequest)request, (SearchShardTask)task, new ChannelActionListener(channel, QUERY_FETCH_SCROLL_ACTION_NAME, (InternalScrollSearchRequest)request)));
        TransportActionProxy.registerProxyAction(transportService, QUERY_FETCH_SCROLL_ACTION_NAME, true, ScrollQueryFetchSearchResult::new);
        transportService.registerRequestHandler(FETCH_ID_SCROLL_ACTION_NAME, "same", ShardFetchRequest::new, (request, channel, task) -> searchService.executeFetchPhase((ShardFetchRequest)request, (SearchShardTask)task, new ChannelActionListener(channel, FETCH_ID_SCROLL_ACTION_NAME, (ShardFetchRequest)request)));
        TransportActionProxy.registerProxyAction(transportService, FETCH_ID_SCROLL_ACTION_NAME, true, FetchSearchResult::new);
        transportService.registerRequestHandler(FETCH_ID_ACTION_NAME, "same", true, true, ShardFetchSearchRequest::new, (request, channel, task) -> searchService.executeFetchPhase((ShardFetchRequest)request, (SearchShardTask)task, new ChannelActionListener(channel, FETCH_ID_ACTION_NAME, (ShardFetchSearchRequest)request)));
        TransportActionProxy.registerProxyAction(transportService, FETCH_ID_ACTION_NAME, true, FetchSearchResult::new);
        transportService.registerRequestHandler(QUERY_CAN_MATCH_NAME, "same", ShardSearchRequest::new, (request, channel, task) -> searchService.canMatch((ShardSearchRequest)request, new ChannelActionListener(channel, QUERY_CAN_MATCH_NAME, (ShardSearchRequest)request)));
        TransportActionProxy.registerProxyAction(transportService, QUERY_CAN_MATCH_NAME, true, CanMatchShardResponse::new);
        transportService.registerRequestHandler(QUERY_CAN_MATCH_NODE_NAME, "search_coordination", CanMatchNodeRequest::new, (request, channel, task) -> searchService.canMatch((CanMatchNodeRequest)request, new ChannelActionListener(channel, QUERY_CAN_MATCH_NAME, (CanMatchNodeRequest)request)));
        TransportActionProxy.registerProxyAction(transportService, QUERY_CAN_MATCH_NODE_NAME, true, CanMatchNodeResponse::new);
    }

    public Transport.Connection getConnection(@Nullable String clusterAlias, DiscoveryNode node) {
        if (clusterAlias == null) {
            return this.transportService.getConnection(node);
        }
        return this.transportService.getRemoteClusterService().getConnection(node, clusterAlias);
    }

    public void cancelSearchTask(SearchTask task, String reason) {
        CancelTasksRequest req = ((CancelTasksRequest)new CancelTasksRequest().setTargetTaskId(new TaskId(this.client.getLocalNodeId(), task.getId()))).setReason("Fatal failure during search: " + reason);
        new OriginSettingClient(this.client, "tasks").admin().cluster().cancelTasks(req, ActionListener.wrap(() -> {}));
    }

    public NamedWriteableRegistry getNamedWriteableRegistry() {
        return this.client.getNamedWriteableRegistry();
    }

    static class SearchFreeContextRequest
    extends ScrollFreeContextRequest
    implements IndicesRequest {
        private OriginalIndices originalIndices;

        SearchFreeContextRequest(OriginalIndices originalIndices, ShardSearchContextId id) {
            super(id);
            this.originalIndices = originalIndices;
        }

        SearchFreeContextRequest(StreamInput in) throws IOException {
            super(in);
            this.originalIndices = OriginalIndices.readOriginalIndices(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            OriginalIndices.writeOriginalIndices(this.originalIndices, out);
        }

        @Override
        public String[] indices() {
            if (this.originalIndices == null) {
                return null;
            }
            return this.originalIndices.indices();
        }

        @Override
        public IndicesOptions indicesOptions() {
            if (this.originalIndices == null) {
                return null;
            }
            return this.originalIndices.indicesOptions();
        }
    }

    static class ScrollFreeContextRequest
    extends TransportRequest {
        private ShardSearchContextId contextId;

        ScrollFreeContextRequest(ShardSearchContextId contextId) {
            this.contextId = Objects.requireNonNull(contextId);
        }

        ScrollFreeContextRequest(StreamInput in) throws IOException {
            super(in);
            this.contextId = new ShardSearchContextId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.contextId.writeTo(out);
        }

        public ShardSearchContextId id() {
            return this.contextId;
        }
    }

    final class ConnectionCountingHandler<Response extends TransportResponse>
    extends ActionListenerResponseHandler<Response> {
        private final Map<String, Long> clientConnections;
        private final String nodeId;

        ConnectionCountingHandler(ActionListener<? super Response> listener, Writeable.Reader<Response> responseReader, Map<String, Long> clientConnections, String nodeId) {
            super(listener, responseReader);
            this.clientConnections = clientConnections;
            this.nodeId = nodeId;
            clientConnections.compute(nodeId, (id, conns) -> conns == null ? 1L : conns + 1L);
        }

        @Override
        public void handleResponse(Response response) {
            super.handleResponse(response);
            assert (this.assertNodePresent());
            this.clientConnections.computeIfPresent(this.nodeId, (id, conns) -> conns == 1L ? null : Long.valueOf(conns - 1L));
        }

        @Override
        public void handleException(TransportException e) {
            super.handleException(e);
            assert (this.assertNodePresent());
            this.clientConnections.computeIfPresent(this.nodeId, (id, conns) -> conns == 1L ? null : Long.valueOf(conns - 1L));
        }

        private boolean assertNodePresent() {
            this.clientConnections.compute(this.nodeId, (id, conns) -> {
                assert (conns != null) : "number of connections for " + id + " is null, but should be an integer";
                assert (conns >= 1L) : "number of connections for " + id + " should be >= 1 but was " + conns;
                return conns;
            });
            return true;
        }
    }

    public static class SearchFreeContextResponse
    extends TransportResponse {
        private boolean freed;

        SearchFreeContextResponse(StreamInput in) throws IOException {
            this.freed = in.readBoolean();
        }

        SearchFreeContextResponse(boolean freed) {
            this.freed = freed;
        }

        public boolean isFreed() {
            return this.freed;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.freed);
        }
    }
}

