/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.rollover.Condition;
import org.elasticsearch.action.admin.indices.rollover.MetadataRolloverService;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverResponse;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsAction;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportRolloverAction
extends TransportMasterNodeAction<RolloverRequest, RolloverResponse> {
    private static final Logger logger = LogManager.getLogger(TransportRolloverAction.class);
    private final MetadataRolloverService rolloverService;
    private final ActiveShardsObserver activeShardsObserver;
    private final Client client;
    private final RolloverExecutor rolloverTaskExecutor;

    @Inject
    public TransportRolloverAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, MetadataRolloverService rolloverService, Client client, AllocationService allocationService) {
        super("indices:admin/rollover", transportService, clusterService, threadPool, actionFilters, RolloverRequest::new, indexNameExpressionResolver, RolloverResponse::new, "same");
        this.rolloverService = rolloverService;
        this.client = client;
        this.activeShardsObserver = new ActiveShardsObserver(clusterService, threadPool);
        this.rolloverTaskExecutor = new RolloverExecutor(allocationService);
    }

    @Override
    protected ClusterBlockException checkBlock(RolloverRequest request, ClusterState state) {
        IndicesOptions indicesOptions = IndicesOptions.fromOptions(true, true, request.indicesOptions().expandWildcardsOpen(), request.indicesOptions().expandWildcardsClosed());
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, indicesOptions, request));
    }

    @Override
    protected void masterOperation(Task task, RolloverRequest rolloverRequest, ClusterState oldState, ActionListener<RolloverResponse> listener) throws Exception {
        Metadata metadata = oldState.metadata();
        IndicesStatsRequest statsRequest = ((IndicesStatsRequest)((IndicesStatsRequest)new IndicesStatsRequest().indices(new String[]{rolloverRequest.getRolloverTarget()})).clear().indicesOptions(IndicesOptions.fromOptions(true, false, true, true))).docs(true);
        statsRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
        this.client.execute(IndicesStatsAction.INSTANCE, statsRequest, ActionListener.wrap(statsResponse -> {
            MetadataRolloverService.NameResolution trialRolloverNames = this.rolloverService.resolveRolloverNames(oldState, rolloverRequest.getRolloverTarget(), rolloverRequest.getNewIndexName(), rolloverRequest.getCreateIndexRequest());
            String trialSourceIndexName = trialRolloverNames.sourceName();
            String trialRolloverIndexName = trialRolloverNames.rolloverName();
            this.rolloverService.validateIndexName(oldState, trialRolloverIndexName);
            Map<String, Boolean> trialConditionResults = TransportRolloverAction.evaluateConditions(rolloverRequest.getConditions().values(), TransportRolloverAction.buildStats(metadata.index(trialSourceIndexName), statsResponse));
            if (rolloverRequest.isDryRun()) {
                listener.onResponse(new RolloverResponse(trialSourceIndexName, trialRolloverIndexName, trialConditionResults, true, false, false, false));
                return;
            }
            List trialMetConditions = rolloverRequest.getConditions().values().stream().filter(condition -> (Boolean)trialConditionResults.get(condition.toString())).collect(Collectors.toList());
            RolloverResponse trialRolloverResponse = new RolloverResponse(trialSourceIndexName, trialRolloverIndexName, trialConditionResults, false, false, false, false);
            if (trialConditionResults.size() == 0 || trialMetConditions.size() > 0) {
                String source = "rollover_index source [" + trialRolloverIndexName + "] to target [" + trialRolloverIndexName + "]";
                RolloverTask rolloverTask = new RolloverTask(rolloverRequest, (IndicesStatsResponse)statsResponse, trialRolloverResponse, listener);
                ClusterStateTaskConfig config = ClusterStateTaskConfig.build(Priority.NORMAL, rolloverRequest.masterNodeTimeout());
                this.clusterService.submitStateUpdateTask(source, rolloverTask, config, this.rolloverTaskExecutor);
            } else {
                listener.onResponse(trialRolloverResponse);
            }
        }, listener::onFailure));
    }

    static Map<String, Boolean> evaluateConditions(Collection<Condition<?>> conditions, @Nullable Condition.Stats stats) {
        Objects.requireNonNull(conditions, "conditions must not be null");
        if (stats != null) {
            return conditions.stream().map(condition -> condition.evaluate(stats)).collect(Collectors.toMap(result -> result.condition().toString(), Condition.Result::matched));
        }
        return conditions.stream().collect(Collectors.toMap(Condition::toString, cond -> false));
    }

    static Condition.Stats buildStats(@Nullable IndexMetadata metadata, @Nullable IndicesStatsResponse statsResponse) {
        if (metadata == null) {
            return null;
        }
        Optional<IndexStats> indexStats = Optional.ofNullable(statsResponse).map(stats -> stats.getIndex(metadata.getIndex().getName()));
        DocsStats docsStats = indexStats.map(stats -> stats.getPrimaries().getDocs()).orElse(null);
        long maxPrimaryShardSize = indexStats.stream().map(IndexStats::getShards).filter(Objects::nonNull).flatMap(Arrays::stream).filter(shard -> shard.getShardRouting().primary()).map(ShardStats::getStats).mapToLong(shard -> shard.docs.getTotalSizeInBytes()).max().orElse(0L);
        return new Condition.Stats(docsStats == null ? 0L : docsStats.getCount(), metadata.getCreationDate(), new ByteSizeValue(docsStats == null ? 0L : docsStats.getTotalSizeInBytes()), new ByteSizeValue(maxPrimaryShardSize));
    }

    static class RolloverExecutor
    implements ClusterStateTaskExecutor<RolloverTask> {
        private final AllocationService allocationService;

        RolloverExecutor(AllocationService allocationService) {
            this.allocationService = allocationService;
        }

        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<RolloverTask> execute(ClusterState currentState, List<RolloverTask> tasks) throws Exception {
            ClusterStateTaskExecutor.ClusterTasksResult.Builder<RolloverTask> builder = ClusterStateTaskExecutor.ClusterTasksResult.builder();
            ClusterState state = currentState;
            for (RolloverTask task : tasks) {
                try {
                    state = task.performRollover(state);
                    builder.success(task);
                }
                catch (Exception e) {
                    builder.failure(task, e);
                }
            }
            if (state != currentState) {
                StringBuilder reason = new StringBuilder();
                Strings.collectionToDelimitedStringWithLimit(() -> tasks.stream().map(t -> (String)t.sourceIndex.get() + "->" + (String)t.rolloverIndex.get()).iterator(), ",", "bulk rollover [", "]", 1024, reason);
                state = this.allocationService.reroute(state, reason.toString());
            }
            return builder.build(state);
        }
    }

    class RolloverTask
    implements ClusterStateTaskListener {
        private final RolloverRequest rolloverRequest;
        private final IndicesStatsResponse statsResponse;
        private final RolloverResponse trialRolloverResponse;
        private final ActionListener<RolloverResponse> listener;
        private boolean clusterStateProcessed = false;
        private final SetOnce<String> sourceIndex = new SetOnce();
        private final SetOnce<String> rolloverIndex = new SetOnce();
        private final SetOnce<Map<String, Boolean>> conditionResults = new SetOnce();

        RolloverTask(RolloverRequest rolloverRequest, IndicesStatsResponse statsResponse, RolloverResponse trialRolloverResponse, ActionListener<RolloverResponse> listener) {
            this.rolloverRequest = rolloverRequest;
            this.statsResponse = statsResponse;
            this.trialRolloverResponse = trialRolloverResponse;
            this.listener = listener;
        }

        ClusterState performRollover(ClusterState currentState) throws Exception {
            MetadataRolloverService.NameResolution rolloverNames = TransportRolloverAction.this.rolloverService.resolveRolloverNames(currentState, this.rolloverRequest.getRolloverTarget(), this.rolloverRequest.getNewIndexName(), this.rolloverRequest.getCreateIndexRequest());
            String sourceIndexName = rolloverNames.sourceName();
            Map<String, Boolean> postConditionResults = TransportRolloverAction.evaluateConditions(this.rolloverRequest.getConditions().values(), TransportRolloverAction.buildStats(currentState.metadata().index(sourceIndexName), this.statsResponse));
            List<Condition<?>> metConditions = this.rolloverRequest.getConditions().values().stream().filter(condition -> (Boolean)postConditionResults.get(condition.toString())).collect(Collectors.toList());
            this.conditionResults.set(postConditionResults);
            if (postConditionResults.size() == 0 || metConditions.size() > 0) {
                this.clusterStateProcessed = true;
                MetadataRolloverService.RolloverResult rolloverResult = TransportRolloverAction.this.rolloverService.rolloverClusterState(currentState, this.rolloverRequest.getRolloverTarget(), this.rolloverRequest.getNewIndexName(), this.rolloverRequest.getCreateIndexRequest(), metConditions, Instant.now(), false, false);
                logger.trace("rollover result [{}]", (Object)rolloverResult);
                this.sourceIndex.set((Object)rolloverResult.sourceIndexName());
                this.rolloverIndex.set((Object)rolloverResult.rolloverIndexName());
                return rolloverResult.clusterState();
            }
            return currentState;
        }

        @Override
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }

        @Override
        public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
            if (this.clusterStateProcessed) {
                assert (this.sourceIndex.get() != null) : "source index missing on successful rollover";
                assert (this.rolloverIndex.get() != null) : "rollover index missing on successful rollover";
                assert (this.conditionResults.get() != null) : "matching rollover conditions missing on successful rollover";
                TransportRolloverAction.this.activeShardsObserver.waitForActiveShards(new String[]{(String)this.rolloverIndex.get()}, this.rolloverRequest.getCreateIndexRequest().waitForActiveShards(), this.rolloverRequest.masterNodeTimeout(), isShardsAcknowledged -> this.listener.onResponse(new RolloverResponse((String)this.sourceIndex.get(), (String)this.rolloverIndex.get(), (Map)this.conditionResults.get(), false, true, true, (boolean)isShardsAcknowledged)), this.listener::onFailure);
            } else {
                this.listener.onResponse(this.trialRolloverResponse);
            }
        }
    }
}

