/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateDataStreamService;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.SystemDataStreamDescriptor;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public final class AutoCreateAction
extends ActionType<CreateIndexResponse> {
    private static final Logger logger = LogManager.getLogger(AutoCreateAction.class);
    public static final AutoCreateAction INSTANCE = new AutoCreateAction();
    public static final String NAME = "indices:admin/auto_create";

    private AutoCreateAction() {
        super(NAME, CreateIndexResponse::new);
    }

    static ComposableIndexTemplate resolveTemplate(CreateIndexRequest request, Metadata metadata) {
        String v2Template = MetadataIndexTemplateService.findV2Template(metadata, request.index(), false);
        return v2Template != null ? metadata.templatesV2().get(v2Template) : null;
    }

    public static final class TransportAction
    extends TransportMasterNodeAction<CreateIndexRequest, CreateIndexResponse> {
        private final ActiveShardsObserver activeShardsObserver;
        private final MetadataCreateIndexService createIndexService;
        private final MetadataCreateDataStreamService metadataCreateDataStreamService;
        private final AutoCreateIndex autoCreateIndex;
        private final SystemIndices systemIndices;
        private final ClusterStateTaskExecutor<CreateIndexTask> executor;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, MetadataCreateIndexService createIndexService, MetadataCreateDataStreamService metadataCreateDataStreamService, AutoCreateIndex autoCreateIndex, SystemIndices systemIndices, AllocationService allocationService) {
            super(AutoCreateAction.NAME, transportService, clusterService, threadPool, actionFilters, CreateIndexRequest::new, indexNameExpressionResolver, CreateIndexResponse::new, "same");
            this.systemIndices = systemIndices;
            this.activeShardsObserver = new ActiveShardsObserver(clusterService, threadPool);
            this.createIndexService = createIndexService;
            this.metadataCreateDataStreamService = metadataCreateDataStreamService;
            this.autoCreateIndex = autoCreateIndex;
            this.executor = (currentState, tasks) -> {
                ClusterStateTaskExecutor.ClusterTasksResult.Builder<CreateIndexTask> builder = ClusterStateTaskExecutor.ClusterTasksResult.builder();
                ClusterState state = currentState;
                HashMap<CreateIndexRequest, CreateIndexTask> successfulRequests = new HashMap<CreateIndexRequest, CreateIndexTask>(tasks.size());
                for (CreateIndexTask task : tasks) {
                    try {
                        CreateIndexTask successfulBefore = successfulRequests.putIfAbsent(task.request, task);
                        if (successfulBefore == null) {
                            state = task.execute(state);
                        } else {
                            task.indexNameRef.set(successfulBefore.indexNameRef.get());
                        }
                        builder.success(task);
                    }
                    catch (Exception e) {
                        builder.failure(task, e);
                    }
                }
                if (state != currentState) {
                    state = allocationService.reroute(state, "auto-create");
                }
                return builder.build(state);
            };
        }

        @Override
        protected void masterOperation(Task task, CreateIndexRequest request, ClusterState state, ActionListener<CreateIndexResponse> finalListener) {
            AtomicReference<String> indexNameRef = new AtomicReference<String>();
            ActionListener<AcknowledgedResponse> listener = ActionListener.wrap(response -> {
                String indexName = (String)indexNameRef.get();
                assert (indexName != null);
                if (response.isAcknowledged()) {
                    this.activeShardsObserver.waitForActiveShards(new String[]{indexName}, ActiveShardCount.DEFAULT, request.timeout(), shardsAcked -> finalListener.onResponse(new CreateIndexResponse(true, (boolean)shardsAcked, indexName)), finalListener::onFailure);
                } else {
                    finalListener.onResponse(new CreateIndexResponse(false, false, indexName));
                }
            }, finalListener::onFailure);
            CreateIndexTask clusterTask = new CreateIndexTask(request, listener, indexNameRef);
            this.clusterService.submitStateUpdateTask("auto create [" + request.index() + "]", clusterTask, clusterTask, this.executor);
        }

        @Override
        protected ClusterBlockException checkBlock(CreateIndexRequest request, ClusterState state) {
            return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, request.index());
        }

        private final class CreateIndexTask
        extends AckedClusterStateUpdateTask {
            final CreateIndexRequest request;
            final AtomicReference<String> indexNameRef;

            CreateIndexTask(CreateIndexRequest request, ActionListener<AcknowledgedResponse> listener, AtomicReference<String> indexNameRef) {
                super(Priority.URGENT, request, listener);
                this.request = request;
                this.indexNameRef = indexNameRef;
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                CreateIndexClusterStateUpdateRequest updateRequest;
                boolean isManagedSystemIndex;
                boolean isDataStream;
                SystemDataStreamDescriptor dataStreamDescriptor = TransportAction.this.systemIndices.validateDataStreamAccess(this.request.index(), TransportAction.this.threadPool.getThreadContext());
                boolean isSystemDataStream = dataStreamDescriptor != null;
                boolean isSystemIndex = !isSystemDataStream && TransportAction.this.systemIndices.isSystemIndex(this.request.index());
                ComposableIndexTemplate template = AutoCreateAction.resolveTemplate(this.request, currentState.metadata());
                boolean bl = isDataStream = !isSystemIndex && (isSystemDataStream || template != null && template.getDataStreamTemplate() != null);
                if (isDataStream) {
                    if (!isSystemDataStream && Boolean.FALSE.equals(template.getAllowAutoCreate())) {
                        throw new IndexNotFoundException("composable template " + template.indexPatterns() + " forbids index auto creation");
                    }
                    MetadataCreateDataStreamService.CreateDataStreamClusterStateUpdateRequest createRequest = new MetadataCreateDataStreamService.CreateDataStreamClusterStateUpdateRequest(this.request.index(), dataStreamDescriptor, this.request.masterNodeTimeout(), this.request.timeout(), false);
                    ClusterState clusterState = TransportAction.this.metadataCreateDataStreamService.createDataStream(createRequest, currentState);
                    this.indexNameRef.set(clusterState.metadata().dataStreams().get(this.request.index()).getIndices().get(0).getName());
                    return clusterState;
                }
                String indexName = IndexNameExpressionResolver.resolveDateMathExpression(this.request.index());
                this.indexNameRef.set(indexName);
                if (isSystemIndex) {
                    if (!indexName.equals(this.request.index())) {
                        throw new IllegalStateException("system indices do not support date math expressions");
                    }
                } else {
                    boolean shouldAutoCreate = TransportAction.this.autoCreateIndex.shouldAutoCreate(indexName, currentState);
                    if (!shouldAutoCreate) {
                        return currentState;
                    }
                }
                SystemIndexDescriptor mainDescriptor = isSystemIndex ? TransportAction.this.systemIndices.findMatchingDescriptor(indexName) : null;
                boolean bl2 = isManagedSystemIndex = mainDescriptor != null && mainDescriptor.isAutomaticallyManaged();
                if (isManagedSystemIndex) {
                    SystemIndexDescriptor descriptor = mainDescriptor.getDescriptorCompatibleWith(currentState.nodes().getSmallestNonClientNodeVersion());
                    if (descriptor == null) {
                        String message = mainDescriptor.getMinimumNodeVersionMessage("auto-create index");
                        logger.warn(message);
                        throw new IllegalStateException(message);
                    }
                    updateRequest = this.buildSystemIndexUpdateRequest(indexName, descriptor);
                } else if (isSystemIndex) {
                    updateRequest = this.buildUpdateRequest(indexName);
                    if (Objects.isNull(this.request.settings())) {
                        updateRequest.settings(SystemIndexDescriptor.DEFAULT_SETTINGS);
                    } else if (!this.request.settings().hasValue("index.hidden")) {
                        updateRequest.settings(Settings.builder().put(this.request.settings()).put("index.hidden", true).build());
                    } else if ("false".equals(this.request.settings().get("index.hidden"))) {
                        String message = "Cannot auto-create system index [" + indexName + "] with [index.hidden] set to 'false'";
                        logger.warn(message);
                        throw new IllegalStateException(message);
                    }
                } else {
                    updateRequest = this.buildUpdateRequest(indexName);
                }
                return TransportAction.this.createIndexService.applyCreateIndexRequest(currentState, updateRequest, false);
            }

            private CreateIndexClusterStateUpdateRequest buildUpdateRequest(String indexName) {
                CreateIndexClusterStateUpdateRequest updateRequest = (CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)new CreateIndexClusterStateUpdateRequest(this.request.cause(), indexName, this.request.index()).ackTimeout(this.request.timeout())).performReroute(false).masterNodeTimeout(this.request.masterNodeTimeout());
                logger.debug("Auto-creating index {}", (Object)indexName);
                return updateRequest;
            }

            private CreateIndexClusterStateUpdateRequest buildSystemIndexUpdateRequest(String indexName, SystemIndexDescriptor descriptor) {
                String mappings = descriptor.getMappings();
                Settings settings = descriptor.getSettings();
                String aliasName = descriptor.getAliasName();
                String concreteIndexName = indexName.equals(aliasName) ? descriptor.getPrimaryIndex() : indexName;
                CreateIndexClusterStateUpdateRequest updateRequest = ((CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)new CreateIndexClusterStateUpdateRequest(this.request.cause(), concreteIndexName, this.request.index()).ackTimeout(this.request.timeout())).masterNodeTimeout(this.request.masterNodeTimeout())).performReroute(false);
                updateRequest.waitForActiveShards(ActiveShardCount.ALL);
                if (mappings != null) {
                    updateRequest.mappings(mappings);
                }
                if (settings != null) {
                    updateRequest.settings(settings);
                }
                if (aliasName != null) {
                    updateRequest.aliases(Set.of(new Alias(aliasName).isHidden(true)));
                }
                if (logger.isDebugEnabled()) {
                    if (!concreteIndexName.equals(indexName)) {
                        logger.debug("Auto-creating backing system index {} for alias {}", (Object)concreteIndexName, (Object)indexName);
                    } else {
                        logger.debug("Auto-creating system index {}", (Object)concreteIndexName);
                    }
                }
                return updateRequest;
            }
        }
    }
}

