/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.action.admin.cluster.stats.AnalysisStats;
import org.elasticsearch.action.admin.cluster.stats.FieldScriptStats;
import org.elasticsearch.action.admin.cluster.stats.FieldStats;
import org.elasticsearch.action.admin.cluster.stats.IndexFeatureStats;
import org.elasticsearch.action.admin.cluster.stats.MappingVisitor;
import org.elasticsearch.action.admin.cluster.stats.RuntimeFieldStats;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public final class MappingStats
implements ToXContentFragment,
Writeable {
    private static final Pattern DOC_PATTERN = Pattern.compile("doc[\\[.]");
    private static final Pattern SOURCE_PATTERN = Pattern.compile("params\\._source");
    private final List<FieldStats> fieldTypeStats;
    private final List<RuntimeFieldStats> runtimeFieldStats;

    public static MappingStats of(Metadata metadata, Runnable ensureNotCancelled) {
        HashMap fieldTypes = new HashMap();
        HashSet concreteFieldNames = new HashSet();
        HashMap runtimeFieldTypes = new HashMap();
        IdentityHashMap<MappingMetadata, Integer> mappingCounts = new IdentityHashMap<MappingMetadata, Integer>(metadata.getMappingsByHash().size());
        for (IndexMetadata indexMetadata : metadata) {
            if (indexMetadata.isSystem()) continue;
            AnalysisStats.countMapping(mappingCounts, indexMetadata);
        }
        for (Map.Entry entry : mappingCounts.entrySet()) {
            ensureNotCancelled.run();
            HashSet indexFieldTypes = new HashSet();
            HashSet indexRuntimeFieldTypes = new HashSet();
            int count = (Integer)entry.getValue();
            Map<String, Object> map = ((MappingMetadata)entry.getKey()).getSourceAsMap();
            MappingVisitor.visitMapping(map, (field, fieldMapping) -> {
                concreteFieldNames.add(field);
                String type = null;
                Object typeO = fieldMapping.get("type");
                if (typeO != null) {
                    type = typeO.toString();
                } else if (fieldMapping.containsKey("properties")) {
                    type = "object";
                }
                if (type != null) {
                    Object scriptObject;
                    FieldStats stats = fieldTypes.computeIfAbsent(type, FieldStats::new);
                    stats.count += count;
                    if (indexFieldTypes.add(type)) {
                        stats.indexCount += count;
                    }
                    if ((scriptObject = fieldMapping.get("script")) instanceof Map) {
                        Map script = (Map)scriptObject;
                        Object sourceObject = script.get("source");
                        stats.scriptCount += count;
                        MappingStats.updateScriptParams(sourceObject, stats.fieldScriptStats, count);
                        Object langObject = script.get("lang");
                        if (langObject != null) {
                            stats.scriptLangs.add(langObject.toString());
                        }
                    }
                }
            });
            MappingVisitor.visitRuntimeMapping(map, (field, fieldMapping) -> {
                Object scriptObject;
                Object typeObject = fieldMapping.get("type");
                if (typeObject == null) {
                    return;
                }
                String type = typeObject.toString();
                RuntimeFieldStats stats = runtimeFieldTypes.computeIfAbsent(type, RuntimeFieldStats::new);
                stats.count += count;
                if (indexRuntimeFieldTypes.add(type)) {
                    stats.indexCount += count;
                }
                if (concreteFieldNames.contains(field)) {
                    stats.shadowedCount += (long)count;
                }
                if ((scriptObject = fieldMapping.get("script")) == null) {
                    stats.scriptLessCount += (long)count;
                } else if (scriptObject instanceof Map) {
                    Map script = (Map)scriptObject;
                    Object sourceObject = script.get("source");
                    MappingStats.updateScriptParams(sourceObject, stats.fieldScriptStats, count);
                    Object langObject = script.get("lang");
                    if (langObject != null) {
                        stats.scriptLangs.add(langObject.toString());
                    }
                }
            });
        }
        return new MappingStats(fieldTypes.values(), runtimeFieldTypes.values());
    }

    private static void updateScriptParams(Object scriptSourceObject, FieldScriptStats scriptStats, int multiplier) {
        if (scriptSourceObject != null) {
            String scriptSource = scriptSourceObject.toString();
            int chars = scriptSource.length();
            long lines = scriptSource.lines().count();
            int docUsages = MappingStats.countOccurrences(scriptSource, DOC_PATTERN);
            int sourceUsages = MappingStats.countOccurrences(scriptSource, SOURCE_PATTERN);
            scriptStats.update(chars, lines, sourceUsages, docUsages, multiplier);
        }
    }

    private static int countOccurrences(String script, Pattern pattern) {
        int occurrences = 0;
        Matcher matcher = pattern.matcher(script);
        while (matcher.find()) {
            ++occurrences;
        }
        return occurrences;
    }

    MappingStats(Collection<FieldStats> fieldTypeStats, Collection<RuntimeFieldStats> runtimeFieldStats) {
        ArrayList<FieldStats> stats = new ArrayList<FieldStats>(fieldTypeStats);
        stats.sort(Comparator.comparing(IndexFeatureStats::getName));
        this.fieldTypeStats = Collections.unmodifiableList(stats);
        ArrayList<RuntimeFieldStats> runtimeStats = new ArrayList<RuntimeFieldStats>(runtimeFieldStats);
        runtimeStats.sort(Comparator.comparing(RuntimeFieldStats::type));
        this.runtimeFieldStats = Collections.unmodifiableList(runtimeStats);
    }

    MappingStats(StreamInput in) throws IOException {
        this.fieldTypeStats = Collections.unmodifiableList(in.readList(FieldStats::new));
        this.runtimeFieldStats = Collections.unmodifiableList(in.readList(RuntimeFieldStats::new));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.fieldTypeStats);
        out.writeCollection(this.runtimeFieldStats);
    }

    public List<FieldStats> getFieldTypeStats() {
        return this.fieldTypeStats;
    }

    public List<RuntimeFieldStats> getRuntimeFieldStats() {
        return this.runtimeFieldStats;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("mappings");
        builder.startArray("field_types");
        for (IndexFeatureStats indexFeatureStats : this.fieldTypeStats) {
            indexFeatureStats.toXContent(builder, params);
        }
        builder.endArray();
        builder.startArray("runtime_field_types");
        for (RuntimeFieldStats runtimeFieldStats : this.runtimeFieldStats) {
            runtimeFieldStats.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MappingStats)) {
            return false;
        }
        MappingStats that = (MappingStats)o;
        return this.fieldTypeStats.equals(that.fieldTypeStats) && this.runtimeFieldStats.equals(that.runtimeFieldStats);
    }

    public int hashCode() {
        return Objects.hash(this.fieldTypeStats, this.runtimeFieldStats);
    }
}

