/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.desirednodes;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class UpdateDesiredNodesResponse
extends ActionResponse
implements ToXContentObject {
    private final boolean replacedExistingHistoryId;

    public UpdateDesiredNodesResponse(boolean replacedExistingHistoryId) {
        this.replacedExistingHistoryId = replacedExistingHistoryId;
    }

    public UpdateDesiredNodesResponse(StreamInput in) throws IOException {
        super(in);
        this.replacedExistingHistoryId = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.replacedExistingHistoryId);
    }

    public boolean hasReplacedExistingHistoryId() {
        return this.replacedExistingHistoryId;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("replaced_existing_history_id", this.replacedExistingHistoryId);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateDesiredNodesResponse that = (UpdateDesiredNodesResponse)o;
        return this.replacedExistingHistoryId == that.replacedExistingHistoryId;
    }

    public int hashCode() {
        return Objects.hash(this.replacedExistingHistoryId);
    }
}

