/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.desirednodes;

import java.util.Locale;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.desirednodes.DesiredNodesClusterStateTaskExecutor;
import org.elasticsearch.action.admin.cluster.desirednodes.UpdateDesiredNodesRequest;
import org.elasticsearch.action.admin.cluster.desirednodes.UpdateDesiredNodesResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.desirednodes.DesiredNodesSettingsValidator;
import org.elasticsearch.cluster.desirednodes.VersionConflictException;
import org.elasticsearch.cluster.metadata.DesiredNodes;
import org.elasticsearch.cluster.metadata.DesiredNodesMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportUpdateDesiredNodesAction
extends TransportMasterNodeAction<UpdateDesiredNodesRequest, UpdateDesiredNodesResponse> {
    private final DesiredNodesSettingsValidator settingsValidator;
    private final ClusterStateTaskExecutor<ClusterStateUpdateTask> taskExecutor;

    @Inject
    public TransportUpdateDesiredNodesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, DesiredNodesSettingsValidator settingsValidator) {
        super("cluster:admin/desired_nodes/update", false, transportService, clusterService, threadPool, actionFilters, UpdateDesiredNodesRequest::new, indexNameExpressionResolver, UpdateDesiredNodesResponse::new, "same");
        this.settingsValidator = settingsValidator;
        this.taskExecutor = new DesiredNodesClusterStateTaskExecutor();
    }

    @Override
    protected ClusterBlockException checkBlock(UpdateDesiredNodesRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected void masterOperation(Task task, final UpdateDesiredNodesRequest request, ClusterState state, final ActionListener<UpdateDesiredNodesResponse> listener) throws Exception {
        try {
            DesiredNodes proposedDesiredNodes = new DesiredNodes(request.getHistoryID(), request.getVersion(), request.getNodes());
            this.settingsValidator.validate(proposedDesiredNodes);
            this.clusterService.submitStateUpdateTask("update-desired-nodes", new ClusterStateUpdateTask(Priority.URGENT, request.masterNodeTimeout()){
                volatile boolean replacedExistingHistoryId;
                {
                    super(priority, timeout);
                    this.replacedExistingHistoryId = false;
                }

                @Override
                public ClusterState execute(ClusterState currentState) {
                    ClusterState updatedState = TransportUpdateDesiredNodesAction.updateDesiredNodes(currentState, request);
                    DesiredNodes previousDesiredNodes = DesiredNodesMetadata.latestFromClusterState(currentState);
                    DesiredNodes latestDesiredNodes = DesiredNodesMetadata.latestFromClusterState(updatedState);
                    this.replacedExistingHistoryId = previousDesiredNodes != null && !previousDesiredNodes.hasSameHistoryId(latestDesiredNodes);
                    return updatedState;
                }

                @Override
                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }

                @Override
                public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                    listener.onResponse(new UpdateDesiredNodesResponse(this.replacedExistingHistoryId));
                }
            }, this.taskExecutor);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    static ClusterState updateDesiredNodes(ClusterState currentState, UpdateDesiredNodesRequest request) {
        DesiredNodesMetadata desiredNodesMetadata = currentState.metadata().custom("desired_nodes", DesiredNodesMetadata.EMPTY);
        DesiredNodes latestDesiredNodes = desiredNodesMetadata.getLatestDesiredNodes();
        DesiredNodes proposedDesiredNodes = new DesiredNodes(request.getHistoryID(), request.getVersion(), request.getNodes());
        if (latestDesiredNodes != null) {
            if (latestDesiredNodes.equals(proposedDesiredNodes)) {
                return currentState;
            }
            if (latestDesiredNodes.hasSameVersion(proposedDesiredNodes)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Desired nodes with history [%s] and version [%d] already exists with a different definition", latestDesiredNodes.historyID(), latestDesiredNodes.version()));
            }
            if (!latestDesiredNodes.isSupersededBy(proposedDesiredNodes)) {
                throw new VersionConflictException("version [{}] has been superseded by version [{}] for history [{}]", proposedDesiredNodes.version(), latestDesiredNodes.version(), latestDesiredNodes.historyID());
            }
        }
        return currentState.copyAndUpdateMetadata(metadata -> metadata.putCustom("desired_nodes", new DesiredNodesMetadata(proposedDesiredNodes)));
    }
}

