/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule.tool;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.cli.LoggingAwareCommand;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.xpack.core.scheduler.Cron;

public class CronEvalTool
extends LoggingAwareCommand {
    private static final DateFormatter UTC_FORMATTER = DateFormatter.forPattern((String)"EEE, d MMM yyyy HH:mm:ss").withZone((ZoneId)ZoneOffset.UTC).withLocale(Locale.ROOT);
    private static final DateFormatter LOCAL_FORMATTER = DateFormatter.forPattern((String)"EEE, d MMM yyyy HH:mm:ss Z").withZone(ZoneId.systemDefault());
    private final OptionSpec<Integer> countOption;
    private final OptionSpec<String> arguments;
    private final OptionSpec<Void> detailOption;

    public static void main(String[] args) throws Exception {
        CronEvalTool.exit((int)new CronEvalTool().main(args, Terminal.DEFAULT));
    }

    CronEvalTool() {
        super("Validates and evaluates a cron expression");
        this.countOption = this.parser.acceptsAll(Arrays.asList("c", "count"), "The number of future times this expression will be triggered").withRequiredArg().ofType(Integer.class).defaultsTo((Object)10, (Object[])new Integer[0]);
        this.arguments = this.parser.nonOptions("expression");
        this.detailOption = this.parser.acceptsAll(Arrays.asList("d", "detail"), "Show detail for invalid cron expression");
        this.parser.accepts("E", "Unused. Only for compatibility with other CLI tools.").withRequiredArg();
    }

    protected void execute(Terminal terminal, OptionSet options) throws Exception {
        int count = (Integer)this.countOption.value(options);
        List args = this.arguments.values(options);
        if (args.size() != 1) {
            throw new UserException(64, "expecting a single argument that is the cron expression to evaluate, got " + args);
        }
        boolean printDetail = options.has(this.detailOption);
        this.execute(terminal, (String)args.get(0), count, printDetail);
    }

    private void execute(Terminal terminal, String expression, int count, boolean printDetail) throws Exception {
        try {
            Cron.validate((String)expression);
            terminal.println((CharSequence)"Valid!");
            ZonedDateTime date = ZonedDateTime.now(ZoneOffset.UTC);
            boolean isLocalTimeUTC = UTC_FORMATTER.zone().equals(LOCAL_FORMATTER.zone());
            if (isLocalTimeUTC) {
                terminal.println((CharSequence)("Now is [" + UTC_FORMATTER.format((TemporalAccessor)date) + "] in UTC"));
            } else {
                terminal.println((CharSequence)("Now is [" + UTC_FORMATTER.format((TemporalAccessor)date) + "] in UTC, local time is [" + LOCAL_FORMATTER.format((TemporalAccessor)date) + "]"));
            }
            terminal.println((CharSequence)("Here are the next " + count + " times this cron expression will trigger:"));
            Cron cron = new Cron(expression);
            long time = date.toInstant().toEpochMilli();
            for (int i = 0; i < count; ++i) {
                long prevTime = time;
                if ((time = cron.getNextValidTimeAfter(time)) < 0L) {
                    if (i == 0) {
                        throw new UserException(0, "Could not compute future times since [" + UTC_FORMATTER.format((TemporalAccessor)Instant.ofEpochMilli(prevTime)) + "] (perhaps the cron expression only points to times in the past?)");
                    }
                    break;
                }
                if (isLocalTimeUTC) {
                    terminal.println((CharSequence)(i + 1 + ".\t" + UTC_FORMATTER.format((TemporalAccessor)Instant.ofEpochMilli(time))));
                    continue;
                }
                terminal.println((CharSequence)(i + 1 + ".\t" + UTC_FORMATTER.format((TemporalAccessor)Instant.ofEpochMilli(time))));
                terminal.println((CharSequence)("\t" + LOCAL_FORMATTER.format((TemporalAccessor)Instant.ofEpochMilli(time))));
            }
        }
        catch (Exception e) {
            if (printDetail) {
                throw e;
            }
            throw new UserException(0, e.getMessage() + (String)(e.getCause() == null ? "" : ": " + e.getCause().getMessage()));
        }
    }
}

