/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.watcher.WatcherMetadata;
import org.elasticsearch.xpack.core.watcher.transport.actions.service.WatcherServiceRequest;

public class TransportWatcherServiceAction
extends AcknowledgedTransportMasterNodeAction<WatcherServiceRequest> {
    private static final Logger logger = LogManager.getLogger(TransportWatcherServiceAction.class);

    @Inject
    public TransportWatcherServiceAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/xpack/watcher/service", transportService, clusterService, threadPool, actionFilters, WatcherServiceRequest::new, indexNameExpressionResolver, "management");
    }

    protected void masterOperation(Task task, final WatcherServiceRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        final boolean manuallyStopped = request.getCommand() == WatcherServiceRequest.Command.STOP;
        final String source = manuallyStopped ? "update_watcher_manually_stopped" : "update_watcher_manually_started";
        this.clusterService.submitStateUpdateTask(source, (ClusterStateTaskConfig)new AckedClusterStateUpdateTask(new AckedRequest(){

            public TimeValue ackTimeout() {
                return AcknowledgedRequest.DEFAULT_ACK_TIMEOUT;
            }

            public TimeValue masterNodeTimeout() {
                return request.masterNodeTimeout();
            }
        }, listener){

            public ClusterState execute(ClusterState clusterState) {
                XPackPlugin.checkReadyForXPackCustomMetadata((ClusterState)clusterState);
                WatcherMetadata newWatcherMetadata = new WatcherMetadata(manuallyStopped);
                WatcherMetadata currentMetadata = (WatcherMetadata)clusterState.metadata().custom("watcher");
                if (newWatcherMetadata.equals((Object)currentMetadata)) {
                    return clusterState;
                }
                ClusterState.Builder builder = new ClusterState.Builder(clusterState);
                builder.metadata(Metadata.builder((Metadata)clusterState.getMetadata()).putCustom("watcher", (Metadata.Custom)newWatcherMetadata));
                return builder.build();
            }

            public void onFailure(Exception e) {
                logger.error((Message)new ParameterizedMessage("could not update watcher stopped status to [{}], source [{}]", (Object)manuallyStopped, (Object)source), (Throwable)e);
                listener.onFailure(e);
            }
        }, ClusterStateTaskExecutor.unbatched());
    }

    protected ClusterBlockException checkBlock(WatcherServiceRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

