/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions;

import java.time.Clock;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.protocol.xpack.watcher.PutWatchRequest;
import org.elasticsearch.protocol.xpack.watcher.PutWatchResponse;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.core.watcher.watch.Watch;
import org.elasticsearch.xpack.watcher.ClockHolder;
import org.elasticsearch.xpack.watcher.transport.actions.WatcherTransportAction;
import org.elasticsearch.xpack.watcher.watch.WatchParser;

public class TransportPutWatchAction
extends WatcherTransportAction<PutWatchRequest, PutWatchResponse> {
    private final ThreadPool threadPool;
    private final Clock clock;
    private final WatchParser parser;
    private final Client client;
    private static final ToXContent.Params DEFAULT_PARAMS = WatcherParams.builder().hideSecrets(false).hideHeaders(false).includeStatus(true).build();

    @Inject
    public TransportPutWatchAction(TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, ClockHolder clockHolder, XPackLicenseState licenseState, WatchParser parser, Client client) {
        super("cluster:admin/xpack/watcher/watch/put", transportService, actionFilters, licenseState, PutWatchRequest::new);
        this.threadPool = threadPool;
        this.clock = clockHolder.clock;
        this.parser = parser;
        this.client = client;
    }

    @Override
    protected void doExecute(PutWatchRequest request, ActionListener<PutWatchResponse> listener) {
        try {
            ZonedDateTime now = this.clock.instant().atZone(ZoneOffset.UTC);
            boolean isUpdate = request.getVersion() > 0L || request.getIfSeqNo() != -2L;
            Watch watch = this.parser.parseWithSecrets(request.getId(), false, request.getSource(), now, request.xContentType(), isUpdate, request.getIfSeqNo(), request.getIfPrimaryTerm());
            watch.setState(request.isActive(), now);
            Map filteredHeaders = ClientHelper.filterSecurityHeaders((Map)this.threadPool.getThreadContext().getHeaders());
            watch.status().setHeaders(filteredHeaders);
            try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                watch.toXContent(builder, DEFAULT_PARAMS);
                if (isUpdate) {
                    UpdateRequest updateRequest = new UpdateRequest(".watches", request.getId());
                    if (request.getIfSeqNo() != -2L) {
                        updateRequest.setIfSeqNo(request.getIfSeqNo());
                        updateRequest.setIfPrimaryTerm(request.getIfPrimaryTerm());
                    } else {
                        updateRequest.version(request.getVersion());
                    }
                    updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                    updateRequest.doc(builder);
                    ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"watcher", (ActionRequest)updateRequest, (ActionListener)ActionListener.wrap(response -> {
                        boolean created = response.getResult() == DocWriteResponse.Result.CREATED;
                        listener.onResponse((Object)new PutWatchResponse(response.getId(), response.getVersion(), response.getSeqNo(), response.getPrimaryTerm(), created));
                    }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).update(arg_0, arg_1));
                } else {
                    IndexRequest indexRequest = new IndexRequest(".watches").id(request.getId());
                    indexRequest.source(builder);
                    indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                    ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"watcher", (ActionRequest)indexRequest, (ActionListener)ActionListener.wrap(response -> {
                        boolean created = response.getResult() == DocWriteResponse.Result.CREATED;
                        listener.onResponse((Object)new PutWatchResponse(response.getId(), response.getVersion(), response.getSeqNo(), response.getPrimaryTerm(), created));
                    }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1));
                }
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

